/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import javaemul.internal.InternalPreconditions;
import javaemul.internal.JsUtils;
import javaemul.internal.annotations.DoNotAutobox;
import jsinterop.annotations.JsType;

@JsType(namespace="vmbootstrap")
public class LongUtils {
    public static long fromBits(int lowBits, int highBits) {
        return NativeLong.fromBits(lowBits, highBits);
    }

    public static int compare(long a, long b) {
        return LongUtils.toNativeLong(a).compare(b);
    }

    public static long fromInt(int value) {
        return NativeLong.fromInt(value | 0);
    }

    public static long fromNumber(double value) {
        return NativeLong.fromNumber(value);
    }

    public static int toInt(long value) {
        return LongUtils.toNativeLong(value).toInt();
    }

    public static double toNumber(long value) {
        return LongUtils.toNativeLong(value).toNumber();
    }

    public static long bitAnd(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).and(rightLong);
    }

    public static long not(long valueLong) {
        return LongUtils.toNativeLong(valueLong).not();
    }

    public static long divide(long leftLong, long rightLong) {
        LongUtils.checkDivisorZero(rightLong);
        return LongUtils.toNativeLong(leftLong).div(rightLong);
    }

    public static boolean equals(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).equals(LongUtils.toNativeLong(rightLong));
    }

    public static boolean greater(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).greaterThan(rightLong);
    }

    public static boolean greaterEquals(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).greaterThanOrEqual(rightLong);
    }

    public static long leftShift(long valueLong, int numBits) {
        return LongUtils.toNativeLong(valueLong).shiftLeft(numBits);
    }

    public static boolean less(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).lessThan(rightLong);
    }

    public static boolean lessEquals(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).lessThanOrEqual(rightLong);
    }

    public static long minus(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).subtract(rightLong);
    }

    public static long negate(long valueLong) {
        return LongUtils.toNativeLong(valueLong).negate();
    }

    public static boolean notEquals(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).notEquals(rightLong);
    }

    public static long bitOr(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).or(rightLong);
    }

    public static long plus(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).add(rightLong);
    }

    public static long remainder(long leftLong, long rightLong) {
        LongUtils.checkDivisorZero(rightLong);
        return LongUtils.toNativeLong(leftLong).modulo(rightLong);
    }

    public static long rightShiftSigned(long valueLong, int numBits) {
        return LongUtils.toNativeLong(valueLong).shiftRight(numBits);
    }

    public static long rightShiftUnsigned(long valueLong, int numBits) {
        return LongUtils.toNativeLong(valueLong).shiftRightUnsigned(numBits);
    }

    public static long times(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).multiply(rightLong);
    }

    public static long bitXor(long leftLong, long rightLong) {
        return LongUtils.toNativeLong(leftLong).xor(rightLong);
    }

    public static int getHighBits(long valueLong) {
        return LongUtils.toNativeLong(valueLong).getHighBits();
    }

    public static int getLowBits(long valueLong) {
        return LongUtils.toNativeLong(valueLong).getLowBits();
    }

    public static String toString(long valueLong, int radix) {
        return LongUtils.toNativeLong(valueLong).toString(radix);
    }

    public static void checkDivisorZero(long divisor) {
        InternalPreconditions.checkArithmetic(!LongUtils.toNativeLong(divisor).isZero());
    }

    private static NativeLong toNativeLong(@DoNotAutobox Object l) {
        return (NativeLong)JsUtils.uncheckedCast(l);
    }

    @JsType(isNative=true, name="Long", namespace="nativebootstrap")
    static class NativeLong {
        NativeLong() {
        }

        public static native long fromBits(int var0, int var1);

        public static native long fromInt(int var0);

        public static native long fromNumber(double var0);

        public native long add(long var1);

        public native long and(long var1);

        public native int compare(long var1);

        public native long div(long var1);

        public native int getHighBits();

        public native int getLowBits();

        public native boolean greaterThan(long var1);

        public native boolean greaterThanOrEqual(long var1);

        public native boolean isZero();

        public native boolean lessThan(long var1);

        public native boolean lessThanOrEqual(long var1);

        public native long modulo(long var1);

        public native long multiply(long var1);

        public native long negate();

        public native long not();

        public native boolean notEquals(long var1);

        public native long or(long var1);

        public native long shiftLeft(int var1);

        public native long shiftRight(int var1);

        public native long shiftRightUnsigned(int var1);

        public native long subtract(long var1);

        public native int toInt();

        public native double toNumber();

        public native long xor(long var1);

        public native String toString(int var1);

        public native boolean equals(Object var1);
    }
}

