/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import javaemul.internal.HashCodes;
import javaemul.internal.JsUtils;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(namespace="vmbootstrap")
class Objects {
    Objects() {
    }

    static boolean equals(Object obj, Object other) {
        if (((ObjectLike)obj).hasEquals()) {
            return obj.equals(other);
        }
        Objects.assertEqualsAndHashCodePresentIfExpected(obj);
        return Objects.is(obj, other);
    }

    @JsMethod(name="Object.is", namespace="<global>")
    private static native boolean is(Object var0, Object var1);

    static int hashCode(Object obj) {
        if (((ObjectLike)obj).hasHashCode()) {
            return obj.hashCode();
        }
        Objects.assertEqualsAndHashCodePresentIfExpected(obj);
        return HashCodes.getIdentityHashCode(obj);
    }

    static String toString(Object obj) {
        return obj.toString();
    }

    static Class<?> getClass(Object obj) {
        switch (JsUtils.typeOf(obj)) {
            case "number": {
                return Double.class;
            }
            case "boolean": {
                return Boolean.class;
            }
            case "string": {
                return String.class;
            }
            case "function": {
                return JavaScriptFunction.class;
            }
        }
        if (obj instanceof JavaLangObject) {
            JavaLangObject jlObject = (JavaLangObject)obj;
            return jlObject.getClass();
        }
        if (obj instanceof JavaScriptObject[]) {
            Object[] array = (JavaScriptObject[])obj;
            return Objects.arrayGetClass(array);
        }
        if (obj != null) {
            return JavaScriptObject.class;
        }
        return Objects.throwTypeError();
    }

    @JsMethod
    private static native Class<?> throwTypeError();

    @JsMethod
    private static native void assertEqualsAndHashCodePresentIfExpected(Object var0);

    @JsMethod(name="$getClass", namespace="vmbootstrap.Arrays")
    private static native Class<?> arrayGetClass(Object[] var0);

    @JsType(isNative=true, name="Object", namespace="<global>")
    private static class JavaScriptObject {
        private JavaScriptObject() {
        }
    }

    @JsFunction
    private static interface JavaScriptFunction {
        public void fn();
    }

    @JsType(isNative=true, name="Object$impl", namespace="java.lang")
    private static class JavaLangObject {
        private JavaLangObject() {
        }
    }

    @JsType(isNative=true, name="*", namespace="<global>")
    private static interface ObjectLike {
        @JsProperty(name="hashCode")
        public boolean hasHashCode();

        @JsProperty(name="equals")
        public boolean hasEquals();
    }
}

