/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import javaemul.internal.LongUtils;
import javaemul.internal.annotations.HasNoSideEffects;

public final class Long
extends Number
implements Comparable<Long> {
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final int SIZE = 64;
    public static final int BYTES = 8;
    public static final Class<Long> TYPE;
    private final long value;

    public static int bitCount(long l) {
        int high = LongUtils.getHighBits(l);
        int low = (int)l;
        return Integer.bitCount(high) + Integer.bitCount(low);
    }

    public static int compare(long x, long y) {
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        return 0;
    }

    public static Long decode(String s) throws NumberFormatException {
        Number.__Decode decode = Long.__decodeNumberString(s);
        return Long.valueOf(decode.payload, decode.radix);
    }

    public static int hashCode(long l) {
        return LongUtils.getHighBits(l) ^ (int)l;
    }

    public static long highestOneBit(long l) {
        int high = LongUtils.getHighBits(l);
        if (high != 0) {
            return LongUtils.fromBits(0, Integer.highestOneBit(high));
        }
        return LongUtils.fromBits(Integer.highestOneBit((int)l), 0);
    }

    public static long lowestOneBit(long i) {
        return i & -i;
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static int numberOfLeadingZeros(long l) {
        int high = LongUtils.getHighBits(l);
        if (high != 0) {
            return Integer.numberOfLeadingZeros(high);
        }
        return Integer.numberOfLeadingZeros((int)l) + 32;
    }

    public static int numberOfTrailingZeros(long l) {
        int low = (int)l;
        if (low != 0) {
            return Integer.numberOfTrailingZeros(low);
        }
        return Integer.numberOfTrailingZeros(LongUtils.getHighBits(l)) + 32;
    }

    public static long parseLong(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    public static long parseLong(String s, int radix) throws NumberFormatException {
        return Long.__parseAndValidateLong(s, radix);
    }

    public static long reverse(long l) {
        int high = LongUtils.getHighBits(l);
        int low = (int)l;
        return LongUtils.fromBits(Integer.reverse(high), Integer.reverse(low));
    }

    public static long reverseBytes(long l) {
        int high = LongUtils.getHighBits(l);
        int low = (int)l;
        return LongUtils.fromBits(Integer.reverseBytes(high), Integer.reverseBytes(low));
    }

    public static long rotateLeft(long i, int distance) {
        while (distance-- > 0) {
            i = i << 1 | (long)(i < 0L ? 1 : 0);
        }
        return i;
    }

    public static long rotateRight(long i, int distance) {
        long carry;
        long ui = i & Long.MAX_VALUE;
        long l = carry = i < 0L ? 0x4000000000000000L : 0L;
        while (distance-- > 0) {
            long nextcarry = ui & 1L;
            ui = carry | ui >> 1;
            carry = nextcarry == 0L ? 0L : 0x4000000000000000L;
        }
        if (carry != 0L) {
            ui |= Long.MIN_VALUE;
        }
        return ui;
    }

    public static int signum(long i) {
        if (i == 0L) {
            return 0;
        }
        if (i < 0L) {
            return -1;
        }
        return 1;
    }

    public static long sum(long a, long b) {
        return a + b;
    }

    public static String toBinaryString(long value) {
        return IntegralToString.longToBinaryString(value);
    }

    public static String toHexString(long value) {
        return IntegralToString.longToHexString(value);
    }

    public static String toOctalString(long value) {
        return IntegralToString.longToOctalString(value);
    }

    public static String toString(long value) {
        return IntegralToString.longToString(value);
    }

    public static String toString(long value, int intRadix) {
        return IntegralToString.longToString(value, intRadix);
    }

    public static Long valueOf(long l) {
        if (l > -129L && l < 128L) {
            return BoxedValues.get((int)l);
        }
        return new Long(l);
    }

    public static Long valueOf(String s) throws NumberFormatException {
        return Long.valueOf(s, 10);
    }

    public static Long valueOf(String s, int radix) throws NumberFormatException {
        return Long.parseLong(s, radix);
    }

    public Long(long value) {
        this.value = value;
    }

    public Long(String s) {
        this.value = Long.parseLong(s);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public int compareTo(Long b) {
        return Long.compare(this.value, b.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Long && ((Long)o).value == this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    static class BoxedValues {
        private static final Long[] boxedValues;

        BoxedValues() {
        }

        @HasNoSideEffects
        private static Long get(int i) {
            return boxedValues[i + 128];
        }

        static {
            Long[] values = new Long[256];
            for (int i = 0; i < 256; ++i) {
                values[i] = new Long(i - 128);
            }
            boxedValues = values;
        }
    }
}

