/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.Serializable;
import java.math.BigInteger;
import java.math.Conversion;
import java.math.MathContext;
import java.math.Multiplication;
import java.math.RoundingMode;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.NativeRegExp;
import jsinterop.annotations.JsMethod;

public class BigDecimal
extends Number
implements Comparable<BigDecimal>,
Serializable {
    private static final int SMALL_VALUE_BITS = 54;
    public static final BigDecimal ONE;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_UNNECESSARY = 7;
    public static final int ROUND_UP = 0;
    public static final BigDecimal TEN;
    public static final BigDecimal ZERO;
    private static NativeRegExp unscaledRegex;
    private static final int BI_SCALED_BY_ZERO_LENGTH = 11;
    private static final BigDecimal[] BI_SCALED_BY_ZERO;
    private static final char[] CH_ZEROS;
    private static final double[] DOUBLE_FIVE_POW;
    private static final int[] DOUBLE_FIVE_POW_BIT_LENGTH;
    private static final double[] DOUBLE_TEN_POW;
    private static final int[] DOUBLE_TEN_POW_BIT_LENGTH;
    private static final BigInteger[] FIVE_POW;
    private static final double LOG2 = 0.6931471805599453;
    private static final double LOG10_2 = 0.3010299956639812;
    private static final double POW47 = 1.40737488355328E14;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final BigInteger[] TEN_POW;
    private static final BigDecimal[] ZERO_SCALED_BY;
    private int bitLength;
    private int hashCode;
    private BigInteger intVal;
    private int precision;
    private double scale;
    private double smallValue;
    private String toStringImage;

    public static BigDecimal valueOf(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        return new BigDecimal(Double.toString(val));
    }

    public static BigDecimal valueOf(long unscaledVal) {
        if (unscaledVal >= 0L && unscaledVal < 11L) {
            return BI_SCALED_BY_ZERO[(int)unscaledVal];
        }
        return new BigDecimal(unscaledVal, 0);
    }

    public static BigDecimal valueOf(long unscaledVal, int scale) {
        if (scale == 0) {
            return BigDecimal.valueOf(unscaledVal);
        }
        if (unscaledVal == 0L && scale >= 0 && scale < ZERO_SCALED_BY.length) {
            return ZERO_SCALED_BY[scale];
        }
        return new BigDecimal(unscaledVal, scale);
    }

    private static BigDecimal addAndMult10(BigDecimal thisValue, BigDecimal augend, double diffScale) {
        if (diffScale < (double)DOUBLE_TEN_POW.length && Math.max(thisValue.bitLength, augend.bitLength + DOUBLE_TEN_POW_BIT_LENGTH[(int)diffScale]) + 1 < 54) {
            return BigDecimal.valueOf(thisValue.smallValue + augend.smallValue * DOUBLE_TEN_POW[(int)diffScale], thisValue.scale);
        }
        return new BigDecimal(thisValue.getUnscaledValue().add(Multiplication.multiplyByTenPow(augend.getUnscaledValue(), (int)diffScale)), thisValue.scale);
    }

    private static int bitLength(double value) {
        if (value > -1.40737488355328E14 && value < 1.40737488355328E14) {
            boolean negative;
            if (value == 0.0) {
                return 0;
            }
            boolean bl = negative = value < 0.0;
            if (negative) {
                value = -value;
            }
            int result = (int)Math.floor(Math.log(value) / 0.6931471805599453);
            if (!negative || value != Math.pow(2.0, result)) {
                ++result;
            }
            return result;
        }
        return BigDecimal.bitLength((long)value);
    }

    private static int bitLength(long value) {
        if (value < 0L) {
            value ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return 64 - Long.numberOfLeadingZeros(value);
    }

    private static BigDecimal divideBigIntegers(BigInteger scaledDividend, BigInteger scaledDivisor, int scale, RoundingMode roundingMode) {
        int compRem;
        BigInteger[] quotAndRem = scaledDividend.divideAndRemainder(scaledDivisor);
        BigInteger quotient = quotAndRem[0];
        BigInteger remainder = quotAndRem[1];
        if (remainder.signum() == 0) {
            return new BigDecimal(quotient, scale);
        }
        int sign = scaledDividend.signum() * scaledDivisor.signum();
        if (scaledDivisor.bitLength() < 54) {
            long rem = remainder.longValue();
            long divisor = scaledDivisor.longValue();
            compRem = Long.compare(Math.abs(rem) << 1, Math.abs(divisor));
            compRem = BigDecimal.roundingBehavior(quotient.testBit(0) ? 1 : 0, sign * (5 + compRem), roundingMode);
        } else {
            compRem = remainder.abs().shiftLeftOneBit().compareTo(scaledDivisor.abs());
            compRem = BigDecimal.roundingBehavior(quotient.testBit(0) ? 1 : 0, sign * (5 + compRem), roundingMode);
        }
        if (compRem != 0) {
            if (quotient.bitLength() < 54) {
                return BigDecimal.valueOf(quotient.longValue() + (long)compRem, scale);
            }
            quotient = quotient.add(BigInteger.valueOf(compRem));
            return new BigDecimal(quotient, scale);
        }
        return new BigDecimal(quotient, scale);
    }

    private static BigDecimal dividePrimitiveDoubles(double scaledDividend, double scaledDivisor, int scale, RoundingMode roundingMode) {
        double quotient = BigDecimal.intDivide(scaledDividend, scaledDivisor);
        double remainder = scaledDividend % scaledDivisor;
        int sign = Double.compare(scaledDividend * scaledDivisor, 0.0);
        if (remainder != 0.0) {
            int compRem = Double.compare(Math.abs(remainder) * 2.0, Math.abs(scaledDivisor));
            quotient += (double)BigDecimal.roundingBehavior((int)quotient & 1, sign * (5 + compRem), roundingMode);
        }
        return BigDecimal.valueOf(quotient, (double)scale);
    }

    private static double intDivide(double dividend, double divisor) {
        double quotient = dividend / divisor;
        return quotient > 0.0 ? Math.floor(quotient) : Math.ceil(quotient);
    }

    private static boolean isValidBigUnscaledDecimal(String str) {
        if (unscaledRegex == null) {
            unscaledRegex = new NativeRegExp("^[+-]?\\d*$", "i");
        }
        return unscaledRegex.test(str);
    }

    private static double parseUnscaled(String str) {
        return BigDecimal.isValidBigUnscaledDecimal(str) ? Double.parseDouble(str) : Double.NaN;
    }

    private static int roundingBehavior(int parityBit, int fraction, RoundingMode roundingMode) {
        int increment = 0;
        switch (roundingMode) {
            case UNNECESSARY: {
                if (fraction == 0) break;
                throw new ArithmeticException("Rounding necessary");
            }
            case UP: {
                increment = Integer.signum(fraction);
                break;
            }
            case DOWN: {
                break;
            }
            case CEILING: {
                increment = Math.max(Integer.signum(fraction), 0);
                break;
            }
            case FLOOR: {
                increment = Math.min(Integer.signum(fraction), 0);
                break;
            }
            case HALF_UP: {
                if (Math.abs(fraction) < 5) break;
                increment = Integer.signum(fraction);
                break;
            }
            case HALF_DOWN: {
                if (Math.abs(fraction) <= 5) break;
                increment = Integer.signum(fraction);
                break;
            }
            case HALF_EVEN: {
                if (Math.abs(fraction) + parityBit <= 5) break;
                increment = Integer.signum(fraction);
            }
        }
        return increment;
    }

    private static int toIntScale(double doubleScale) {
        if (doubleScale < -2.147483648E9) {
            throw new ArithmeticException("Overflow");
        }
        if (doubleScale > 2.147483647E9) {
            throw new ArithmeticException("Underflow");
        }
        return (int)doubleScale;
    }

    private static BigDecimal valueOf(double smallValue, double scale) {
        return new BigDecimal(smallValue, scale);
    }

    private static BigDecimal zeroScaledBy(double doubleScale) {
        if (doubleScale == (double)((int)doubleScale)) {
            return BigDecimal.valueOf(0L, (int)doubleScale);
        }
        if (doubleScale >= 0.0) {
            return new BigDecimal(0L, Integer.MAX_VALUE);
        }
        return new BigDecimal(0L, Integer.MIN_VALUE);
    }

    public BigDecimal(BigInteger val) {
        this(val, 0);
    }

    public BigDecimal(BigInteger unscaledVal, int scale) {
        this(unscaledVal, (double)scale);
    }

    public BigDecimal(BigInteger unscaledVal, int scale, MathContext mc) {
        this(unscaledVal, scale);
        this.inplaceRound(mc);
    }

    public BigDecimal(BigInteger val, MathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public BigDecimal(char[] in) {
        this(in, 0, in.length);
    }

    public BigDecimal(char[] in, int offset, int len) {
        try {
            this.initFrom(new String(in, offset, len));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    public BigDecimal(char[] in, int offset, int len, MathContext mc) {
        this(in, offset, len);
        this.inplaceRound(mc);
    }

    public BigDecimal(char[] in, MathContext mc) {
        this(in, 0, in.length);
        this.inplaceRound(mc);
    }

    public BigDecimal(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        this.initFrom(BigDecimal.toPrecision(val, 20));
    }

    @JsMethod(name="Number.prototype.toPrecision.call", namespace="<global>")
    private static native String toPrecision(double var0, int var2);

    public BigDecimal(double val, MathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public BigDecimal(int val) {
        this((long)val, 0);
    }

    public BigDecimal(int val, MathContext mc) {
        this((long)val, 0);
        this.inplaceRound(mc);
    }

    public BigDecimal(long val) {
        this(val, 0);
    }

    public BigDecimal(long val, MathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public BigDecimal(String val) {
        this.initFrom(val);
    }

    public BigDecimal(String val, MathContext mc) {
        this(val.toCharArray(), 0, val.length());
        this.inplaceRound(mc);
    }

    private BigDecimal(BigInteger unscaledVal, double scale) {
        this.scale = scale;
        this.setUnscaledValue(InternalPreconditions.checkNotNull(unscaledVal));
    }

    private BigDecimal(double smallValue, double scale) {
        this.smallValue = smallValue;
        this.scale = scale;
        this.bitLength = BigDecimal.bitLength(smallValue);
    }

    private BigDecimal(long smallValue, int scale) {
        this.scale = scale;
        this.bitLength = BigDecimal.bitLength(smallValue);
        if (this.bitLength < 54) {
            this.smallValue = smallValue;
        } else {
            this.intVal = BigInteger.valueOf(smallValue);
        }
    }

    public BigDecimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public BigDecimal abs(MathContext mc) {
        return this.round(mc).abs();
    }

    public BigDecimal add(BigDecimal augend) {
        double diffScale = this.scale - augend.scale;
        if (this.isZero()) {
            if (diffScale <= 0.0) {
                return augend;
            }
            if (augend.isZero()) {
                return this;
            }
        } else if (augend.isZero() && diffScale >= 0.0) {
            return this;
        }
        if (diffScale == 0.0) {
            if (Math.max(this.bitLength, augend.bitLength) + 1 < 54) {
                return BigDecimal.valueOf(this.smallValue + augend.smallValue, this.scale);
            }
            return new BigDecimal(this.getUnscaledValue().add(augend.getUnscaledValue()), this.scale);
        }
        if (diffScale > 0.0) {
            return BigDecimal.addAndMult10(this, augend, diffScale);
        }
        return BigDecimal.addAndMult10(augend, this, -diffScale);
    }

    public BigDecimal add(BigDecimal augend, MathContext mc) {
        BigInteger tempBI;
        BigDecimal smaller;
        BigDecimal larger;
        double diffScale = this.scale - augend.scale;
        if (augend.isZero() || this.isZero() || mc.getPrecision() == 0) {
            return this.add(augend).round(mc);
        }
        if (this.approxPrecision() < diffScale - 1.0) {
            larger = augend;
            smaller = this;
        } else if (augend.approxPrecision() < -diffScale - 1.0) {
            larger = this;
            smaller = augend;
        } else {
            return this.add(augend).round(mc);
        }
        if ((double)mc.getPrecision() >= larger.approxPrecision()) {
            return this.add(augend).round(mc);
        }
        int largerSignum = larger.signum();
        if (largerSignum == smaller.signum()) {
            tempBI = Multiplication.multiplyByPositiveInt(larger.getUnscaledValue(), 10).add(BigInteger.valueOf(largerSignum));
        } else {
            tempBI = larger.getUnscaledValue().subtract(BigInteger.valueOf(largerSignum));
            tempBI = Multiplication.multiplyByPositiveInt(tempBI, 10).add(BigInteger.valueOf(largerSignum * 9));
        }
        larger = new BigDecimal(tempBI, larger.scale + 1.0);
        return larger.round(mc);
    }

    public byte byteValueExact() {
        return (byte)this.valueExact(8);
    }

    @Override
    public int compareTo(BigDecimal val) {
        int valueSign;
        int thisSign = this.signum();
        if (thisSign == (valueSign = val.signum())) {
            if (this.scale == val.scale && this.bitLength < 54 && val.bitLength < 54) {
                return this.smallValue < val.smallValue ? -1 : (this.smallValue > val.smallValue ? 1 : 0);
            }
            double diffScale = this.scale - val.scale;
            double diffPrecision = this.approxPrecision() - val.approxPrecision();
            if (diffPrecision > diffScale + 1.0) {
                return thisSign;
            }
            if (diffPrecision < diffScale - 1.0) {
                return -thisSign;
            }
            BigInteger thisUnscaled = this.getUnscaledValue();
            BigInteger valUnscaled = val.getUnscaledValue();
            if (diffScale < 0.0) {
                thisUnscaled = thisUnscaled.multiply(Multiplication.powerOf10(-diffScale));
            } else if (diffScale > 0.0) {
                valUnscaled = valUnscaled.multiply(Multiplication.powerOf10(diffScale));
            }
            return thisUnscaled.compareTo(valUnscaled);
        }
        if (thisSign < valueSign) {
            return -1;
        }
        return 1;
    }

    public BigDecimal divide(BigDecimal divisor) {
        BigInteger p = this.getUnscaledValue();
        BigInteger q = divisor.getUnscaledValue();
        double diffScale = this.scale - divisor.scale;
        int l = 0;
        int i = 1;
        int lastPow = FIVE_POW.length - 1;
        if (divisor.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        if (p.signum() == 0) {
            return BigDecimal.zeroScaledBy(diffScale);
        }
        BigInteger gcd = p.gcd(q);
        p = p.divide(gcd);
        q = q.divide(gcd);
        int k = q.getLowestSetBit();
        q = q.shiftRight(k);
        while (true) {
            BigInteger[] quotAndRem;
            if ((quotAndRem = q.divideAndRemainder(FIVE_POW[i]))[1].signum() == 0) {
                l += i;
                if (i < lastPow) {
                    ++i;
                }
                q = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        if (!q.abs().equals(BigInteger.ONE)) {
            throw new ArithmeticException("Non-terminating decimal expansion; no exact representable decimal result");
        }
        if (q.signum() < 0) {
            p = p.negate();
        }
        int newScale = BigDecimal.toIntScale(diffScale + (double)Math.max(k, l));
        i = k - l;
        p = i > 0 ? Multiplication.multiplyByFivePow(p, i) : p.shiftLeft(-i);
        return new BigDecimal(p, newScale);
    }

    public BigDecimal divide(BigDecimal divisor, int roundingMode) {
        return this.divide(divisor, (int)this.scale, RoundingMode.valueOf(roundingMode));
    }

    public BigDecimal divide(BigDecimal divisor, int scale, int roundingMode) {
        return this.divide(divisor, scale, RoundingMode.valueOf(roundingMode));
    }

    public BigDecimal divide(BigDecimal divisor, int scale, RoundingMode roundingMode) {
        InternalPreconditions.checkNotNull(roundingMode);
        if (divisor.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        double diffScale = this.scale - divisor.scale - (double)scale;
        if (this.bitLength < 54 && divisor.bitLength < 54) {
            if (diffScale == 0.0) {
                return BigDecimal.dividePrimitiveDoubles(this.smallValue, divisor.smallValue, scale, roundingMode);
            }
            if (diffScale > 0.0) {
                if (diffScale < (double)DOUBLE_TEN_POW.length && divisor.bitLength + DOUBLE_TEN_POW_BIT_LENGTH[(int)diffScale] < 54) {
                    return BigDecimal.dividePrimitiveDoubles(this.smallValue, divisor.smallValue * DOUBLE_TEN_POW[(int)diffScale], scale, roundingMode);
                }
            } else if (-diffScale < (double)DOUBLE_TEN_POW.length && this.bitLength + DOUBLE_TEN_POW_BIT_LENGTH[(int)(-diffScale)] < 54) {
                return BigDecimal.dividePrimitiveDoubles(this.smallValue * DOUBLE_TEN_POW[(int)(-diffScale)], divisor.smallValue, scale, roundingMode);
            }
        }
        BigInteger scaledDividend = this.getUnscaledValue();
        BigInteger scaledDivisor = divisor.getUnscaledValue();
        if (diffScale > 0.0) {
            scaledDivisor = Multiplication.multiplyByTenPow(scaledDivisor, (int)diffScale);
        } else if (diffScale < 0.0) {
            scaledDividend = Multiplication.multiplyByTenPow(scaledDividend, (int)(-diffScale));
        }
        return BigDecimal.divideBigIntegers(scaledDividend, scaledDivisor, scale, roundingMode);
    }

    public BigDecimal divide(BigDecimal divisor, MathContext mc) {
        double diffScale;
        double traillingZeros = (double)((long)mc.getPrecision() + 2L) + divisor.approxPrecision() - this.approxPrecision();
        double newScale = diffScale = this.scale - divisor.scale;
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        BigInteger[] quotAndRem = new BigInteger[]{this.getUnscaledValue()};
        if (mc.getPrecision() == 0 || this.isZero() || divisor.isZero()) {
            return this.divide(divisor);
        }
        if (traillingZeros > 0.0) {
            quotAndRem[0] = this.getUnscaledValue().multiply(Multiplication.powerOf10(traillingZeros));
            newScale += traillingZeros;
        }
        quotAndRem = quotAndRem[0].divideAndRemainder(divisor.getUnscaledValue());
        BigInteger integerQuot = quotAndRem[0];
        if (quotAndRem[1].signum() != 0) {
            int compRem = quotAndRem[1].shiftLeftOneBit().compareTo(divisor.getUnscaledValue());
            integerQuot = integerQuot.multiply(BigInteger.TEN).add(BigInteger.valueOf(quotAndRem[0].signum() * (5 + compRem)));
            newScale += 1.0;
        } else {
            while (!integerQuot.testBit(0)) {
                quotAndRem = integerQuot.divideAndRemainder(TEN_POW[i]);
                if (quotAndRem[1].signum() == 0 && newScale - (double)i >= diffScale) {
                    newScale -= (double)i;
                    if (i < lastPow) {
                        ++i;
                    }
                    integerQuot = quotAndRem[0];
                    continue;
                }
                if (i == 1) break;
                i = 1;
            }
        }
        return new BigDecimal(integerQuot, BigDecimal.toIntScale(newScale), mc);
    }

    public BigDecimal divide(BigDecimal divisor, RoundingMode roundingMode) {
        return this.divide(divisor, (int)this.scale, roundingMode);
    }

    public BigDecimal[] divideAndRemainder(BigDecimal divisor) {
        BigDecimal[] quotAndRem;
        quotAndRem = new BigDecimal[]{this.divideToIntegralValue(divisor), this.subtract(quotAndRem[0].multiply(divisor))};
        return quotAndRem;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal divisor, MathContext mc) {
        BigDecimal[] quotAndRem;
        quotAndRem = new BigDecimal[]{this.divideToIntegralValue(divisor, mc), this.subtract(quotAndRem[0].multiply(divisor))};
        return quotAndRem;
    }

    public BigDecimal divideToIntegralValue(BigDecimal divisor) {
        BigInteger integralValue;
        BigInteger[] quotAndRem = new BigInteger[]{this.getUnscaledValue()};
        double newScale = this.scale - divisor.scale;
        double tempScale = 0.0;
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        if (divisor.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        if (divisor.approxPrecision() + newScale > this.approxPrecision() + 1.0 || this.isZero()) {
            integralValue = BigInteger.ZERO;
        } else if (newScale == 0.0) {
            integralValue = this.getUnscaledValue().divide(divisor.getUnscaledValue());
        } else if (newScale > 0.0) {
            BigInteger powerOfTen = Multiplication.powerOf10(newScale);
            integralValue = this.getUnscaledValue().divide(divisor.getUnscaledValue().multiply(powerOfTen));
            integralValue = integralValue.multiply(powerOfTen);
        } else {
            BigInteger powerOfTen = Multiplication.powerOf10(-newScale);
            integralValue = this.getUnscaledValue().multiply(powerOfTen).divide(divisor.getUnscaledValue());
            while (!integralValue.testBit(0)) {
                quotAndRem = integralValue.divideAndRemainder(TEN_POW[i]);
                if (quotAndRem[1].signum() == 0 && tempScale - (double)i >= newScale) {
                    tempScale -= (double)i;
                    if (i < lastPow) {
                        ++i;
                    }
                    integralValue = quotAndRem[0];
                    continue;
                }
                if (i == 1) break;
                i = 1;
            }
            newScale = tempScale;
        }
        return integralValue.signum() == 0 ? BigDecimal.zeroScaledBy(newScale) : new BigDecimal(integralValue, BigDecimal.toIntScale(newScale));
    }

    public BigDecimal divideToIntegralValue(BigDecimal divisor, MathContext mc) {
        double diffScale;
        int mcPrecision = mc.getPrecision();
        int diffPrecision = this.precision() - divisor.precision();
        int lastPow = TEN_POW.length - 1;
        double newScale = diffScale = this.scale - divisor.scale;
        double quotPrecision = (double)diffPrecision - diffScale + 1.0;
        BigInteger[] quotAndRem = new BigInteger[2];
        if (mcPrecision == 0 || this.isZero() || divisor.isZero()) {
            return this.divideToIntegralValue(divisor);
        }
        if (quotPrecision <= 0.0) {
            quotAndRem[0] = BigInteger.ZERO;
        } else if (diffScale == 0.0) {
            quotAndRem[0] = this.getUnscaledValue().divide(divisor.getUnscaledValue());
        } else if (diffScale > 0.0) {
            quotAndRem[0] = this.getUnscaledValue().divide(divisor.getUnscaledValue().multiply(Multiplication.powerOf10(diffScale)));
            newScale = Math.min(diffScale, Math.max((double)mcPrecision - quotPrecision + 1.0, 0.0));
            quotAndRem[0] = quotAndRem[0].multiply(Multiplication.powerOf10(newScale));
        } else {
            double exp = Math.min(-diffScale, Math.max((double)mcPrecision - (double)diffPrecision, 0.0));
            quotAndRem = this.getUnscaledValue().multiply(Multiplication.powerOf10(exp)).divideAndRemainder(divisor.getUnscaledValue());
            newScale += exp;
            exp = -newScale;
            if (quotAndRem[1].signum() != 0 && exp > 0.0) {
                double compRemDiv = (double)new BigDecimal(quotAndRem[1]).precision() + exp - (double)divisor.precision();
                if (compRemDiv == 0.0) {
                    quotAndRem[1] = quotAndRem[1].multiply(Multiplication.powerOf10(exp)).divide(divisor.getUnscaledValue());
                    compRemDiv = Math.abs(quotAndRem[1].signum());
                }
                if (compRemDiv > 0.0) {
                    throw new ArithmeticException("Division impossible");
                }
            }
        }
        if (quotAndRem[0].signum() == 0) {
            return BigDecimal.zeroScaledBy(diffScale);
        }
        BigInteger strippedBI = quotAndRem[0];
        BigDecimal integralValue = new BigDecimal(quotAndRem[0]);
        int resultPrecision = integralValue.precision();
        int i = 1;
        while (!strippedBI.testBit(0)) {
            quotAndRem = strippedBI.divideAndRemainder(TEN_POW[i]);
            if (quotAndRem[1].signum() == 0 && (resultPrecision - i >= mcPrecision || newScale - (double)i >= diffScale)) {
                resultPrecision -= i;
                newScale -= (double)i;
                if (i < lastPow) {
                    ++i;
                }
                strippedBI = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        if (resultPrecision > mcPrecision) {
            throw new ArithmeticException("Division impossible");
        }
        integralValue.scale = BigDecimal.toIntScale(newScale);
        integralValue.setUnscaledValue(strippedBI);
        return integralValue;
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (x instanceof BigDecimal) {
            BigDecimal x1 = (BigDecimal)x;
            return this.scale == x1.scale && this.compareTo(x1) == 0;
        }
        return false;
    }

    @Override
    public float floatValue() {
        float floatResult = this.signum();
        double powerOfTwo = (double)this.bitLength - this.scale / 0.3010299956639812;
        floatResult = powerOfTwo < -149.0 || floatResult == 0.0f ? (floatResult *= 0.0f) : (powerOfTwo > 129.0 ? (floatResult *= Float.POSITIVE_INFINITY) : (float)this.doubleValue());
        return floatResult;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        if (this.bitLength < 54) {
            long longValue = (long)this.smallValue;
            this.hashCode = (int)(longValue & 0xFFFFFFFFFFFFFFFFL);
            this.hashCode = 33 * this.hashCode + (int)(longValue >> 32 & 0xFFFFFFFFFFFFFFFFL);
            this.hashCode = 17 * this.hashCode + (int)this.scale;
            return this.hashCode;
        }
        this.hashCode = 17 * this.intVal.hashCode() + (int)this.scale;
        return this.hashCode;
    }

    @Override
    public int intValue() {
        return this.scale <= -32.0 || this.scale > this.approxPrecision() ? 0 : this.toBigInteger().intValue();
    }

    public int intValueExact() {
        return (int)this.valueExact(32);
    }

    @Override
    public long longValue() {
        return this.scale <= -64.0 || this.scale > this.approxPrecision() ? 0L : this.toBigInteger().longValue();
    }

    public long longValueExact() {
        return this.valueExact(64);
    }

    public BigDecimal max(BigDecimal val) {
        return this.compareTo(val) >= 0 ? this : val;
    }

    public BigDecimal min(BigDecimal val) {
        return this.compareTo(val) <= 0 ? this : val;
    }

    public BigDecimal movePointLeft(int n) {
        return this.movePoint(this.scale + (double)n);
    }

    public BigDecimal movePointRight(int n) {
        return this.movePoint(this.scale - (double)n);
    }

    public BigDecimal multiply(BigDecimal multiplicand) {
        double newScale = this.scale + multiplicand.scale;
        if (this.isZero() || multiplicand.isZero()) {
            return BigDecimal.zeroScaledBy(newScale);
        }
        if (this.bitLength + multiplicand.bitLength < 54) {
            return BigDecimal.valueOf(this.smallValue * multiplicand.smallValue, (double)BigDecimal.toIntScale(newScale));
        }
        return new BigDecimal(this.getUnscaledValue().multiply(multiplicand.getUnscaledValue()), BigDecimal.toIntScale(newScale));
    }

    public BigDecimal multiply(BigDecimal multiplicand, MathContext mc) {
        BigDecimal result = this.multiply(multiplicand);
        result.inplaceRound(mc);
        return result;
    }

    public BigDecimal negate() {
        if (this.bitLength < 54) {
            return BigDecimal.valueOf(-this.smallValue, this.scale);
        }
        return new BigDecimal(this.getUnscaledValue().negate(), this.scale);
    }

    public BigDecimal negate(MathContext mc) {
        return this.round(mc).negate();
    }

    public BigDecimal plus() {
        return this;
    }

    public BigDecimal plus(MathContext mc) {
        return this.round(mc);
    }

    public BigDecimal pow(int n) {
        if (n == 0) {
            return ONE;
        }
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid Operation");
        }
        double newScale = this.scale * (double)n;
        return this.isZero() ? BigDecimal.zeroScaledBy(newScale) : new BigDecimal(this.getUnscaledValue().pow(n), BigDecimal.toIntScale(newScale));
    }

    public BigDecimal pow(int n, MathContext mc) {
        int m = Math.abs(n);
        int mcPrecision = mc.getPrecision();
        int elength = (int)Math.log10(m) + 1;
        MathContext newPrecision = mc;
        if (n == 0 || this.isZero() && n > 0) {
            return this.pow(n);
        }
        if (m > 999999999 || mcPrecision == 0 && n < 0 || mcPrecision > 0 && elength > mcPrecision) {
            throw new ArithmeticException("Invalid Operation");
        }
        if (mcPrecision > 0) {
            newPrecision = new MathContext(mcPrecision + elength + 1, mc.getRoundingMode());
        }
        BigDecimal accum = this.round(newPrecision);
        for (int oneBitMask = Integer.highestOneBit(m) >> 1; oneBitMask > 0; oneBitMask >>= 1) {
            accum = accum.multiply(accum, newPrecision);
            if ((m & oneBitMask) != oneBitMask) continue;
            accum = accum.multiply(this, newPrecision);
        }
        if (n < 0) {
            accum = ONE.divide(accum, newPrecision);
        }
        accum.inplaceRound(mc);
        return accum;
    }

    public int precision() {
        if (this.precision > 0) {
            return this.precision;
        }
        double decimalDigits = 1.0;
        double doubleUnsc = 1.0;
        if (this.bitLength < 54) {
            if (this.bitLength >= 1) {
                doubleUnsc = this.smallValue;
            }
            decimalDigits += Math.log10(Math.abs(doubleUnsc));
        } else if (this.getUnscaledValue().divide(Multiplication.powerOf10(decimalDigits += (double)(this.bitLength - 1) * 0.3010299956639812)).signum() != 0) {
            decimalDigits += 1.0;
        }
        this.precision = (int)decimalDigits;
        return this.precision;
    }

    public BigDecimal remainder(BigDecimal divisor) {
        return this.divideAndRemainder(divisor)[1];
    }

    public BigDecimal remainder(BigDecimal divisor, MathContext mc) {
        return this.divideAndRemainder(divisor, mc)[1];
    }

    public BigDecimal round(MathContext mc) {
        BigDecimal thisBD = new BigDecimal(this.getUnscaledValue(), this.scale);
        thisBD.inplaceRound(mc);
        return thisBD;
    }

    public int scale() {
        return (int)this.scale;
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        double newScale = this.scale - (double)n;
        if (this.bitLength < 54) {
            if (this.smallValue == 0.0) {
                return BigDecimal.zeroScaledBy(newScale);
            }
            return BigDecimal.valueOf(this.smallValue, (double)BigDecimal.toIntScale(newScale));
        }
        return new BigDecimal(this.getUnscaledValue(), BigDecimal.toIntScale(newScale));
    }

    public BigDecimal setScale(int newScale) {
        return this.setScale(newScale, RoundingMode.UNNECESSARY);
    }

    public BigDecimal setScale(int newScale, int roundingMode) {
        return this.setScale(newScale, RoundingMode.valueOf(roundingMode));
    }

    public BigDecimal setScale(int newScale, RoundingMode roundingMode) {
        InternalPreconditions.checkNotNull(roundingMode);
        double diffScale = (double)newScale - this.scale;
        if (diffScale == 0.0) {
            return this;
        }
        if (diffScale > 0.0) {
            if (diffScale < (double)DOUBLE_TEN_POW.length && this.bitLength + DOUBLE_TEN_POW_BIT_LENGTH[(int)diffScale] < 54) {
                return BigDecimal.valueOf(this.smallValue * DOUBLE_TEN_POW[(int)diffScale], (double)newScale);
            }
            return new BigDecimal(Multiplication.multiplyByTenPow(this.getUnscaledValue(), (int)diffScale), newScale);
        }
        if (this.bitLength < 54 && -diffScale < (double)DOUBLE_TEN_POW.length) {
            return BigDecimal.dividePrimitiveDoubles(this.smallValue, DOUBLE_TEN_POW[(int)(-diffScale)], newScale, roundingMode);
        }
        return BigDecimal.divideBigIntegers(this.getUnscaledValue(), Multiplication.powerOf10(-diffScale), newScale, roundingMode);
    }

    public short shortValueExact() {
        return (short)this.valueExact(16);
    }

    public int signum() {
        if (this.bitLength < 54) {
            return this.smallValue < 0.0 ? -1 : (this.smallValue > 0.0 ? 1 : 0);
        }
        return this.getUnscaledValue().signum();
    }

    public BigDecimal stripTrailingZeros() {
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        double newScale = this.scale;
        if (this.isZero()) {
            return new BigDecimal("0");
        }
        BigInteger strippedBI = this.getUnscaledValue();
        while (!strippedBI.testBit(0)) {
            BigInteger[] quotAndRem = strippedBI.divideAndRemainder(TEN_POW[i]);
            if (quotAndRem[1].signum() == 0) {
                newScale -= (double)i;
                if (i < lastPow) {
                    ++i;
                }
                strippedBI = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        return new BigDecimal(strippedBI, BigDecimal.toIntScale(newScale));
    }

    public BigDecimal subtract(BigDecimal subtrahend) {
        double diffScale = this.scale - subtrahend.scale;
        if (this.isZero()) {
            if (diffScale <= 0.0) {
                return subtrahend.negate();
            }
            if (subtrahend.isZero()) {
                return this;
            }
        } else if (subtrahend.isZero() && diffScale >= 0.0) {
            return this;
        }
        if (diffScale == 0.0) {
            if (Math.max(this.bitLength, subtrahend.bitLength) + 1 < 54) {
                return BigDecimal.valueOf(this.smallValue - subtrahend.smallValue, this.scale);
            }
            return new BigDecimal(this.getUnscaledValue().subtract(subtrahend.getUnscaledValue()), this.scale);
        }
        if (diffScale > 0.0) {
            if (diffScale < (double)DOUBLE_TEN_POW.length && Math.max(this.bitLength, subtrahend.bitLength + DOUBLE_TEN_POW_BIT_LENGTH[(int)diffScale]) + 1 < 54) {
                return BigDecimal.valueOf(this.smallValue - subtrahend.smallValue * DOUBLE_TEN_POW[(int)diffScale], this.scale);
            }
            return new BigDecimal(this.getUnscaledValue().subtract(Multiplication.multiplyByTenPow(subtrahend.getUnscaledValue(), (int)diffScale)), this.scale);
        }
        if ((diffScale = -diffScale) < (double)DOUBLE_TEN_POW.length && Math.max(this.bitLength + DOUBLE_TEN_POW_BIT_LENGTH[(int)diffScale], subtrahend.bitLength) + 1 < 54) {
            return BigDecimal.valueOf(this.smallValue * DOUBLE_TEN_POW[(int)diffScale] - subtrahend.smallValue, subtrahend.scale);
        }
        return new BigDecimal(Multiplication.multiplyByTenPow(this.getUnscaledValue(), (int)diffScale).subtract(subtrahend.getUnscaledValue()), subtrahend.scale);
    }

    public BigDecimal subtract(BigDecimal subtrahend, MathContext mc) {
        double diffScale = subtrahend.scale - this.scale;
        if (subtrahend.isZero() || this.isZero() || mc.getPrecision() == 0) {
            return this.subtract(subtrahend).round(mc);
        }
        if (subtrahend.approxPrecision() < diffScale - 1.0 && (double)mc.getPrecision() < this.approxPrecision()) {
            BigInteger tempBI;
            int thisSignum = this.signum();
            if (thisSignum != subtrahend.signum()) {
                tempBI = Multiplication.multiplyByPositiveInt(this.getUnscaledValue(), 10).add(BigInteger.valueOf(thisSignum));
            } else {
                tempBI = this.getUnscaledValue().subtract(BigInteger.valueOf(thisSignum));
                tempBI = Multiplication.multiplyByPositiveInt(tempBI, 10).add(BigInteger.valueOf(thisSignum * 9));
            }
            BigDecimal leftOperand = new BigDecimal(tempBI, this.scale + 1.0);
            return leftOperand.round(mc);
        }
        return this.subtract(subtrahend).round(mc);
    }

    public BigInteger toBigInteger() {
        if (this.scale == 0.0 || this.isZero()) {
            return this.getUnscaledValue();
        }
        if (this.scale < 0.0) {
            return this.getUnscaledValue().multiply(Multiplication.powerOf10(-this.scale));
        }
        return this.getUnscaledValue().divide(Multiplication.powerOf10(this.scale));
    }

    public BigInteger toBigIntegerExact() {
        if (this.scale == 0.0 || this.isZero()) {
            return this.getUnscaledValue();
        }
        if (this.scale < 0.0) {
            return this.getUnscaledValue().multiply(Multiplication.powerOf10(-this.scale));
        }
        if (this.scale > this.approxPrecision() || this.scale > (double)this.getUnscaledValue().getLowestSetBit()) {
            throw new ArithmeticException("Rounding necessary");
        }
        BigInteger[] integerAndFraction = this.getUnscaledValue().divideAndRemainder(Multiplication.powerOf10(this.scale));
        if (integerAndFraction[1].signum() != 0) {
            throw new ArithmeticException("Rounding necessary");
        }
        return integerAndFraction[0];
    }

    public String toEngineeringString() {
        String intString = this.getUnscaledValue().toString();
        if (this.scale == 0.0) {
            return intString;
        }
        int begin = this.getUnscaledValue().signum() < 0 ? 2 : 1;
        int end = intString.length();
        double exponent = -this.scale + (double)end - (double)begin;
        StringBuilder result = new StringBuilder(intString);
        if (this.scale > 0.0 && exponent >= -6.0) {
            if (exponent >= 0.0) {
                result.insert(end - (int)this.scale, '.');
            } else {
                result.insert(begin - 1, "0.");
                result.insert(begin + 1, CH_ZEROS, 0, -((int)exponent) - 1);
            }
        } else {
            int delta = end - begin;
            int rem = (int)(exponent % 3.0);
            if (rem != 0) {
                if (this.getUnscaledValue().signum() == 0) {
                    rem = rem < 0 ? -rem : 3 - rem;
                    exponent += (double)rem;
                } else {
                    rem = rem < 0 ? rem + 3 : rem;
                    exponent -= (double)rem;
                    begin += rem;
                }
                if (delta < 3) {
                    for (int i = rem - delta; i > 0; --i) {
                        result.insert(end++, '0');
                    }
                }
            }
            if (end - begin >= 1) {
                result.insert(begin, '.');
                ++end;
            }
            if (exponent != 0.0) {
                result.insert(end, 'E');
                if (exponent > 0.0) {
                    result.insert(++end, '+');
                }
                result.insert(++end, Long.toString((long)exponent));
            }
        }
        return result.toString();
    }

    public String toPlainString() {
        String intStr = this.getUnscaledValue().toString();
        if (this.scale == 0.0 || this.isZero() && this.scale < 0.0) {
            return intStr;
        }
        int begin = this.signum() < 0 ? 1 : 0;
        double delta = this.scale;
        StringBuilder result = new StringBuilder(intStr.length() + 1 + Math.abs((int)this.scale));
        if (begin == 1) {
            result.append('-');
        }
        if (this.scale > 0.0) {
            if ((delta -= (double)(intStr.length() - begin)) >= 0.0) {
                result.append("0.");
                while (delta > (double)CH_ZEROS.length) {
                    result.append(CH_ZEROS);
                    delta -= (double)CH_ZEROS.length;
                }
                result.append(CH_ZEROS, 0, (int)delta);
                result.append(intStr.substring(begin));
            } else {
                delta = (double)begin - delta;
                result.append(intStr.substring(begin, (int)delta));
                result.append('.');
                result.append(intStr.substring((int)delta));
            }
        } else {
            result.append(intStr.substring(begin));
            while (delta < (double)(-CH_ZEROS.length)) {
                result.append(CH_ZEROS);
                delta += (double)CH_ZEROS.length;
            }
            result.append(CH_ZEROS, 0, (int)(-delta));
        }
        return result.toString();
    }

    public String toString() {
        if (this.toStringImage != null) {
            return this.toStringImage;
        }
        if (this.bitLength < 32) {
            this.toStringImage = Conversion.toDecimalScaledString((long)this.smallValue, (int)this.scale);
            return this.toStringImage;
        }
        String intString = this.getUnscaledValue().toString();
        if (this.scale == 0.0) {
            return intString;
        }
        int begin = this.getUnscaledValue().signum() < 0 ? 2 : 1;
        int end = intString.length();
        double exponent = -this.scale + (double)end - (double)begin;
        StringBuilder result = new StringBuilder();
        result.append(intString);
        if (this.scale > 0.0 && exponent >= -6.0) {
            if (exponent >= 0.0) {
                result.insert(end - (int)this.scale, '.');
            } else {
                result.insert(begin - 1, "0.");
                result.insert(begin + 1, CH_ZEROS, 0, -((int)exponent) - 1);
            }
        } else {
            if (end - begin >= 1) {
                result.insert(begin, '.');
                ++end;
            }
            result.insert(end, 'E');
            if (exponent > 0.0) {
                result.insert(++end, '+');
            }
            result.insert(++end, Long.toString((long)exponent));
        }
        this.toStringImage = result.toString();
        return this.toStringImage;
    }

    public BigDecimal ulp() {
        return BigDecimal.valueOf(1.0, this.scale);
    }

    public BigInteger unscaledValue() {
        return this.getUnscaledValue();
    }

    private double approxPrecision() {
        return this.precision > 0 ? (double)this.precision : Math.floor((double)(this.bitLength - 1) * 0.3010299956639812) + 1.0;
    }

    private BigInteger getUnscaledValue() {
        if (this.intVal == null) {
            this.intVal = BigInteger.valueOf((long)this.smallValue);
        }
        return this.intVal;
    }

    private void initFrom(String val) {
        char ch;
        String unscaled;
        int begin = 0;
        int offset = 0;
        int last = val.length();
        String scaleString = null;
        StringBuilder unscaledBuffer = new StringBuilder(val.length());
        if (offset < last && val.charAt(offset) == '+') {
            ++begin;
            if (++offset < last && (val.charAt(offset) == '+' || val.charAt(offset) == '-')) {
                throw new NumberFormatException("For input string: \"" + val + "\"");
            }
        }
        while (offset < last && val.charAt(offset) != '.' && val.charAt(offset) != 'e' && val.charAt(offset) != 'E') {
            ++offset;
        }
        unscaledBuffer.append(val, begin, offset);
        if (offset < last && val.charAt(offset) == '.') {
            begin = ++offset;
            while (offset < last && val.charAt(offset) != 'e' && val.charAt(offset) != 'E') {
                ++offset;
            }
            this.scale = offset - begin;
            unscaledBuffer.append(val, begin, offset);
        } else {
            this.scale = 0.0;
        }
        if (offset < last && (val.charAt(offset) == 'e' || val.charAt(offset) == 'E')) {
            begin = ++offset;
            if (offset < last && val.charAt(offset) == '+' && ++offset < last && val.charAt(offset) != '-') {
                ++begin;
            }
            scaleString = val.substring(begin, last);
            this.scale -= (double)Integer.parseInt(scaleString);
            if (this.scale != (double)((int)this.scale)) {
                throw new NumberFormatException("Exponent overflow.");
            }
        }
        if ((unscaled = unscaledBuffer.toString()).length() < 16) {
            this.smallValue = BigDecimal.parseUnscaled(unscaled);
            if (Double.isNaN(this.smallValue)) {
                throw new NumberFormatException("For input string: \"" + val + "\"");
            }
            this.bitLength = BigDecimal.bitLength(this.smallValue);
        } else {
            this.setUnscaledValue(new BigInteger(unscaled));
        }
        this.precision = unscaledBuffer.length();
        for (int i = 0; i < unscaledBuffer.length() && ((ch = unscaledBuffer.charAt(i)) == '-' || ch == '0'); ++i) {
            --this.precision;
        }
        if (this.precision == 0) {
            this.precision = 1;
        }
    }

    private void inplaceRound(MathContext mc) {
        int mcPrecision = mc.getPrecision();
        if (this.approxPrecision() - (double)mcPrecision < 0.0 || mcPrecision == 0) {
            return;
        }
        int discardedPrecision = this.precision() - mcPrecision;
        if (discardedPrecision <= 0) {
            return;
        }
        if (this.bitLength < 54) {
            this.smallRound(mc, discardedPrecision);
            return;
        }
        BigInteger sizeOfFraction = Multiplication.powerOf10(discardedPrecision);
        BigInteger[] integerAndFraction = this.getUnscaledValue().divideAndRemainder(sizeOfFraction);
        double newScale = this.scale - (double)discardedPrecision;
        if (integerAndFraction[1].signum() != 0) {
            BigDecimal tempBD;
            int compRem = integerAndFraction[1].abs().shiftLeftOneBit().compareTo(sizeOfFraction);
            compRem = BigDecimal.roundingBehavior(integerAndFraction[0].testBit(0) ? 1 : 0, integerAndFraction[1].signum() * (5 + compRem), mc.getRoundingMode());
            if (compRem != 0) {
                integerAndFraction[0] = integerAndFraction[0].add(BigInteger.valueOf(compRem));
            }
            if ((tempBD = new BigDecimal(integerAndFraction[0])).precision() > mcPrecision) {
                integerAndFraction[0] = integerAndFraction[0].divide(BigInteger.TEN);
                newScale -= 1.0;
            }
        }
        this.scale = BigDecimal.toIntScale(newScale);
        this.precision = mcPrecision;
        this.setUnscaledValue(integerAndFraction[0]);
    }

    private boolean isZero() {
        return this.bitLength == 0 && this.smallValue != -1.0;
    }

    private BigDecimal movePoint(double newScale) {
        if (this.isZero()) {
            return BigDecimal.zeroScaledBy(Math.max(newScale, 0.0));
        }
        if (newScale >= 0.0) {
            if (this.bitLength < 54) {
                return BigDecimal.valueOf(this.smallValue, (double)BigDecimal.toIntScale(newScale));
            }
            return new BigDecimal(this.getUnscaledValue(), BigDecimal.toIntScale(newScale));
        }
        if (-newScale < (double)DOUBLE_TEN_POW.length && this.bitLength + DOUBLE_TEN_POW_BIT_LENGTH[(int)(-newScale)] < 54) {
            return BigDecimal.valueOf(this.smallValue * DOUBLE_TEN_POW[(int)(-newScale)], 0.0);
        }
        return new BigDecimal(Multiplication.multiplyByTenPow(this.getUnscaledValue(), (int)(-newScale)), 0);
    }

    private void setUnscaledValue(BigInteger unscaledValue) {
        this.intVal = unscaledValue;
        this.bitLength = unscaledValue.bitLength();
        if (this.bitLength < 54) {
            this.smallValue = unscaledValue.longValue();
        }
    }

    private void smallRound(MathContext mc, int discardedPrecision) {
        long sizeOfFraction = (long)DOUBLE_TEN_POW[discardedPrecision];
        long newScale = (long)this.scale - (long)discardedPrecision;
        long unscaledVal = (long)this.smallValue;
        long integer = unscaledVal / sizeOfFraction;
        long fraction = unscaledVal % sizeOfFraction;
        if (fraction != 0L) {
            int compRem = Long.compare(Math.abs(fraction) << 1, sizeOfFraction);
            if (Math.log10(Math.abs(integer += (long)BigDecimal.roundingBehavior((int)integer & 1, Long.signum(fraction) * (5 + compRem), mc.getRoundingMode()))) >= (double)mc.getPrecision()) {
                integer /= 10L;
                --newScale;
            }
        }
        this.scale = BigDecimal.toIntScale(newScale);
        this.precision = mc.getPrecision();
        this.smallValue = integer;
        this.bitLength = BigDecimal.bitLength(integer);
        this.intVal = null;
    }

    private long valueExact(int bitLengthOfType) {
        BigInteger bigInteger = this.toBigIntegerExact();
        if (bigInteger.bitLength() < bitLengthOfType) {
            return bigInteger.longValue();
        }
        throw new ArithmeticException("Rounding necessary");
    }

    static {
        int j;
        int i;
        ONE = new BigDecimal(1L, 0);
        TEN = new BigDecimal(10L, 0);
        ZERO = new BigDecimal(0L, 0);
        BI_SCALED_BY_ZERO = new BigDecimal[11];
        CH_ZEROS = new char[100];
        DOUBLE_FIVE_POW = new double[]{1.0, 5.0, 25.0, 125.0, 625.0, 3125.0, 15625.0, 78125.0, 390625.0, 1953125.0, 9765625.0, 4.8828125E7, 2.44140625E8, 1.220703125E9, 6.103515625E9, 3.0517578125E10, 1.52587890625E11, 7.62939453125E11, 3.814697265625E12, 1.9073486328125E13, 9.5367431640625E13, 4.76837158203125E14, 2.384185791015625E15};
        DOUBLE_FIVE_POW_BIT_LENGTH = new int[DOUBLE_FIVE_POW.length];
        DOUBLE_TEN_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16};
        DOUBLE_TEN_POW_BIT_LENGTH = new int[DOUBLE_TEN_POW.length];
        ZERO_SCALED_BY = new BigDecimal[11];
        for (i = 0; i < ZERO_SCALED_BY.length; ++i) {
            BigDecimal.BI_SCALED_BY_ZERO[i] = new BigDecimal((long)i, 0);
            BigDecimal.ZERO_SCALED_BY[i] = new BigDecimal(0L, i);
            BigDecimal.CH_ZEROS[i] = 48;
        }
        while (i < CH_ZEROS.length) {
            BigDecimal.CH_ZEROS[i] = 48;
            ++i;
        }
        for (j = 0; j < DOUBLE_FIVE_POW_BIT_LENGTH.length; ++j) {
            BigDecimal.DOUBLE_FIVE_POW_BIT_LENGTH[j] = BigDecimal.bitLength(DOUBLE_FIVE_POW[j]);
        }
        for (j = 0; j < DOUBLE_TEN_POW_BIT_LENGTH.length; ++j) {
            BigDecimal.DOUBLE_TEN_POW_BIT_LENGTH[j] = BigDecimal.bitLength(DOUBLE_TEN_POW[j]);
        }
        TEN_POW = Multiplication.bigTenPows;
        FIVE_POW = Multiplication.bigFivePows;
    }
}

