/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.Serializable;
import java.math.BitLevel;
import java.math.Conversion;
import java.math.Division;
import java.math.Elementary;
import java.math.Logical;
import java.math.Multiplication;
import java.math.Primality;
import java.util.Random;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.LongUtils;

public class BigInteger
extends Number
implements Comparable<BigInteger>,
Serializable {
    public static final BigInteger ONE = new BigInteger(1, 1);
    public static final BigInteger TEN = new BigInteger(1, 10);
    public static final BigInteger ZERO = new BigInteger(0, 0);
    static final int EQUALS = 0;
    static final int GREATER = 1;
    static final int LESS = -1;
    static final BigInteger MINUS_ONE = new BigInteger(-1, 1);
    static final BigInteger[] SMALL_VALUES = new BigInteger[]{ZERO, ONE, new BigInteger(1, 2), new BigInteger(1, 3), new BigInteger(1, 4), new BigInteger(1, 5), new BigInteger(1, 6), new BigInteger(1, 7), new BigInteger(1, 8), new BigInteger(1, 9), TEN};
    static final BigInteger[] TWO_POWS = new BigInteger[32];
    private static final long serialVersionUID = -8287574255936472291L;
    int[] digits;
    int numberLength;
    int sign;
    private int firstNonzeroDigit = -2;
    private int hashCode = 0;

    public static BigInteger probablePrime(int bitLength, Random rnd) {
        return new BigInteger(bitLength, 100, rnd);
    }

    public static BigInteger valueOf(long val) {
        return val >= 0L ? BigInteger.fromBits(val) : BigInteger.fromBits(-val).negate();
    }

    private static BigInteger fromBits(long bits) {
        int lowBits = (int)bits;
        int highBits = LongUtils.getHighBits(bits);
        if (highBits != 0) {
            return new BigInteger(1, lowBits, highBits);
        }
        if (lowBits > 10 || lowBits < 0) {
            return new BigInteger(1, lowBits);
        }
        return SMALL_VALUES[lowBits];
    }

    static BigInteger getPowerOfTwo(int exp) {
        if (exp < TWO_POWS.length) {
            return TWO_POWS[exp];
        }
        int intCount = exp >> 5;
        int bitN = exp & 0x1F;
        int[] resDigits = new int[intCount + 1];
        resDigits[intCount] = 1 << bitN;
        return new BigInteger(1, intCount + 1, resDigits);
    }

    private static void setFromString(BigInteger bi, String val, int radix) {
        int startChar;
        int sign;
        int stringLength = val.length();
        int endChar = stringLength--;
        if (val.charAt(0) == '-') {
            sign = -1;
            startChar = 1;
        } else {
            sign = 1;
            startChar = 0;
        }
        int charsPerInt = Conversion.digitFitInInt[radix];
        int bigRadixDigitsLength = stringLength / charsPerInt;
        int topChars = stringLength % charsPerInt;
        if (topChars != 0) {
            ++bigRadixDigitsLength;
        }
        int[] digits = new int[bigRadixDigitsLength];
        int bigRadix = Conversion.bigRadices[radix - 2];
        int digitIndex = 0;
        int substrEnd = startChar + (topChars == 0 ? charsPerInt : topChars);
        int substrStart = startChar;
        while (substrStart < endChar) {
            int bigRadixDigit = Integer.parseInt(val.substring(substrStart, substrEnd), radix);
            int newDigit = Multiplication.multiplyByInt(digits, digitIndex, bigRadix);
            digits[digitIndex++] = newDigit += Elementary.inplaceAdd(digits, digitIndex, bigRadixDigit);
            substrStart = substrEnd;
            substrEnd = substrStart + charsPerInt;
        }
        int numberLength = digitIndex;
        bi.sign = sign;
        bi.numberLength = numberLength;
        bi.digits = digits;
        bi.cutOffLeadingZeroes();
    }

    public BigInteger(byte[] val) {
        if (val.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (val[0] < 0) {
            this.sign = -1;
            this.putBytesNegativeToIntegers(val);
        } else {
            this.sign = 1;
            this.putBytesPositiveToIntegers(val);
        }
        this.cutOffLeadingZeroes();
    }

    public BigInteger(int signum, byte[] magnitude) {
        InternalPreconditions.checkNotNull(magnitude);
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (signum == 0) {
            for (byte element : magnitude) {
                if (element == 0) continue;
                throw new NumberFormatException("signum-magnitude mismatch");
            }
        }
        if (magnitude.length == 0) {
            this.sign = 0;
            this.numberLength = 1;
            this.digits = new int[]{0};
        } else {
            this.sign = signum;
            this.putBytesPositiveToIntegers(magnitude);
            this.cutOffLeadingZeroes();
        }
    }

    public BigInteger(int bitLength, int certainty, Random rnd) {
        if (bitLength < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        BigInteger me = Primality.consBigInteger(bitLength, certainty, rnd);
        this.sign = me.sign;
        this.numberLength = me.numberLength;
        this.digits = me.digits;
    }

    public BigInteger(int numBits, Random rnd) {
        InternalPreconditions.checkCriticalArgument(numBits >= 0, "numBits must be non-negative");
        if (numBits == 0) {
            this.sign = 0;
            this.numberLength = 1;
            this.digits = new int[]{0};
        } else {
            this.sign = 1;
            this.numberLength = numBits + 31 >> 5;
            this.digits = new int[this.numberLength];
            for (int i = 0; i < this.numberLength; ++i) {
                this.digits[i] = rnd.nextInt();
            }
            int n = this.numberLength - 1;
            this.digits[n] = this.digits[n] >>> (-numBits & 0x1F);
            this.cutOffLeadingZeroes();
        }
    }

    public BigInteger(String val) {
        this(val, 10);
    }

    public BigInteger(String val, int radix) {
        InternalPreconditions.checkNotNull(val);
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        if (val.isEmpty()) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        BigInteger.setFromString(this, val, radix);
    }

    BigInteger(int sign, int bits) {
        this(sign, 1, new int[]{bits});
    }

    BigInteger(int sign, int lowBits, int highBits) {
        this(sign, 2, new int[]{lowBits, highBits});
    }

    BigInteger(int signum, int[] digits) {
        if (digits.length == 0) {
            this.sign = 0;
            this.numberLength = 1;
            this.digits = new int[]{0};
        } else {
            this.sign = signum;
            this.numberLength = digits.length;
            this.digits = digits;
            this.cutOffLeadingZeroes();
        }
    }

    BigInteger(int sign, int numberLength, int[] digits) {
        this.sign = sign;
        this.numberLength = numberLength;
        this.digits = digits;
    }

    public BigInteger abs() {
        return this.sign < 0 ? this.negate() : this;
    }

    public BigInteger add(BigInteger val) {
        return Elementary.add(this, val);
    }

    public BigInteger and(BigInteger val) {
        return Logical.and(this, val);
    }

    public BigInteger andNot(BigInteger val) {
        return Logical.andNot(this, val);
    }

    public int bitCount() {
        return BitLevel.bitCount(this);
    }

    public int bitLength() {
        return BitLevel.bitLength(this);
    }

    public byte byteValueExact() {
        if (this.numberLength <= 1 && this.bitLength() < 8) {
            return this.byteValue();
        }
        throw new ArithmeticException("out of byte range");
    }

    public BigInteger clearBit(int n) {
        if (this.testBit(n)) {
            return BitLevel.flipBit(this, n);
        }
        return this;
    }

    @Override
    public int compareTo(BigInteger val) {
        if (this.sign > val.sign) {
            return 1;
        }
        if (this.sign < val.sign) {
            return -1;
        }
        if (this.numberLength > val.numberLength) {
            return this.sign;
        }
        if (this.numberLength < val.numberLength) {
            return -val.sign;
        }
        return this.sign * Elementary.compareArrays(this.digits, val.digits, this.numberLength);
    }

    public BigInteger divide(BigInteger divisor) {
        int resSign;
        int cmp;
        if (divisor.sign == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        int divisorSign = divisor.sign;
        if (divisor.isOne()) {
            return divisor.sign > 0 ? this : this.negate();
        }
        int thisSign = this.sign;
        int thisLen = this.numberLength;
        int divisorLen = divisor.numberLength;
        if (thisLen + divisorLen == 2) {
            long val = ((long)this.digits[0] & 0xFFFFFFFFL) / ((long)divisor.digits[0] & 0xFFFFFFFFL);
            if (thisSign != divisorSign) {
                val = -val;
            }
            return BigInteger.valueOf(val);
        }
        int n = thisLen != divisorLen ? (thisLen > divisorLen ? 1 : -1) : (cmp = Elementary.compareArrays(this.digits, divisor.digits, thisLen));
        if (cmp == 0) {
            return thisSign == divisorSign ? ONE : MINUS_ONE;
        }
        if (cmp == -1) {
            return ZERO;
        }
        int resLength = thisLen - divisorLen + 1;
        int[] resDigits = new int[resLength];
        int n2 = resSign = thisSign == divisorSign ? 1 : -1;
        if (divisorLen == 1) {
            Division.divideArrayByInt(resDigits, this.digits, thisLen, divisor.digits[0]);
        } else {
            Division.divide(resDigits, resLength, this.digits, thisLen, divisor.digits, divisorLen);
        }
        BigInteger result = new BigInteger(resSign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    public BigInteger[] divideAndRemainder(BigInteger divisor) {
        int cmp;
        int divisorSign = divisor.sign;
        if (divisorSign == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        int divisorLen = divisor.numberLength;
        int[] divisorDigits = divisor.digits;
        if (divisorLen == 1) {
            return Division.divideAndRemainderByInteger(this, divisorDigits[0], divisorSign);
        }
        int[] thisDigits = this.digits;
        int thisLen = this.numberLength;
        int n = thisLen != divisorLen ? (thisLen > divisorLen ? 1 : -1) : (cmp = Elementary.compareArrays(thisDigits, divisorDigits, thisLen));
        if (cmp < 0) {
            return new BigInteger[]{ZERO, this};
        }
        int thisSign = this.sign;
        int quotientLength = thisLen - divisorLen + 1;
        int remainderLength = divisorLen;
        int quotientSign = thisSign == divisorSign ? 1 : -1;
        int[] quotientDigits = new int[quotientLength];
        int[] remainderDigits = Division.divide(quotientDigits, quotientLength, thisDigits, thisLen, divisorDigits, divisorLen);
        BigInteger result0 = new BigInteger(quotientSign, quotientLength, quotientDigits);
        BigInteger result1 = new BigInteger(thisSign, remainderLength, remainderDigits);
        result0.cutOffLeadingZeroes();
        result1.cutOffLeadingZeroes();
        return new BigInteger[]{result0, result1};
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (x instanceof BigInteger) {
            BigInteger x1 = (BigInteger)x;
            return this.sign == x1.sign && this.numberLength == x1.numberLength && this.equalsArrays(x1.digits);
        }
        return false;
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return BitLevel.flipBit(this, n);
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.toString());
    }

    public BigInteger gcd(BigInteger val) {
        BigInteger val1 = this.abs();
        BigInteger val2 = val.abs();
        if (val1.signum() == 0) {
            return val2;
        }
        if (val2.signum() == 0) {
            return val1;
        }
        if ((val1.numberLength == 1 || val1.numberLength == 2 && val1.digits[1] > 0) && (val2.numberLength == 1 || val2.numberLength == 2 && val2.digits[1] > 0)) {
            return BigInteger.valueOf(Division.gcdBinary(val1.longValue(), val2.longValue()));
        }
        return Division.gcdBinary(val1.copy(), val2.copy());
    }

    public int getLowestSetBit() {
        if (this.sign == 0) {
            return -1;
        }
        int i = this.getFirstNonzeroDigit();
        return (i << 5) + Integer.numberOfTrailingZeros(this.digits[i]);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        for (int i = 0; i < this.digits.length; ++i) {
            this.hashCode = this.hashCode * 33 + (this.digits[i] & 0xFFFFFFFF);
        }
        this.hashCode *= this.sign;
        return this.hashCode;
    }

    @Override
    public int intValue() {
        int i = this.digits[0];
        return this.sign > 0 ? i : -i;
    }

    public int intValueExact() {
        if (this.numberLength <= 1 && this.bitLength() < 32) {
            return this.intValue();
        }
        throw new ArithmeticException("out of int range");
    }

    public boolean isProbablePrime(int certainty) {
        return Primality.isProbablePrime(this.abs(), certainty);
    }

    @Override
    public long longValue() {
        long value = this.numberLength > 1 ? LongUtils.fromBits(this.digits[0], this.digits[1]) : LongUtils.fromBits(this.digits[0], 0);
        return this.sign > 0 ? value : -value;
    }

    public long longValueExact() {
        if (this.numberLength <= 2 && this.bitLength() < 64) {
            return this.longValue();
        }
        throw new ArithmeticException("out of long range");
    }

    public BigInteger max(BigInteger val) {
        return this.compareTo(val) == 1 ? this : val;
    }

    public BigInteger min(BigInteger val) {
        return this.compareTo(val) == -1 ? this : val;
    }

    public BigInteger mod(BigInteger m) {
        if (m.sign <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        BigInteger rem = this.remainder(m);
        return rem.sign < 0 ? rem.add(m) : rem;
    }

    public BigInteger modInverse(BigInteger m) {
        if (m.sign <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (!this.testBit(0) && !m.testBit(0)) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        if (m.isOne()) {
            return ZERO;
        }
        BigInteger res = Division.modInverseMontgomery(this.abs().mod(m), m);
        if (res.sign == 0) {
            throw new ArithmeticException("BigInteger not invertible.");
        }
        res = this.sign < 0 ? m.subtract(res) : res;
        return res;
    }

    public BigInteger modPow(BigInteger exponent, BigInteger m) {
        BigInteger res;
        if (m.sign <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        BigInteger base = this;
        if (m.isOne() | exponent.sign > 0 & base.sign == 0) {
            return ZERO;
        }
        if (base.sign == 0 && exponent.sign == 0) {
            return ONE;
        }
        if (exponent.sign < 0) {
            base = this.modInverse(m);
            exponent = exponent.negate();
        }
        BigInteger bigInteger = res = m.testBit(0) ? Division.oddModPow(base.abs(), exponent, m) : Division.evenModPow(base.abs(), exponent, m);
        if (base.sign < 0 && exponent.testBit(0)) {
            res = m.subtract(ONE).multiply(res).mod(m);
        }
        return res;
    }

    public BigInteger multiply(BigInteger val) {
        if (val.sign == 0 || this.sign == 0) {
            return ZERO;
        }
        return Multiplication.multiply(this, val);
    }

    public BigInteger negate() {
        return this.sign == 0 ? this : new BigInteger(-this.sign, this.numberLength, this.digits);
    }

    public BigInteger nextProbablePrime() {
        if (this.sign < 0) {
            throw new ArithmeticException("start < 0: " + this);
        }
        return Primality.nextProbablePrime(this);
    }

    public BigInteger not() {
        return Logical.not(this);
    }

    public BigInteger or(BigInteger val) {
        return Logical.or(this, val);
    }

    public BigInteger pow(int exp) {
        if (exp < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (exp == 0) {
            return ONE;
        }
        if (exp == 1 || this.equals(ONE) || this.equals(ZERO)) {
            return this;
        }
        if (!this.testBit(0)) {
            int x = 1;
            while (!this.testBit(x)) {
                ++x;
            }
            return BigInteger.getPowerOfTwo(x * exp).multiply(this.shiftRight(x).pow(exp));
        }
        return Multiplication.pow(this, exp);
    }

    public BigInteger remainder(BigInteger divisor) {
        if (divisor.sign == 0) {
            throw new ArithmeticException("BigInteger divide by zero");
        }
        int thisLen = this.numberLength;
        int divisorLen = divisor.numberLength;
        if ((thisLen != divisorLen ? (thisLen > divisorLen ? 1 : -1) : Elementary.compareArrays(this.digits, divisor.digits, thisLen)) == -1) {
            return this;
        }
        int resLength = divisorLen;
        int[] resDigits = new int[resLength];
        if (resLength == 1) {
            resDigits[0] = Division.remainderArrayByInt(this.digits, thisLen, divisor.digits[0]);
        } else {
            int qLen = thisLen - divisorLen + 1;
            resDigits = Division.divide(null, qLen, this.digits, thisLen, divisor.digits, divisorLen);
        }
        BigInteger result = new BigInteger(this.sign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    public BigInteger setBit(int n) {
        if (!this.testBit(n)) {
            return BitLevel.flipBit(this, n);
        }
        return this;
    }

    public BigInteger shiftLeft(int n) {
        if (n == 0 || this.sign == 0) {
            return this;
        }
        return n > 0 ? BitLevel.shiftLeft(this, n) : BitLevel.shiftRight(this, -n);
    }

    public BigInteger shiftRight(int n) {
        if (n == 0 || this.sign == 0) {
            return this;
        }
        return n > 0 ? BitLevel.shiftRight(this, n) : BitLevel.shiftLeft(this, -n);
    }

    public short shortValueExact() {
        if (this.numberLength <= 1 && this.bitLength() < 16) {
            return this.shortValue();
        }
        throw new ArithmeticException("out of short range");
    }

    public int signum() {
        return this.sign;
    }

    public BigInteger subtract(BigInteger val) {
        return Elementary.subtract(this, val);
    }

    public boolean testBit(int n) {
        if (n == 0) {
            return (this.digits[0] & 1) != 0;
        }
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intCount = n >> 5;
        if (intCount >= this.numberLength) {
            return this.sign < 0;
        }
        int digit = this.digits[intCount];
        n = 1 << (n & 0x1F);
        if (this.sign < 0) {
            int firstNonZeroDigit = this.getFirstNonzeroDigit();
            if (intCount < firstNonZeroDigit) {
                return false;
            }
            digit = firstNonZeroDigit == intCount ? -digit : (digit ^= 0xFFFFFFFF);
        }
        return (digit & n) != 0;
    }

    public byte[] toByteArray() {
        int highBytes;
        if (this.sign == 0) {
            return new byte[]{0};
        }
        BigInteger temp = this;
        int bitLen = this.bitLength();
        int iThis = this.getFirstNonzeroDigit();
        int bytesLen = (bitLen >> 3) + 1;
        byte[] bytes = new byte[bytesLen];
        int firstByteNumber = 0;
        int digitIndex = 0;
        int bytesInInteger = 4;
        if (bytesLen - (this.numberLength << 2) == 1) {
            bytes[0] = (byte)(this.sign < 0 ? -1 : 0);
            highBytes = 4;
            ++firstByteNumber;
        } else {
            int hB = bytesLen & 3;
            highBytes = hB == 0 ? 4 : hB;
        }
        digitIndex = iThis;
        bytesLen -= iThis << 2;
        if (this.sign < 0) {
            int digit = -temp.digits[digitIndex];
            if (++digitIndex == this.numberLength) {
                bytesInInteger = highBytes;
            }
            int i = 0;
            while (i < bytesInInteger) {
                bytes[--bytesLen] = (byte)digit;
                ++i;
                digit >>= 8;
            }
            while (bytesLen > firstByteNumber) {
                digit = ~temp.digits[digitIndex];
                if (++digitIndex == this.numberLength) {
                    bytesInInteger = highBytes;
                }
                i = 0;
                while (i < bytesInInteger) {
                    bytes[--bytesLen] = (byte)digit;
                    ++i;
                    digit >>= 8;
                }
            }
        } else {
            while (bytesLen > firstByteNumber) {
                int digit = temp.digits[digitIndex];
                if (++digitIndex == this.numberLength) {
                    bytesInInteger = highBytes;
                }
                int i = 0;
                while (i < bytesInInteger) {
                    bytes[--bytesLen] = (byte)digit;
                    ++i;
                    digit >>= 8;
                }
            }
        }
        return bytes;
    }

    public String toString() {
        return Conversion.toDecimalScaledString(this, 0);
    }

    public String toString(int radix) {
        return Conversion.bigInteger2String(this, radix);
    }

    public BigInteger xor(BigInteger val) {
        return Logical.xor(this, val);
    }

    BigInteger copy() {
        int[] copyDigits = new int[this.numberLength];
        System.arraycopy(this.digits, 0, copyDigits, 0, this.numberLength);
        return new BigInteger(this.sign, this.numberLength, copyDigits);
    }

    final void cutOffLeadingZeroes() {
        while (this.numberLength > 0 && this.digits[--this.numberLength] == 0) {
        }
        if (this.digits[this.numberLength++] == 0) {
            this.sign = 0;
        }
    }

    boolean equalsArrays(int[] b) {
        int i;
        for (i = this.numberLength - 1; i >= 0 && this.digits[i] == b[i]; --i) {
        }
        return i < 0;
    }

    int getFirstNonzeroDigit() {
        if (this.firstNonzeroDigit == -2) {
            int i;
            if (this.sign == 0) {
                i = -1;
            } else {
                i = 0;
                while (this.digits[i] == 0) {
                    ++i;
                }
            }
            this.firstNonzeroDigit = i;
        }
        return this.firstNonzeroDigit;
    }

    boolean isOne() {
        return this.numberLength == 1 && this.digits[0] == 1;
    }

    BigInteger shiftLeftOneBit() {
        return this.sign == 0 ? this : BitLevel.shiftLeftOneBit(this);
    }

    void unCache() {
        this.firstNonzeroDigit = -2;
    }

    private void putBytesNegativeToIntegers(byte[] byteValues) {
        int bytesLen;
        int highBytes = (bytesLen = byteValues.length) & 3;
        this.numberLength = (bytesLen >> 2) + (highBytes == 0 ? 0 : 1);
        this.digits = new int[this.numberLength];
        int i = 0;
        this.digits[this.numberLength - 1] = -1;
        while (bytesLen > highBytes) {
            this.digits[i] = byteValues[--bytesLen] & 0xFF | (byteValues[--bytesLen] & 0xFF) << 8 | (byteValues[--bytesLen] & 0xFF) << 16 | (byteValues[--bytesLen] & 0xFF) << 24;
            if (this.digits[i] != 0) {
                this.digits[i] = -this.digits[i];
                this.firstNonzeroDigit = i++;
                while (bytesLen > highBytes) {
                    this.digits[i] = byteValues[--bytesLen] & 0xFF | (byteValues[--bytesLen] & 0xFF) << 8 | (byteValues[--bytesLen] & 0xFF) << 16 | (byteValues[--bytesLen] & 0xFF) << 24;
                    this.digits[i] = ~this.digits[i];
                    ++i;
                }
                break;
            }
            ++i;
        }
        if (highBytes != 0) {
            if (this.firstNonzeroDigit != -2) {
                for (int j = 0; j < bytesLen; ++j) {
                    this.digits[i] = this.digits[i] << 8 | byteValues[j] & 0xFF;
                }
                this.digits[i] = ~this.digits[i];
            } else {
                for (int j = 0; j < bytesLen; ++j) {
                    this.digits[i] = this.digits[i] << 8 | byteValues[j] & 0xFF;
                }
                this.digits[i] = -this.digits[i];
            }
        }
    }

    private void putBytesPositiveToIntegers(byte[] byteValues) {
        int bytesLen;
        int highBytes = (bytesLen = byteValues.length) & 3;
        this.numberLength = (bytesLen >> 2) + (highBytes == 0 ? 0 : 1);
        this.digits = new int[this.numberLength];
        int i = 0;
        while (bytesLen > highBytes) {
            this.digits[i++] = byteValues[--bytesLen] & 0xFF | (byteValues[--bytesLen] & 0xFF) << 8 | (byteValues[--bytesLen] & 0xFF) << 16 | (byteValues[--bytesLen] & 0xFF) << 24;
        }
        for (int j = 0; j < bytesLen; ++j) {
            this.digits[i] = this.digits[i] << 8 | byteValues[j] & 0xFF;
        }
    }

    static {
        for (int i = 0; i < TWO_POWS.length; ++i) {
            BigInteger.TWO_POWS[i] = BigInteger.valueOf(1L << i);
        }
    }
}

