/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javaemul.internal.InternalPreconditions;

public abstract class AbstractSequentialList<E>
extends AbstractList<E> {
    protected AbstractSequentialList() {
    }

    @Override
    public void add(int index, E element) {
        ListIterator<E> iter = this.listIterator(index);
        iter.add(element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        InternalPreconditions.checkNotNull(c);
        boolean modified = false;
        ListIterator<E> iter = this.listIterator(index);
        for (E e : c) {
            iter.add(e);
            modified = true;
        }
        return modified;
    }

    @Override
    public E get(int index) {
        ListIterator iter = this.listIterator(index);
        try {
            return iter.next();
        }
        catch (NoSuchElementException e) {
            throw new IndexOutOfBoundsException("Can't get element " + index);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public E remove(int index) {
        ListIterator iter = this.listIterator(index);
        try {
            Object old = iter.next();
            iter.remove();
            return old;
        }
        catch (NoSuchElementException e) {
            throw new IndexOutOfBoundsException("Can't remove element " + index);
        }
    }

    @Override
    public E set(int index, E element) {
        ListIterator<E> iter = this.listIterator(index);
        try {
            Object old = iter.next();
            iter.set(element);
            return old;
        }
        catch (NoSuchElementException e) {
            throw new IndexOutOfBoundsException("Can't set element " + index);
        }
    }
}

