/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.Comparators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.StringJoiner;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javaemul.internal.ArrayHelper;
import javaemul.internal.ArrayIterator;
import javaemul.internal.InternalPreconditions;

public class Arrays {
    public static <T> List<T> asList(T ... array) {
        return new ArrayList<T>(array);
    }

    public static int binarySearch(byte[] sortedArray, int fromIndex, int toIndex, byte key) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, sortedArray.length);
        return Arrays.binarySearch0(sortedArray, fromIndex, toIndex, key);
    }

    public static int binarySearch(byte[] sortedArray, byte key) {
        return Arrays.binarySearch0(sortedArray, 0, sortedArray.length, key);
    }

    private static int binarySearch0(byte[] sortedArray, int fromIndex, int toIndex, byte key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            byte midVal = sortedArray[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    public static int binarySearch(char[] sortedArray, int fromIndex, int toIndex, char key) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, sortedArray.length);
        return Arrays.binarySearch0(sortedArray, fromIndex, toIndex, key);
    }

    public static int binarySearch(char[] sortedArray, char key) {
        return Arrays.binarySearch0(sortedArray, 0, sortedArray.length, key);
    }

    private static int binarySearch0(char[] sortedArray, int fromIndex, int toIndex, char key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            char midVal = sortedArray[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    public static int binarySearch(double[] sortedArray, int fromIndex, int toIndex, double key) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, sortedArray.length);
        return ArrayHelper.binarySearch(sortedArray, fromIndex, toIndex, key);
    }

    public static int binarySearch(double[] sortedArray, double key) {
        return ArrayHelper.binarySearch(sortedArray, 0, sortedArray.length, key);
    }

    public static int binarySearch(float[] sortedArray, int fromIndex, int toIndex, float key) {
        return ArrayHelper.binarySearch(sortedArray, fromIndex, toIndex, key);
    }

    public static int binarySearch(float[] sortedArray, float key) {
        return ArrayHelper.binarySearch(sortedArray, 0, sortedArray.length, key);
    }

    public static int binarySearch(int[] sortedArray, int fromIndex, int toIndex, int key) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, sortedArray.length);
        return Arrays.binarySearch0(sortedArray, fromIndex, toIndex, key);
    }

    public static int binarySearch(int[] sortedArray, int key) {
        return Arrays.binarySearch0(sortedArray, 0, sortedArray.length, key);
    }

    private static int binarySearch0(int[] sortedArray, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            int midVal = sortedArray[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    public static int binarySearch(long[] sortedArray, int fromIndex, int toIndex, long key) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, sortedArray.length);
        return Arrays.binarySearch0(sortedArray, fromIndex, toIndex, key);
    }

    public static int binarySearch(long[] sortedArray, long key) {
        return Arrays.binarySearch0(sortedArray, 0, sortedArray.length, key);
    }

    private static int binarySearch0(long[] sortedArray, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            long midVal = sortedArray[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    public static int binarySearch(Object[] sortedArray, int fromIndex, int toIndex, Object key) {
        return Arrays.binarySearch(sortedArray, fromIndex, toIndex, key, null);
    }

    public static int binarySearch(Object[] sortedArray, Object key) {
        return Arrays.binarySearch(sortedArray, key, null);
    }

    public static int binarySearch(short[] sortedArray, int fromIndex, int toIndex, short key) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, sortedArray.length);
        return Arrays.binarySearch0(sortedArray, fromIndex, toIndex, key);
    }

    public static int binarySearch(short[] sortedArray, short key) {
        return Arrays.binarySearch0(sortedArray, 0, sortedArray.length, key);
    }

    private static int binarySearch0(short[] sortedArray, int fromIndex, int toIndex, short key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            short midVal = sortedArray[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    public static <T> int binarySearch(T[] sortedArray, int fromIndex, int toIndex, T key, Comparator<? super T> comparator) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, sortedArray.length);
        return Arrays.binarySearch0(sortedArray, fromIndex, toIndex, key, comparator);
    }

    public static <T> int binarySearch(T[] sortedArray, T key, Comparator<? super T> c) {
        return Arrays.binarySearch0(sortedArray, 0, sortedArray.length, key, c);
    }

    private static <T> int binarySearch0(T[] sortedArray, int fromIndex, int toIndex, T key, Comparator<? super T> comparator) {
        comparator = Comparators.nullToNaturalOrder(comparator);
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            T midVal = sortedArray[mid];
            int compareResult = comparator.compare(midVal, key);
            if (compareResult < 0) {
                low = mid + 1;
                continue;
            }
            if (compareResult > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    public static boolean[] copyOf(boolean[] original, int newLength) {
        return Arrays.copyOfImpl(original, newLength);
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        return Arrays.copyOfImpl(original, newLength);
    }

    public static char[] copyOf(char[] original, int newLength) {
        return Arrays.copyOfImpl(original, newLength);
    }

    public static double[] copyOf(double[] original, int newLength) {
        return Arrays.copyOfImpl(original, newLength);
    }

    public static float[] copyOf(float[] original, int newLength) {
        return Arrays.copyOfImpl(original, newLength);
    }

    public static int[] copyOf(int[] original, int newLength) {
        return Arrays.copyOfImpl(original, newLength);
    }

    public static long[] copyOf(long[] original, int newLength) {
        return Arrays.copyOfImpl(original, newLength);
    }

    public static short[] copyOf(short[] original, int newLength) {
        return Arrays.copyOfImpl(original, newLength);
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Arrays.copyOfImpl(original, newLength);
    }

    public static boolean[] copyOfRange(boolean[] original, int from, int to) {
        return Arrays.copyOfRangeImpl(original, from, to);
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        return Arrays.copyOfRangeImpl(original, from, to);
    }

    public static char[] copyOfRange(char[] original, int from, int to) {
        return Arrays.copyOfRangeImpl(original, from, to);
    }

    public static double[] copyOfRange(double[] original, int from, int to) {
        return Arrays.copyOfRangeImpl(original, from, to);
    }

    public static float[] copyOfRange(float[] original, int from, int to) {
        return Arrays.copyOfRangeImpl(original, from, to);
    }

    public static int[] copyOfRange(int[] original, int from, int to) {
        return Arrays.copyOfRangeImpl(original, from, to);
    }

    public static long[] copyOfRange(long[] original, int from, int to) {
        return Arrays.copyOfRangeImpl(original, from, to);
    }

    public static short[] copyOfRange(short[] original, int from, int to) {
        return Arrays.copyOfRangeImpl(original, from, to);
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return Arrays.copyOfRangeImpl(original, from, to);
    }

    private static <T> T copyOfImpl(T original, int newLength) {
        InternalPreconditions.checkArraySize(newLength);
        return ArrayHelper.clone(original, 0, newLength);
    }

    private static <T> T copyOfRangeImpl(T original, int from, int to) {
        Arrays.checkCopyOfRange(original, from, to);
        return ArrayHelper.clone(original, from, to);
    }

    private static void checkCopyOfRange(Object original, int from, int to) {
        if (InternalPreconditions.isApiChecked()) {
            InternalPreconditions.checkArgument(from <= to, from + " > " + to);
        }
        int len = ArrayHelper.getLength(original);
        InternalPreconditions.checkCriticalArrayBounds(from, from, len);
    }

    public static boolean deepEquals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int n = a1.length;
        for (int i = 0; i < n; ++i) {
            if (Objects.deepEquals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static int deepHashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object obj : a) {
            int hash = obj instanceof Object[] ? Arrays.deepHashCode((Object[])obj) : (obj instanceof boolean[] ? Arrays.hashCode((boolean[])obj) : (obj instanceof byte[] ? Arrays.hashCode((byte[])obj) : (obj instanceof char[] ? Arrays.hashCode((char[])obj) : (obj instanceof short[] ? Arrays.hashCode((short[])obj) : (obj instanceof int[] ? Arrays.hashCode((int[])obj) : (obj instanceof long[] ? Arrays.hashCode((long[])obj) : (obj instanceof float[] ? Arrays.hashCode((float[])obj) : (obj instanceof double[] ? Arrays.hashCode((double[])obj) : Objects.hashCode(obj)))))))));
            hashCode = 31 * hashCode + hash;
        }
        return hashCode;
    }

    public static String deepToString(Object[] a) {
        return Arrays.deepToString(a, new HashSet<Object[]>());
    }

    public static boolean equals(boolean[] array1, boolean[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] array1, byte[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] array1, char[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] array1, double[] array2) {
        return ArrayHelper.equals(array1, array2);
    }

    public static boolean equals(float[] array1, float[] array2) {
        return ArrayHelper.equals(array1, array2);
    }

    public static boolean equals(int[] array1, int[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] array1, long[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            Object val1 = array1[i];
            Object val2 = array2[i];
            if (Objects.equals(val1, val2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] array1, short[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static void fill(boolean[] a, boolean val) {
        ArrayHelper.fill(a, val);
    }

    public static void fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        ArrayHelper.fill(a, val, fromIndex, toIndex);
    }

    public static void fill(byte[] a, byte val) {
        ArrayHelper.fill(a, val);
    }

    public static void fill(byte[] a, int fromIndex, int toIndex, byte val) {
        ArrayHelper.fill(a, val, fromIndex, toIndex);
    }

    public static void fill(char[] a, char val) {
        ArrayHelper.fill(a, Character.valueOf(val));
    }

    public static void fill(char[] a, int fromIndex, int toIndex, char val) {
        ArrayHelper.fill(a, Character.valueOf(val), fromIndex, toIndex);
    }

    public static void fill(double[] a, double val) {
        ArrayHelper.fill(a, val);
    }

    public static void fill(double[] a, int fromIndex, int toIndex, double val) {
        ArrayHelper.fill(a, val, fromIndex, toIndex);
    }

    public static void fill(float[] a, float val) {
        ArrayHelper.fill(a, Float.valueOf(val));
    }

    public static void fill(float[] a, int fromIndex, int toIndex, float val) {
        ArrayHelper.fill(a, Float.valueOf(val), fromIndex, toIndex);
    }

    public static void fill(int[] a, int val) {
        ArrayHelper.fill(a, val);
    }

    public static void fill(int[] a, int fromIndex, int toIndex, int val) {
        ArrayHelper.fill(a, val, fromIndex, toIndex);
    }

    public static void fill(long[] a, int fromIndex, int toIndex, long val) {
        ArrayHelper.fill(a, val, fromIndex, toIndex);
    }

    public static void fill(long[] a, long val) {
        ArrayHelper.fill(a, val);
    }

    public static void fill(Object[] a, int fromIndex, int toIndex, Object val) {
        ArrayHelper.fill(a, val, fromIndex, toIndex);
    }

    public static void fill(Object[] a, Object val) {
        ArrayHelper.fill(a, val);
    }

    public static void fill(short[] a, int fromIndex, int toIndex, short val) {
        ArrayHelper.fill(a, val, fromIndex, toIndex);
    }

    public static void fill(short[] a, short val) {
        ArrayHelper.fill(a, val);
    }

    public static int hashCode(boolean[] a) {
        if (a == null) {
            return 0;
        }
        int hashCode = 1;
        for (boolean e : a) {
            hashCode = 31 * hashCode + Boolean.hashCode(e);
        }
        return hashCode;
    }

    public static int hashCode(byte[] a) {
        if (a == null) {
            return 0;
        }
        int hashCode = 1;
        for (byte e : a) {
            hashCode = 31 * hashCode + Byte.hashCode(e);
        }
        return hashCode;
    }

    public static int hashCode(char[] a) {
        if (a == null) {
            return 0;
        }
        int hashCode = 1;
        for (char e : a) {
            hashCode = 31 * hashCode + Character.hashCode(e);
        }
        return hashCode;
    }

    public static int hashCode(double[] a) {
        if (a == null) {
            return 0;
        }
        int hashCode = 1;
        for (double e : a) {
            hashCode = 31 * hashCode + Double.hashCode(e);
        }
        return hashCode;
    }

    public static int hashCode(float[] a) {
        if (a == null) {
            return 0;
        }
        int hashCode = 1;
        for (float e : a) {
            hashCode = 31 * hashCode + Float.hashCode(e);
        }
        return hashCode;
    }

    public static int hashCode(int[] a) {
        if (a == null) {
            return 0;
        }
        int hashCode = 1;
        for (int e : a) {
            hashCode = 31 * hashCode + Integer.hashCode(e);
        }
        return hashCode;
    }

    public static int hashCode(long[] a) {
        if (a == null) {
            return 0;
        }
        int hashCode = 1;
        for (long e : a) {
            hashCode = 31 * hashCode + Long.hashCode(e);
        }
        return hashCode;
    }

    public static int hashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object e : a) {
            hashCode = 31 * hashCode + Objects.hashCode(e);
        }
        return hashCode;
    }

    public static int hashCode(short[] a) {
        if (a == null) {
            return 0;
        }
        int hashCode = 1;
        for (short e : a) {
            hashCode = 31 * hashCode + Short.hashCode(e);
        }
        return hashCode;
    }

    public static void parallelPrefix(double[] array, DoubleBinaryOperator op) {
        Arrays.parallelPrefix0(array, 0, array.length, op);
    }

    public static void parallelPrefix(double[] array, int fromIndex, int toIndex, DoubleBinaryOperator op) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, array.length);
        Arrays.parallelPrefix0(array, fromIndex, toIndex, op);
    }

    private static void parallelPrefix0(double[] array, int fromIndex, int toIndex, DoubleBinaryOperator op) {
        InternalPreconditions.checkNotNull(op);
        double acc = array[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            array[i] = acc = op.applyAsDouble(acc, array[i]);
        }
    }

    public static void parallelPrefix(int[] array, IntBinaryOperator op) {
        Arrays.parallelPrefix0(array, 0, array.length, op);
    }

    public static void parallelPrefix(int[] array, int fromIndex, int toIndex, IntBinaryOperator op) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, array.length);
        Arrays.parallelPrefix0(array, fromIndex, toIndex, op);
    }

    private static void parallelPrefix0(int[] array, int fromIndex, int toIndex, IntBinaryOperator op) {
        InternalPreconditions.checkNotNull(op);
        int acc = array[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            array[i] = acc = op.applyAsInt(acc, array[i]);
        }
    }

    public static void parallelPrefix(long[] array, LongBinaryOperator op) {
        Arrays.parallelPrefix0(array, 0, array.length, op);
    }

    public static void parallelPrefix(long[] array, int fromIndex, int toIndex, LongBinaryOperator op) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, array.length);
        Arrays.parallelPrefix0(array, fromIndex, toIndex, op);
    }

    private static void parallelPrefix0(long[] array, int fromIndex, int toIndex, LongBinaryOperator op) {
        InternalPreconditions.checkNotNull(op);
        long acc = array[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            array[i] = acc = op.applyAsLong(acc, array[i]);
        }
    }

    public static <T> void parallelPrefix(T[] array, BinaryOperator<T> op) {
        Arrays.parallelPrefix0(array, 0, array.length, op);
    }

    public static <T> void parallelPrefix(T[] array, int fromIndex, int toIndex, BinaryOperator<T> op) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, array.length);
        Arrays.parallelPrefix0(array, fromIndex, toIndex, op);
    }

    private static <T> void parallelPrefix0(T[] array, int fromIndex, int toIndex, BinaryOperator<T> op) {
        InternalPreconditions.checkNotNull(op);
        Object acc = array[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            array[i] = acc = op.apply(acc, array[i]);
        }
    }

    public static <T> void setAll(T[] array, IntFunction<? extends T> generator) {
        InternalPreconditions.checkNotNull(generator);
        for (int i = 0; i < array.length; ++i) {
            array[i] = generator.apply(i);
        }
    }

    public static void setAll(double[] array, IntToDoubleFunction generator) {
        InternalPreconditions.checkNotNull(generator);
        for (int i = 0; i < array.length; ++i) {
            array[i] = generator.applyAsDouble(i);
        }
    }

    public static void setAll(int[] array, IntUnaryOperator generator) {
        InternalPreconditions.checkNotNull(generator);
        for (int i = 0; i < array.length; ++i) {
            array[i] = generator.applyAsInt(i);
        }
    }

    public static void setAll(long[] array, IntToLongFunction generator) {
        InternalPreconditions.checkNotNull(generator);
        for (int i = 0; i < array.length; ++i) {
            array[i] = generator.applyAsLong(i);
        }
    }

    public static <T> void parallelSetAll(T[] array, IntFunction<? extends T> generator) {
        Arrays.setAll(array, generator);
    }

    public static void parallelSetAll(double[] array, IntToDoubleFunction generator) {
        Arrays.setAll(array, generator);
    }

    public static void parallelSetAll(int[] array, IntUnaryOperator generator) {
        Arrays.setAll(array, generator);
    }

    public static void parallelSetAll(long[] array, IntToLongFunction generator) {
        Arrays.setAll(array, generator);
    }

    public static void sort(byte[] array) {
        ArrayHelper.sortPrimitive((Object)array);
    }

    public static void sort(byte[] array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive((Object)array, fromIndex, toIndex);
    }

    public static void sort(char[] array) {
        ArrayHelper.sortPrimitive((Object)array);
    }

    public static void sort(char[] array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive((Object)array, fromIndex, toIndex);
    }

    public static void sort(double[] array) {
        ArrayHelper.sortPrimitive(array);
    }

    public static void sort(double[] array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive(array, fromIndex, toIndex);
    }

    public static void sort(float[] array) {
        ArrayHelper.sortPrimitive(array);
    }

    public static void sort(float[] array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive(array, fromIndex, toIndex);
    }

    public static void sort(short[] array) {
        ArrayHelper.sortPrimitive((Object)array);
    }

    public static void sort(short[] array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive((Object)array, fromIndex, toIndex);
    }

    public static void sort(int[] array) {
        ArrayHelper.sortPrimitive((Object)array);
    }

    public static void sort(int[] array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive((Object)array, fromIndex, toIndex);
    }

    public static void sort(long[] array) {
        ArrayHelper.sortPrimitive(array);
    }

    public static void sort(long[] array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive(array, fromIndex, toIndex);
    }

    public static void sort(Object[] array) {
        Arrays.sort(array, null);
    }

    public static void sort(Object[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex, null);
    }

    public static <T> void sort(T[] x, Comparator<? super T> c) {
        ArrayHelper.sort(x, Comparators.nullToNaturalOrder(c));
    }

    public static <T> void sort(T[] x, int fromIndex, int toIndex, Comparator<? super T> c) {
        ArrayHelper.sort(x, fromIndex, toIndex, Comparators.nullToNaturalOrder(c));
    }

    public static void parallelSort(byte[] array) {
        Arrays.sort(array);
    }

    public static void parallelSort(byte[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
    }

    public static void parallelSort(char[] array) {
        Arrays.sort(array);
    }

    public static void parallelSort(char[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
    }

    public static void parallelSort(double[] array) {
        Arrays.sort(array);
    }

    public static void parallelSort(double[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
    }

    public static void parallelSort(float[] array) {
        Arrays.sort(array);
    }

    public static void parallelSort(float[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
    }

    public static void parallelSort(int[] array) {
        Arrays.sort(array);
    }

    public static void parallelSort(int[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
    }

    public static void parallelSort(long[] array) {
        Arrays.sort(array);
    }

    public static void parallelSort(long[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
    }

    public static void parallelSort(short[] array) {
        Arrays.sort(array);
    }

    public static void parallelSort(short[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] array) {
        Arrays.sort(array);
    }

    public static <T> void parallelSort(T[] array, Comparator<? super T> c) {
        Arrays.sort(array, c);
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] array, int fromIndex, int toIndex) {
        Arrays.sort(array, fromIndex, toIndex);
    }

    public static <T> void parallelSort(T[] array, int fromIndex, int toIndex, Comparator<? super T> c) {
        Arrays.sort(array, fromIndex, toIndex, c);
    }

    public static Spliterator.OfDouble spliterator(double[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static Spliterator.OfDouble spliterator(double[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static Spliterator.OfInt spliterator(int[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static Spliterator.OfInt spliterator(int[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static Spliterator.OfLong spliterator(long[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static Spliterator.OfLong spliterator(long[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static <T> Spliterator<T> spliterator(T[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static <T> Spliterator<T> spliterator(T[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static DoubleStream stream(double[] array) {
        return Arrays.stream(array, 0, array.length);
    }

    public static DoubleStream stream(double[] array, int startInclusive, int endExclusive) {
        return StreamSupport.doubleStream(Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static IntStream stream(int[] array) {
        return Arrays.stream(array, 0, array.length);
    }

    public static IntStream stream(int[] array, int startInclusive, int endExclusive) {
        return StreamSupport.intStream(Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static LongStream stream(long[] array) {
        return Arrays.stream(array, 0, array.length);
    }

    public static LongStream stream(long[] array, int startInclusive, int endExclusive) {
        return StreamSupport.longStream(Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static <T> Stream<T> stream(T[] array) {
        return Arrays.stream(array, 0, array.length);
    }

    public static <T> Stream<T> stream(T[] array, int startInclusive, int endExclusive) {
        return StreamSupport.stream(Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static String toString(boolean[] a) {
        if (a == null) {
            return "null";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (boolean element : a) {
            joiner.add(String.valueOf(element));
        }
        return joiner.toString();
    }

    public static String toString(byte[] a) {
        if (a == null) {
            return "null";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (byte element : a) {
            joiner.add(String.valueOf(element));
        }
        return joiner.toString();
    }

    public static String toString(char[] a) {
        if (a == null) {
            return "null";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (char element : a) {
            joiner.add(String.valueOf(element));
        }
        return joiner.toString();
    }

    public static String toString(double[] a) {
        if (a == null) {
            return "null";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (double element : a) {
            joiner.add(String.valueOf(element));
        }
        return joiner.toString();
    }

    public static String toString(float[] a) {
        if (a == null) {
            return "null";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (float element : a) {
            joiner.add(String.valueOf(element));
        }
        return joiner.toString();
    }

    public static String toString(int[] a) {
        if (a == null) {
            return "null";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (int element : a) {
            joiner.add(String.valueOf(element));
        }
        return joiner.toString();
    }

    public static String toString(long[] a) {
        if (a == null) {
            return "null";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (long element : a) {
            joiner.add(String.valueOf(element));
        }
        return joiner.toString();
    }

    public static String toString(Object[] x) {
        if (x == null) {
            return "null";
        }
        return Arrays.asList(x).toString();
    }

    public static String toString(short[] a) {
        if (a == null) {
            return "null";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (short element : a) {
            joiner.add(String.valueOf(element));
        }
        return joiner.toString();
    }

    private static String deepToString(Object[] a, Set<Object[]> arraysIveSeen) {
        if (a == null) {
            return "null";
        }
        if (!arraysIveSeen.add(a)) {
            return "[...]";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (Object obj : a) {
            if (obj != null && obj.getClass().isArray()) {
                if (obj instanceof Object[]) {
                    if (arraysIveSeen.contains(obj)) {
                        joiner.add("[...]");
                        continue;
                    }
                    Object[] objArray = (Object[])obj;
                    HashSet<Object[]> tempSet = new HashSet<Object[]>(arraysIveSeen);
                    joiner.add(Arrays.deepToString(objArray, tempSet));
                    continue;
                }
                if (obj instanceof boolean[]) {
                    joiner.add(Arrays.toString((boolean[])obj));
                    continue;
                }
                if (obj instanceof byte[]) {
                    joiner.add(Arrays.toString((byte[])obj));
                    continue;
                }
                if (obj instanceof char[]) {
                    joiner.add(Arrays.toString((char[])obj));
                    continue;
                }
                if (obj instanceof short[]) {
                    joiner.add(Arrays.toString((short[])obj));
                    continue;
                }
                if (obj instanceof int[]) {
                    joiner.add(Arrays.toString((int[])obj));
                    continue;
                }
                if (obj instanceof long[]) {
                    joiner.add(Arrays.toString((long[])obj));
                    continue;
                }
                if (obj instanceof float[]) {
                    joiner.add(Arrays.toString((float[])obj));
                    continue;
                }
                if (obj instanceof double[]) {
                    joiner.add(Arrays.toString((double[])obj));
                    continue;
                }
                assert (false) : "Unexpected array type: " + obj.getClass().getName();
                continue;
            }
            joiner.add(String.valueOf(obj));
        }
        return joiner.toString();
    }

    private Arrays() {
    }

    private static final class ArrayList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private E[] array;

        ArrayList(E[] array) {
            InternalPreconditions.checkNotNull(array);
            this.array = array;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            InternalPreconditions.checkNotNull(consumer);
            for (E e : this.array) {
                consumer.accept(e);
            }
        }

        @Override
        public E get(int index) {
            InternalPreconditions.checkElementIndex(index, this.size());
            return this.array[index];
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            InternalPreconditions.checkNotNull(operator);
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = operator.apply(this.array[i]);
            }
        }

        @Override
        public E set(int index, E value) {
            E was = this.get(index);
            this.array[index] = value;
            return was;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public void sort(Comparator<? super E> c) {
            Arrays.sort(this.array, 0, this.array.length, c);
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.array.length]);
        }

        @Override
        public Iterator<E> iterator() {
            return new ArrayIterator<E>(this.array);
        }

        @Override
        public <T> T[] toArray(T[] out) {
            int size = this.array.length;
            if (out.length < size) {
                out = ArrayHelper.createFrom(out, size);
            }
            for (int i = 0; i < size; ++i) {
                out[i] = this.array[i];
            }
            if (out.length > size) {
                out[size] = null;
            }
            return out;
        }
    }
}

