/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.function.IntConsumer;

public class IntSummaryStatistics
implements IntConsumer {
    private long count;
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;
    private long sum;

    @Override
    public void accept(int value) {
        ++this.count;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
        this.sum += (long)value;
    }

    public void combine(IntSummaryStatistics other) {
        this.count += other.count;
        this.min = Math.min(this.min, other.min);
        this.max = Math.max(this.max, other.max);
        this.sum += other.sum;
    }

    public double getAverage() {
        return this.count > 0L ? (double)this.sum / (double)this.count : 0.0;
    }

    public long getCount() {
        return this.count;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public long getSum() {
        return this.sum;
    }

    public String toString() {
        return "IntSummaryStatistics[count = " + this.count + ", avg = " + this.getAverage() + ", min = " + this.min + ", max = " + this.max + ", sum = " + this.sum + "]";
    }
}

