/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractHashMap;
import java.util.AbstractMap;
import java.util.InternalJsMap;
import java.util.Iterator;
import java.util.Map;
import javaemul.internal.ArrayHelper;
import javaemul.internal.JsUtils;

class InternalHashCodeMap<K, V>
implements Iterable<Map.Entry<K, V>> {
    private final InternalJsMap<Object> backingMap = new InternalJsMap();
    private AbstractHashMap<K, V> host;
    private int size;

    public InternalHashCodeMap(AbstractHashMap<K, V> host) {
        this.host = host;
    }

    public V put(K key, V value) {
        int hashCode = this.hash(key);
        Map.Entry<K, V>[] chain = this.getChainOrEmpty(hashCode);
        if (chain.length == 0) {
            this.backingMap.set(hashCode, chain);
        } else {
            Map.Entry<K, V> entry = this.findEntryInChain(key, chain);
            if (entry != null) {
                return entry.setValue(value);
            }
        }
        chain[chain.length] = new AbstractMap.SimpleEntry<K, V>(key, value);
        ++this.size;
        this.host.structureChanged();
        return null;
    }

    public V remove(Object key) {
        int hashCode = this.hash(key);
        Object[] chain = this.getChainOrEmpty(hashCode);
        for (int i = 0; i < chain.length; ++i) {
            Map.Entry<K, V> entry = chain[i];
            if (!this.host.equals(key, entry.getKey())) continue;
            if (chain.length == 1) {
                ArrayHelper.setLength(chain, 0);
                this.backingMap.delete(hashCode);
            } else {
                ArrayHelper.removeFrom(chain, i, 1);
            }
            --this.size;
            this.host.structureChanged();
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<K, V> getEntry(Object key) {
        return this.findEntryInChain(key, this.getChainOrEmpty(this.hash(key)));
    }

    private Map.Entry<K, V> findEntryInChain(Object key, Map.Entry<K, V>[] chain) {
        for (Map.Entry<K, V> entry : chain) {
            if (!this.host.equals(key, entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>(){
            final InternalJsMap.Iterator<?> chains;
            int itemIndex;
            Map.Entry<K, V>[] chain;
            Map.Entry<K, V> lastEntry;
            {
                this.chains = InternalHashCodeMap.this.backingMap.entries();
                this.itemIndex = 0;
                this.chain = InternalHashCodeMap.this.newEntryChain();
                this.lastEntry = null;
            }

            @Override
            public boolean hasNext() {
                if (this.itemIndex < this.chain.length) {
                    return true;
                }
                InternalJsMap.IteratorEntry<?> current = this.chains.next();
                if (!current.isDone()) {
                    this.chain = (Map.Entry[])JsUtils.uncheckedCast(current.getValue());
                    this.itemIndex = 0;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<K, V> next() {
                this.lastEntry = this.chain[this.itemIndex++];
                return this.lastEntry;
            }

            @Override
            public void remove() {
                InternalHashCodeMap.this.remove(this.lastEntry.getKey());
                if (this.itemIndex != 0) {
                    --this.itemIndex;
                }
            }
        };
    }

    private Map.Entry<K, V>[] getChainOrEmpty(int hashCode) {
        Map.Entry[] chain = (Map.Entry[])JsUtils.uncheckedCast(this.backingMap.get(hashCode));
        return chain == null ? this.newEntryChain() : chain;
    }

    private Map.Entry<K, V>[] newEntryChain() {
        return (Map.Entry[])JsUtils.uncheckedCast(new Object[0]);
    }

    private int hash(Object key) {
        return this.host.getHashCode(key);
    }
}

