/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Comparators;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javaemul.internal.InternalPreconditions;
import jsinterop.annotations.JsEnum;
import jsinterop.annotations.JsNonNull;

public class TreeMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V>,
NavigableMap<K, V>,
Serializable {
    private Comparator<? super K> comparator;
    private Node<K, V> root;
    private int size;
    private int modCount;
    private EntrySet entrySet;
    private KeySet keySet;

    public TreeMap() {
        this((Comparator)null);
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.comparator = Comparators.nullToNaturalOrder(comparator);
    }

    public TreeMap(Map<? extends K, ? extends V> copyFrom) {
        this();
        this.putAll(copyFrom);
    }

    public TreeMap(SortedMap<K, ? extends V> copyFrom) {
        this(copyFrom.comparator());
        this.putAll(copyFrom);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object key) {
        Node<K, V> entry = this.findByObject(key);
        return entry != null ? (V)entry.getValue() : null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findByObject(key) != null;
    }

    @Override
    public V put(K key, V value) {
        return this.putInternal(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putInternalIfAbsent(key, value);
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
        this.structureChanged();
    }

    private void structureChanged() {
        if (!InternalPreconditions.isApiChecked()) {
            return;
        }
        ++this.modCount;
    }

    @Override
    public V remove(Object key) {
        Node<K, V> node = this.removeInternalByKey(key);
        return (V)(node != null ? node.getValue() : null);
    }

    private V putInternal(K key, V value) {
        return (V)this.find(key, Relation.CREATE).setValue((Object)value);
    }

    private V putInternalIfAbsent(K key, V value) {
        Node<K, V> node = this.find(key, Relation.CREATE);
        Object oldValue = node.getValue();
        if (oldValue == null) {
            node.setValue((Object)value);
        }
        return (V)oldValue;
    }

    private Node<K, V> find(K key, Relation relation) {
        if (this.root == null) {
            if (relation == Relation.CREATE) {
                this.root = new Node(null, key);
                this.size = 1;
                this.structureChanged();
                return this.root;
            }
            return null;
        }
        Node<K, V> nearest = this.root;
        while (true) {
            Node child;
            int comparison;
            if ((comparison = this.comparator.compare(key, nearest.getKey())) == 0) {
                switch (relation) {
                    case LOWER: {
                        return nearest.prev();
                    }
                    case FLOOR: 
                    case CEILING: {
                        return nearest;
                    }
                    case HIGHER: {
                        return nearest.next();
                    }
                    case CREATE: {
                        return nearest;
                    }
                }
            }
            Node node = child = comparison < 0 ? nearest.left : nearest.right;
            if (child == null) {
                switch (relation) {
                    case LOWER: 
                    case FLOOR: {
                        return comparison < 0 ? nearest.prev() : nearest;
                    }
                    case CEILING: 
                    case HIGHER: {
                        return comparison < 0 ? nearest : nearest.next();
                    }
                    case CREATE: {
                        Node<K, V> created = new Node<K, V>(nearest, key);
                        if (comparison < 0) {
                            nearest.left = created;
                        } else {
                            nearest.right = created;
                        }
                        ++this.size;
                        this.structureChanged();
                        this.rebalance(nearest, true);
                        return created;
                    }
                }
            }
            nearest = child;
        }
    }

    private K findKey(K key, Relation relation) {
        return TreeMap.getKeyOrNull(this.find(key, relation));
    }

    private Map.Entry<K, V> findEntry(K key, Relation relation) {
        return this.immutableCopy(this.find(key, relation));
    }

    Node<K, V> findByObject(Object key) {
        Node<K, V> node = this.root;
        while (node != null) {
            int c = this.comparator.compare(key, node.getKey());
            if (c == 0) {
                return node;
            }
            node = c < 0 ? node.left : node.right;
        }
        return null;
    }

    private Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        Node<K, V> mine = this.findByObject(entry.getKey());
        boolean valuesEqual = mine != null && Objects.equals(mine.getValue(), entry.getValue());
        return valuesEqual ? mine : null;
    }

    private void removeInternal(Node<K, V> node) {
        Node left = node.left;
        Node right = node.right;
        Node originalParent = node.parent;
        if (left != null && right != null) {
            Node adjacent = left.height > right.height ? left.last() : right.first();
            this.removeInternal(adjacent);
            int leftHeight = 0;
            left = node.left;
            if (left != null) {
                leftHeight = left.height;
                adjacent.left = left;
                left.parent = adjacent;
                node.left = null;
            }
            int rightHeight = 0;
            right = node.right;
            if (right != null) {
                rightHeight = right.height;
                adjacent.right = right;
                right.parent = adjacent;
                node.right = null;
            }
            adjacent.height = Math.max(leftHeight, rightHeight) + 1;
            this.replaceInParent(node, adjacent);
            return;
        }
        if (left != null) {
            this.replaceInParent(node, left);
            node.left = null;
        } else if (right != null) {
            this.replaceInParent(node, right);
            node.right = null;
        } else {
            this.replaceInParent(node, null);
        }
        this.rebalance(originalParent, false);
        --this.size;
        this.structureChanged();
    }

    private Node<K, V> removeInternalByKey(Object key) {
        Node<K, V> node = this.findByObject(key);
        if (node != null) {
            this.removeInternal(node);
        }
        return node;
    }

    private void replaceInParent(Node<K, V> node, Node<K, V> replacement) {
        Node parent = node.parent;
        node.parent = null;
        if (replacement != null) {
            replacement.parent = parent;
        }
        if (parent != null) {
            if (parent.left == node) {
                parent.left = replacement;
            } else {
                parent.right = replacement;
            }
        } else {
            this.root = replacement;
        }
    }

    private void rebalance(Node<K, V> unbalanced, boolean insert) {
        Node<K, V> node = unbalanced;
        while (node != null) {
            Node right;
            int rightHeight;
            Node left = node.left;
            int leftHeight = left != null ? left.height : 0;
            int delta = leftHeight - (rightHeight = (right = node.right) != null ? right.height : 0);
            if (delta == -2) {
                Node rightRight;
                int rightRightHeight;
                Node rightLeft = right.left;
                int rightLeftHeight = rightLeft != null ? rightLeft.height : 0;
                int rightDelta = rightLeftHeight - (rightRightHeight = (rightRight = right.right) != null ? rightRight.height : 0);
                if (rightDelta == -1 || rightDelta == 0 && !insert) {
                    this.rotateLeft(node);
                } else {
                    this.rotateRight(right);
                    this.rotateLeft(node);
                }
                if (insert) {
                    break;
                }
            } else if (delta == 2) {
                Node leftRight;
                int leftRightHeight;
                Node leftLeft = left.left;
                int leftLeftHeight = leftLeft != null ? leftLeft.height : 0;
                int leftDelta = leftLeftHeight - (leftRightHeight = (leftRight = left.right) != null ? leftRight.height : 0);
                if (leftDelta == 1 || leftDelta == 0 && !insert) {
                    this.rotateRight(node);
                } else {
                    this.rotateLeft(left);
                    this.rotateRight(node);
                }
                if (insert) {
                    break;
                }
            } else if (delta == 0) {
                node.height = leftHeight + 1;
                if (insert) {
                    break;
                }
            } else {
                node.height = Math.max(leftHeight, rightHeight) + 1;
                if (!insert) break;
            }
            node = node.parent;
        }
    }

    private void rotateLeft(Node<K, V> root) {
        Node left = root.left;
        Node pivot = root.right;
        Node pivotLeft = pivot.left;
        Node pivotRight = pivot.right;
        root.right = pivotLeft;
        if (pivotLeft != null) {
            pivotLeft.parent = root;
        }
        this.replaceInParent(root, pivot);
        pivot.left = root;
        root.parent = pivot;
        root.height = Math.max(left != null ? left.height : 0, pivotLeft != null ? pivotLeft.height : 0) + 1;
        pivot.height = Math.max(root.height, pivotRight != null ? pivotRight.height : 0) + 1;
    }

    private void rotateRight(Node<K, V> root) {
        Node pivot = root.left;
        Node right = root.right;
        Node pivotLeft = pivot.left;
        Node pivotRight = pivot.right;
        root.left = pivotRight;
        if (pivotRight != null) {
            pivotRight.parent = root;
        }
        this.replaceInParent(root, pivot);
        pivot.right = root;
        root.parent = pivot;
        root.height = Math.max(right != null ? right.height : 0, pivotRight != null ? pivotRight.height : 0) + 1;
        pivot.height = Math.max(root.height, pivotLeft != null ? pivotLeft.height : 0) + 1;
    }

    private AbstractMap.SimpleImmutableEntry<K, V> immutableCopy(Map.Entry<K, V> entry) {
        return entry == null ? null : new AbstractMap.SimpleImmutableEntry<K, V>(entry);
    }

    private Node<K, V> getFirst() {
        return this.root == null ? null : this.root.first();
    }

    private Node<K, V> getLast() {
        return this.root == null ? null : this.root.last();
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.immutableCopy(this.getFirst());
    }

    private Node<K, V> internalPollFirstEntry() {
        if (this.root == null) {
            return null;
        }
        Node<K, V> result = this.root.first();
        this.removeInternal(result);
        return result;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.immutableCopy(this.internalPollFirstEntry());
    }

    @Override
    public K firstKey() {
        InternalPreconditions.checkElement(this.root != null);
        return (K)this.root.first().getKey();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.immutableCopy(this.getLast());
    }

    private Map.Entry<K, V> internalPollLastEntry() {
        if (this.root == null) {
            return null;
        }
        Node<K, V> result = this.root.last();
        this.removeInternal(result);
        return result;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.immutableCopy(this.internalPollLastEntry());
    }

    @Override
    public K lastKey() {
        InternalPreconditions.checkElement(this.root != null);
        return (K)this.root.last().getKey();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.findEntry(key, Relation.LOWER);
    }

    @Override
    public K lowerKey(K key) {
        return this.findKey(key, Relation.LOWER);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.findEntry(key, Relation.FLOOR);
    }

    @Override
    public K floorKey(K key) {
        return this.findKey(key, Relation.FLOOR);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.findEntry(key, Relation.CEILING);
    }

    @Override
    public K ceilingKey(K key) {
        return this.findKey(key, Relation.CEILING);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.findEntry(key, Relation.HIGHER);
    }

    @Override
    public K higherKey(K key) {
        return this.findKey(key, Relation.HIGHER);
    }

    @Override
    public Comparator<? super K> comparator() {
        return Comparators.naturalOrderToNull(this.comparator);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public @JsNonNull Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public NavigableMap<K, V> subMap(K from, boolean fromInclusive, K to, boolean toInclusive) {
        Bound fromBound = fromInclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
        Bound toBound = toInclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
        return new BoundedMap(true, from, fromBound, to, toBound);
    }

    @Override
    public SortedMap<K, V> subMap(K fromInclusive, K toExclusive) {
        return new BoundedMap(true, fromInclusive, Bound.INCLUSIVE, toExclusive, Bound.EXCLUSIVE);
    }

    @Override
    public NavigableMap<K, V> headMap(K to, boolean inclusive) {
        Bound toBound = inclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
        return new BoundedMap(true, null, Bound.NO_BOUND, to, toBound);
    }

    @Override
    public SortedMap<K, V> headMap(K toExclusive) {
        return new BoundedMap(true, null, Bound.NO_BOUND, toExclusive, Bound.EXCLUSIVE);
    }

    @Override
    public NavigableMap<K, V> tailMap(K from, boolean inclusive) {
        Bound fromBound = inclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
        return new BoundedMap(true, from, fromBound, null, Bound.NO_BOUND);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromInclusive) {
        return new BoundedMap(true, fromInclusive, Bound.INCLUSIVE, null, Bound.NO_BOUND);
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new BoundedMap(false, null, Bound.NO_BOUND, null, Bound.NO_BOUND);
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return new BoundedMap(false, null, Bound.NO_BOUND, null, Bound.NO_BOUND).navigableKeySet();
    }

    private static <K> K getKeyOrNull(Map.Entry<K, ?> entry) {
        return entry == null ? null : (K)entry.getKey();
    }

    private final class BoundedMap
    extends AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private final boolean ascending;
        private final K from;
        private final Bound fromBound;
        private final K to;
        private final Bound toBound;
        private java.util.TreeMap$BoundedMap.BoundedEntrySet entrySet;
        private java.util.TreeMap$BoundedMap.BoundedKeySet keySet;

        BoundedMap(boolean ascending, K from, Bound fromBound, K to, Bound toBound) {
            if (fromBound != Bound.NO_BOUND && toBound != Bound.NO_BOUND) {
                InternalPreconditions.checkCriticalArgument(TreeMap.this.comparator.compare(from, to) <= 0);
            } else if (fromBound != Bound.NO_BOUND) {
                int n = TreeMap.this.comparator.compare(from, from);
            } else if (toBound != Bound.NO_BOUND) {
                int n = TreeMap.this.comparator.compare(to, to);
            }
            this.ascending = ascending;
            this.from = from;
            this.fromBound = fromBound;
            this.to = to;
            this.toBound = toBound;
        }

        @Override
        public boolean isEmpty() {
            return this.endpoint(true) == null;
        }

        @Override
        public V get(Object key) {
            return this.isInBounds(key) ? (Object)TreeMap.this.get(key) : null;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.isInBounds(key) && TreeMap.this.containsKey(key);
        }

        @Override
        public V put(K key, V value) {
            this.checkInBounds(key, this.fromBound, this.toBound);
            return TreeMap.this.putInternal(key, value);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkInBounds(key, this.fromBound, this.toBound);
            return TreeMap.this.putInternalIfAbsent(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.isInBounds(key) ? (Object)TreeMap.this.remove(key) : null;
        }

        private boolean isInBounds(Object key) {
            return this.isInBounds(key, this.fromBound, this.toBound);
        }

        private boolean isInBounds(K key, Bound fromBound, Bound toBound) {
            if (fromBound == Bound.INCLUSIVE ? TreeMap.this.comparator.compare(key, this.from) < 0 : fromBound == Bound.EXCLUSIVE && TreeMap.this.comparator.compare(key, this.from) <= 0) {
                return false;
            }
            return !(toBound == Bound.INCLUSIVE ? TreeMap.this.comparator.compare(key, this.to) > 0 : toBound == Bound.EXCLUSIVE && TreeMap.this.comparator.compare(key, this.to) >= 0);
        }

        private void checkInBounds(K key, Bound fromBound, Bound toBound) {
            if (!this.isInBounds(key, fromBound, toBound)) {
                InternalPreconditions.checkCriticalArgument(false, key + " not in range " + this.from + ".." + this.to);
            }
        }

        private Node<K, V> bound(Node<K, V> node, Bound fromBound, Bound toBound) {
            return node != null && this.isInBounds(node.getKey(), fromBound, toBound) ? node : null;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return TreeMap.this.immutableCopy(this.endpoint(true));
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Node result = this.endpoint(true);
            if (result != null) {
                TreeMap.this.removeInternal(result);
            }
            return TreeMap.this.immutableCopy(result);
        }

        @Override
        public K firstKey() {
            Node entry = this.endpoint(true);
            InternalPreconditions.checkElement(entry != null);
            return entry.getKey();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return TreeMap.this.immutableCopy(this.endpoint(false));
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Node result = this.endpoint(false);
            if (result != null) {
                TreeMap.this.removeInternal(result);
            }
            return TreeMap.this.immutableCopy(result);
        }

        @Override
        public K lastKey() {
            Node entry = this.endpoint(false);
            InternalPreconditions.checkElement(entry != null);
            return entry.getKey();
        }

        private Node<K, V> endpoint(boolean first) {
            Node node = null;
            if (this.ascending == first) {
                switch (this.fromBound) {
                    case NO_BOUND: {
                        node = TreeMap.this.getFirst();
                        break;
                    }
                    case INCLUSIVE: {
                        node = TreeMap.this.find(this.from, Relation.CEILING);
                        break;
                    }
                    case EXCLUSIVE: {
                        node = TreeMap.this.find(this.from, Relation.HIGHER);
                    }
                }
                return this.bound(node, Bound.NO_BOUND, this.toBound);
            }
            switch (this.toBound) {
                case NO_BOUND: {
                    node = TreeMap.this.getLast();
                    break;
                }
                case INCLUSIVE: {
                    node = TreeMap.this.find(this.to, Relation.FLOOR);
                    break;
                }
                case EXCLUSIVE: {
                    node = TreeMap.this.find(this.to, Relation.LOWER);
                }
            }
            return this.bound(node, this.fromBound, Bound.NO_BOUND);
        }

        private Node<K, V> findBounded(K key, Relation relation) {
            int comparison;
            relation = relation.forOrder(this.ascending);
            Bound fromBoundForCheck = this.fromBound;
            Bound toBoundForCheck = this.toBound;
            if (this.toBound != Bound.NO_BOUND && (relation == Relation.LOWER || relation == Relation.FLOOR)) {
                comparison = TreeMap.this.comparator.compare(this.to, key);
                if (comparison <= 0) {
                    key = this.to;
                    if (this.toBound == Bound.EXCLUSIVE) {
                        relation = Relation.LOWER;
                    } else if (comparison < 0) {
                        relation = Relation.FLOOR;
                    }
                }
                toBoundForCheck = Bound.NO_BOUND;
            }
            if (this.fromBound != Bound.NO_BOUND && (relation == Relation.CEILING || relation == Relation.HIGHER)) {
                comparison = TreeMap.this.comparator.compare(this.from, key);
                if (comparison >= 0) {
                    key = this.from;
                    if (this.fromBound == Bound.EXCLUSIVE) {
                        relation = Relation.HIGHER;
                    } else if (comparison > 0) {
                        relation = Relation.CEILING;
                    }
                }
                fromBoundForCheck = Bound.NO_BOUND;
            }
            return this.bound(TreeMap.this.find(key, relation), fromBoundForCheck, toBoundForCheck);
        }

        private K findBoundedKey(K key, Relation relation) {
            return TreeMap.getKeyOrNull(this.findBounded(key, relation));
        }

        private Map.Entry<K, V> findBoundedEntry(K key, Relation relation) {
            return TreeMap.this.immutableCopy(this.findBounded(key, relation));
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            return this.findBoundedEntry(key, Relation.LOWER);
        }

        @Override
        public K lowerKey(K key) {
            return this.findBoundedKey(key, Relation.LOWER);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            return this.findBoundedEntry(key, Relation.FLOOR);
        }

        @Override
        public K floorKey(K key) {
            return this.findBoundedKey(key, Relation.FLOOR);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            return this.findBoundedEntry(key, Relation.CEILING);
        }

        @Override
        public K ceilingKey(K key) {
            return this.findBoundedKey(key, Relation.CEILING);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            return this.findBoundedEntry(key, Relation.HIGHER);
        }

        @Override
        public K higherKey(K key) {
            return this.findBoundedKey(key, Relation.HIGHER);
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator forward = TreeMap.this.comparator();
            if (this.ascending) {
                return forward;
            }
            return Collections.reverseOrder(forward);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new BoundedEntrySet();
            }
            return this.entrySet;
        }

        @Override
        public @JsNonNull Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            if (this.keySet == null) {
                this.keySet = new BoundedKeySet();
            }
            return this.keySet;
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return new BoundedMap(!this.ascending, this.from, this.fromBound, this.to, this.toBound);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return new BoundedMap(!this.ascending, this.from, this.fromBound, this.to, this.toBound).navigableKeySet();
        }

        @Override
        public NavigableMap<K, V> subMap(K from, boolean fromInclusive, K to, boolean toInclusive) {
            Bound fromBound = fromInclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
            Bound toBound = toInclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
            return this.subMap(from, fromBound, to, toBound);
        }

        @Override
        public NavigableMap<K, V> subMap(K fromInclusive, K toExclusive) {
            return this.subMap(fromInclusive, Bound.INCLUSIVE, toExclusive, Bound.EXCLUSIVE);
        }

        @Override
        public NavigableMap<K, V> headMap(K to, boolean inclusive) {
            Bound toBound = inclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
            return this.subMap(null, Bound.NO_BOUND, to, toBound);
        }

        @Override
        public NavigableMap<K, V> headMap(K toExclusive) {
            return this.subMap(null, Bound.NO_BOUND, toExclusive, Bound.EXCLUSIVE);
        }

        @Override
        public NavigableMap<K, V> tailMap(K from, boolean inclusive) {
            Bound fromBound = inclusive ? Bound.INCLUSIVE : Bound.EXCLUSIVE;
            return this.subMap(from, fromBound, null, Bound.NO_BOUND);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromInclusive) {
            return this.subMap(fromInclusive, Bound.INCLUSIVE, null, Bound.NO_BOUND);
        }

        private NavigableMap<K, V> subMap(K from, Bound fromBound, K to, Bound toBound) {
            if (!this.ascending) {
                Object fromTmp = from;
                Bound fromBoundTmp = fromBound;
                from = to;
                fromBound = toBound;
                to = fromTmp;
                toBound = fromBoundTmp;
            }
            if (fromBound == Bound.NO_BOUND) {
                from = this.from;
                fromBound = this.fromBound;
            } else {
                Bound fromBoundToCheck = fromBound == this.fromBound ? Bound.INCLUSIVE : this.fromBound;
                this.checkInBounds(from, fromBoundToCheck, this.toBound);
            }
            if (toBound == Bound.NO_BOUND) {
                to = this.to;
                toBound = this.toBound;
            } else {
                Bound toBoundToCheck = toBound == this.toBound ? Bound.INCLUSIVE : this.toBound;
                this.checkInBounds(to, this.fromBound, toBoundToCheck);
            }
            return new BoundedMap(this.ascending, from, fromBound, to, toBound);
        }

        private final class BoundedKeySet
        extends AbstractSet<K>
        implements NavigableSet<K> {
            private BoundedKeySet() {
            }

            @Override
            public int size() {
                return BoundedMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return BoundedMap.this.isEmpty();
            }

            @Override
            public Iterator<K> iterator() {
                return new BoundedIterator(BoundedMap.this.endpoint(true)){

                    @Override
                    public K next() {
                        return (BoundedMap.this.ascending ? this.stepForward() : this.stepBackward()).getKey();
                    }
                };
            }

            @Override
            public Iterator<K> descendingIterator() {
                return new BoundedIterator(BoundedMap.this.endpoint(false)){

                    @Override
                    public K next() {
                        return (BoundedMap.this.ascending ? this.stepBackward() : this.stepForward()).getKey();
                    }
                };
            }

            @Override
            public boolean contains(Object key) {
                return BoundedMap.this.isInBounds(key) && TreeMap.this.findByObject(key) != null;
            }

            @Override
            public boolean remove(Object key) {
                return BoundedMap.this.isInBounds(key) && TreeMap.this.removeInternalByKey(key) != null;
            }

            @Override
            public K first() {
                return BoundedMap.this.firstKey();
            }

            @Override
            public K pollFirst() {
                return TreeMap.getKeyOrNull(TreeMap.this.internalPollFirstEntry());
            }

            @Override
            public K last() {
                return BoundedMap.this.lastKey();
            }

            @Override
            public K pollLast() {
                return TreeMap.getKeyOrNull(TreeMap.this.internalPollLastEntry());
            }

            @Override
            public K lower(K key) {
                return BoundedMap.this.lowerKey(key);
            }

            @Override
            public K floor(K key) {
                return BoundedMap.this.floorKey(key);
            }

            @Override
            public K ceiling(K key) {
                return BoundedMap.this.ceilingKey(key);
            }

            @Override
            public K higher(K key) {
                return BoundedMap.this.higherKey(key);
            }

            @Override
            public Comparator<? super K> comparator() {
                return BoundedMap.this.comparator();
            }

            @Override
            public NavigableSet<K> subSet(K from, boolean fromInclusive, K to, boolean toInclusive) {
                return BoundedMap.this.subMap(from, fromInclusive, to, toInclusive).navigableKeySet();
            }

            @Override
            public SortedSet<K> subSet(K fromInclusive, K toExclusive) {
                return BoundedMap.this.subMap(fromInclusive, toExclusive).navigableKeySet();
            }

            @Override
            public NavigableSet<K> headSet(K to, boolean inclusive) {
                return BoundedMap.this.headMap(to, inclusive).navigableKeySet();
            }

            @Override
            public SortedSet<K> headSet(K toExclusive) {
                return BoundedMap.this.headMap(toExclusive).navigableKeySet();
            }

            @Override
            public NavigableSet<K> tailSet(K from, boolean inclusive) {
                return BoundedMap.this.tailMap(from, inclusive).navigableKeySet();
            }

            @Override
            public SortedSet<K> tailSet(K fromInclusive) {
                return BoundedMap.this.tailMap(fromInclusive).navigableKeySet();
            }

            @Override
            public NavigableSet<K> descendingSet() {
                return new BoundedMap(!BoundedMap.this.ascending, BoundedMap.this.from, BoundedMap.this.fromBound, BoundedMap.this.to, BoundedMap.this.toBound).navigableKeySet();
            }
        }

        private final class BoundedEntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private BoundedEntrySet() {
            }

            @Override
            public int size() {
                int count = 0;
                for (Map.Entry ignored : this) {
                    ++count;
                }
                return count;
            }

            @Override
            public boolean isEmpty() {
                return BoundedMap.this.isEmpty();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new BoundedIterator(BoundedMap.this.endpoint(true)){

                    @Override
                    public Map.Entry<K, V> next() {
                        return BoundedMap.this.ascending ? this.stepForward() : this.stepBackward();
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return BoundedMap.this.isInBounds(entry.getKey()) && TreeMap.this.findByEntry(entry) != null;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return BoundedMap.this.isInBounds(entry.getKey()) && TreeMap.this.entrySet().remove(entry);
            }
        }

        private abstract class BoundedIterator<T>
        extends MapIterator<T> {
            protected BoundedIterator(Node<K, V> next) {
                super(next);
            }

            @Override
            protected Node<K, V> stepForward() {
                Node result = super.stepForward();
                this.next = BoundedMap.this.bound(this.next, Bound.NO_BOUND, BoundedMap.this.toBound);
                return result;
            }

            @Override
            protected Node<K, V> stepBackward() {
                Node result = super.stepBackward();
                this.next = BoundedMap.this.bound(this.next, BoundedMap.this.fromBound, Bound.NO_BOUND);
                return result;
            }
        }
    }

    @JsEnum
    private static enum Bound {
        INCLUSIVE,
        EXCLUSIVE,
        NO_BOUND;

    }

    private class KeySet
    extends AbstractSet<K>
    implements NavigableSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return TreeMap.this.size;
        }

        @Override
        public Iterator<K> iterator() {
            return new MapIterator<K>(TreeMap.this.getFirst()){

                @Override
                public K next() {
                    return this.stepForward().getKey();
                }
            };
        }

        @Override
        public Iterator<K> descendingIterator() {
            return new MapIterator<K>(TreeMap.this.getLast()){

                @Override
                public K next() {
                    return this.stepBackward().getKey();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return TreeMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object key) {
            return TreeMap.this.removeInternalByKey(key) != null;
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }

        @Override
        public Comparator<? super K> comparator() {
            return TreeMap.this.comparator();
        }

        @Override
        public K first() {
            return TreeMap.this.firstKey();
        }

        @Override
        public K last() {
            return TreeMap.this.lastKey();
        }

        @Override
        public K lower(K key) {
            return TreeMap.this.lowerKey(key);
        }

        @Override
        public K floor(K key) {
            return TreeMap.this.floorKey(key);
        }

        @Override
        public K ceiling(K key) {
            return TreeMap.this.ceilingKey(key);
        }

        @Override
        public K higher(K key) {
            return TreeMap.this.higherKey(key);
        }

        @Override
        public K pollFirst() {
            return TreeMap.getKeyOrNull(TreeMap.this.internalPollFirstEntry());
        }

        @Override
        public K pollLast() {
            return TreeMap.getKeyOrNull(TreeMap.this.internalPollLastEntry());
        }

        @Override
        public NavigableSet<K> subSet(K from, boolean fromInclusive, K to, boolean toInclusive) {
            return TreeMap.this.subMap(from, fromInclusive, to, toInclusive).navigableKeySet();
        }

        @Override
        public SortedSet<K> subSet(K fromInclusive, K toExclusive) {
            return TreeMap.this.subMap(fromInclusive, true, toExclusive, false).navigableKeySet();
        }

        @Override
        public NavigableSet<K> headSet(K to, boolean inclusive) {
            return TreeMap.this.headMap(to, inclusive).navigableKeySet();
        }

        @Override
        public SortedSet<K> headSet(K toExclusive) {
            return TreeMap.this.headMap(toExclusive, false).navigableKeySet();
        }

        @Override
        public NavigableSet<K> tailSet(K from, boolean inclusive) {
            return TreeMap.this.tailMap(from, inclusive).navigableKeySet();
        }

        @Override
        public SortedSet<K> tailSet(K fromInclusive) {
            return TreeMap.this.tailMap(fromInclusive, true).navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return new BoundedMap(false, null, Bound.NO_BOUND, null, Bound.NO_BOUND).navigableKeySet();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return TreeMap.this.size;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MapIterator<Map.Entry<K, V>>(TreeMap.this.getFirst()){

                @Override
                public Map.Entry<K, V> next() {
                    return this.stepForward();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof Map.Entry && TreeMap.this.findByEntry((Map.Entry)o) != null;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Node node = TreeMap.this.findByEntry((Map.Entry)o);
            if (node == null) {
                return false;
            }
            TreeMap.this.removeInternal(node);
            return true;
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }
    }

    private abstract class MapIterator<T>
    implements Iterator<T> {
        protected Node<K, V> next;
        protected Node<K, V> last;
        protected int expectedModCount;

        MapIterator(Node<K, V> next) {
            this.expectedModCount = TreeMap.this.modCount;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        protected Node<K, V> stepForward() {
            InternalPreconditions.checkElement(this.next != null);
            InternalPreconditions.checkConcurrentModification(TreeMap.this.modCount, this.expectedModCount);
            this.last = this.next;
            this.next = this.next.next();
            return this.last;
        }

        protected Node<K, V> stepBackward() {
            InternalPreconditions.checkElement(this.next != null);
            InternalPreconditions.checkConcurrentModification(TreeMap.this.modCount, this.expectedModCount);
            this.last = this.next;
            this.next = this.next.prev();
            return this.last;
        }

        @Override
        public void remove() {
            InternalPreconditions.checkState(this.last != null);
            TreeMap.this.removeInternal(this.last);
            this.expectedModCount = TreeMap.this.modCount;
            this.last = null;
        }
    }

    private static class Node<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        Node<K, V> parent;
        Node<K, V> left;
        Node<K, V> right;
        int height;

        Node(Node<K, V> parent, K key) {
            super(key, null);
            this.parent = parent;
            this.height = 1;
        }

        Node<K, V> next() {
            if (this.right != null) {
                return this.right.first();
            }
            Node<K, V> node = this;
            Node<K, V> parent = node.parent;
            while (parent != null) {
                if (parent.left == node) {
                    return parent;
                }
                node = parent;
                parent = node.parent;
            }
            return null;
        }

        Node<K, V> prev() {
            if (this.left != null) {
                return this.left.last();
            }
            Node<K, V> node = this;
            Node<K, V> parent = node.parent;
            while (parent != null) {
                if (parent.right == node) {
                    return parent;
                }
                node = parent;
                parent = node.parent;
            }
            return null;
        }

        Node<K, V> first() {
            Node<K, V> node = this;
            Node<K, V> child = node.left;
            while (child != null) {
                node = child;
                child = node.left;
            }
            return node;
        }

        Node<K, V> last() {
            Node<K, V> node = this;
            Node<K, V> child = node.right;
            while (child != null) {
                node = child;
                child = node.right;
            }
            return node;
        }
    }

    @JsEnum
    private static enum Relation {
        LOWER,
        FLOOR,
        CEILING,
        HIGHER,
        CREATE;


        Relation forOrder(boolean ascending) {
            if (ascending) {
                return this;
            }
            switch (this) {
                case LOWER: {
                    return HIGHER;
                }
                case FLOOR: {
                    return CEILING;
                }
                case CEILING: {
                    return FLOOR;
                }
                case HIGHER: {
                    return LOWER;
                }
            }
            throw new IllegalStateException();
        }
    }
}

