/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LongSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.DoubleStreamImpl;
import java.util.stream.IntStream;
import java.util.stream.IntStreamImpl;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamImpl;
import java.util.stream.TerminatableStream;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.PrimitiveLists;

final class LongStreamImpl
extends TerminatableStream<LongStreamImpl>
implements LongStream {
    private final Spliterator.OfLong spliterator;

    public LongStreamImpl(TerminatableStream<?> previous, Spliterator.OfLong spliterator) {
        super(previous);
        this.spliterator = spliterator;
    }

    @Override
    public void forEach(LongConsumer action) {
        this.forEachOrdered(action);
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        this.terminate();
        this.spliterator.forEachRemaining(action);
    }

    @Override
    public long[] toArray() {
        this.terminate();
        PrimitiveLists.Long entries = PrimitiveLists.createForLong();
        this.spliterator.forEachRemaining(value -> entries.push(value));
        return entries.toArray();
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        this.terminate();
        ValueConsumer holder = new ValueConsumer();
        holder.value = identity;
        this.spliterator.forEachRemaining(value -> holder.accept(op.applyAsLong(holder.value, value)));
        return holder.value;
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        ValueConsumer holder = new ValueConsumer();
        if (this.spliterator.tryAdvance(holder)) {
            return OptionalLong.of(this.reduce(holder.value, op));
        }
        this.terminate();
        return OptionalLong.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        this.terminate();
        Object acc = supplier.get();
        this.spliterator.forEachRemaining(value -> accumulator.accept(acc, value));
        return acc;
    }

    @Override
    public long sum() {
        return this.summaryStatistics().getSum();
    }

    @Override
    public OptionalLong min() {
        LongSummaryStatistics stats = this.summaryStatistics();
        if (stats.getCount() == 0L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(stats.getMin());
    }

    @Override
    public OptionalLong max() {
        LongSummaryStatistics stats = this.summaryStatistics();
        if (stats.getCount() == 0L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(stats.getMax());
    }

    @Override
    public long count() {
        this.terminate();
        long count = 0L;
        while (this.spliterator.tryAdvance(value -> {})) {
            ++count;
        }
        return count;
    }

    @Override
    public OptionalDouble average() {
        LongSummaryStatistics stats = this.summaryStatistics();
        if (stats.getCount() == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(stats.getAverage());
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        return this.collect(LongSummaryStatistics::new, (longSummaryStatistics, value) -> longSummaryStatistics.accept(value), LongSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        return this.filter(predicate).findFirst().isPresent();
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        return !this.anyMatch(predicate.negate());
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalLong findFirst() {
        this.terminate();
        ValueConsumer holder = new ValueConsumer();
        if (this.spliterator.tryAdvance(holder)) {
            return OptionalLong.of(holder.value);
        }
        return OptionalLong.empty();
    }

    @Override
    public OptionalLong findAny() {
        return this.findFirst();
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public Spliterator.OfLong spliterator() {
        this.terminate();
        return this.spliterator;
    }

    @Override
    public LongStream filter(LongPredicate predicate) {
        this.throwIfTerminated();
        return new LongStreamImpl(this, new FilterSpliterator(predicate, this.spliterator));
    }

    @Override
    public LongStream map(LongUnaryOperator mapper) {
        this.throwIfTerminated();
        return new LongStreamImpl(this, new MapToLongSpliterator(mapper, this.spliterator));
    }

    @Override
    public <U> Stream<U> mapToObj(LongFunction<? extends U> mapper) {
        this.throwIfTerminated();
        return new StreamImpl<U>(this, new MapToObjSpliterator<U>(mapper, this.spliterator));
    }

    @Override
    public IntStream mapToInt(LongToIntFunction mapper) {
        this.throwIfTerminated();
        return new IntStreamImpl(this, new MapToIntSpliterator(mapper, this.spliterator));
    }

    @Override
    public DoubleStream mapToDouble(LongToDoubleFunction mapper) {
        this.throwIfTerminated();
        return new DoubleStreamImpl(this, new MapToDoubleSpliterator(mapper, this.spliterator));
    }

    @Override
    public LongStream flatMap(LongFunction<? extends LongStream> mapper) {
        this.throwIfTerminated();
        final MapToObjSpliterator<? extends LongStream> spliteratorOfStreams = new MapToObjSpliterator<LongStream>(mapper, this.spliterator);
        Spliterators.AbstractLongSpliterator flatMapSpliterator = new Spliterators.AbstractLongSpliterator(Long.MAX_VALUE, 0){
            LongStream nextStream;
            Spliterator.OfLong next;

            @Override
            public boolean tryAdvance(LongConsumer action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.nextStream.close();
                    this.nextStream = null;
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance((? super T n) -> {
                        if (n != null) {
                            this.nextStream = n;
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        return new LongStreamImpl(this, flatMapSpliterator);
    }

    @Override
    public LongStream distinct() {
        this.throwIfTerminated();
        HashSet seen = new HashSet();
        return this.filter(seen::add);
    }

    @Override
    public LongStream sorted() {
        this.throwIfTerminated();
        Spliterators.AbstractLongSpliterator sortedSpliterator = new Spliterators.AbstractLongSpliterator(this.spliterator.estimateSize(), this.spliterator.characteristics() | 4){
            Spliterator.OfLong ordered;
            {
                this.ordered = null;
            }

            @Override
            public Comparator<? super Long> getComparator() {
                return null;
            }

            @Override
            public boolean tryAdvance(LongConsumer action) {
                if (this.ordered == null) {
                    PrimitiveLists.Long list = PrimitiveLists.createForLong();
                    LongStreamImpl.this.spliterator.forEachRemaining(value -> list.push(value));
                    Arrays.sort(list.internalArray(), 0, list.size());
                    this.ordered = Spliterators.spliterator(list.internalArray(), 0, list.size(), this.characteristics());
                }
                return this.ordered.tryAdvance(action);
            }
        };
        return new LongStreamImpl(this, sortedSpliterator);
    }

    @Override
    public LongStream peek(final LongConsumer action) {
        InternalPreconditions.checkNotNull(action);
        this.throwIfTerminated();
        Spliterators.AbstractLongSpliterator peekSpliterator = new Spliterators.AbstractLongSpliterator(this.spliterator.estimateSize(), this.spliterator.characteristics()){

            @Override
            public boolean tryAdvance(LongConsumer innerAction) {
                return LongStreamImpl.this.spliterator.tryAdvance(action.andThen(innerAction));
            }
        };
        return new LongStreamImpl(this, peekSpliterator);
    }

    @Override
    public LongStream limit(long maxSize) {
        this.throwIfTerminated();
        InternalPreconditions.checkState(maxSize >= 0L, "maxSize may not be negative");
        return new LongStreamImpl(this, new LimitSpliterator(maxSize, this.spliterator));
    }

    @Override
    public LongStream skip(long n) {
        this.throwIfTerminated();
        InternalPreconditions.checkState(n >= 0L, "n may not be negative");
        if (n == 0L) {
            return this;
        }
        return new LongStreamImpl(this, new SkipSpliterator(n, this.spliterator));
    }

    @Override
    public DoubleStream asDoubleStream() {
        return this.mapToDouble(x -> x);
    }

    @Override
    public Stream<Long> boxed() {
        return this.mapToObj(Long::valueOf);
    }

    @Override
    public LongStream sequential() {
        this.throwIfTerminated();
        return this;
    }

    @Override
    public LongStream parallel() {
        this.throwIfTerminated();
        return this;
    }

    @Override
    public boolean isParallel() {
        this.throwIfTerminated();
        return false;
    }

    @Override
    public LongStream unordered() {
        this.throwIfTerminated();
        return this;
    }

    private static final class ValueConsumer
    implements LongConsumer {
        long value;

        private ValueConsumer() {
        }

        @Override
        public void accept(long value) {
            this.value = value;
        }
    }

    private static final class LimitSpliterator
    extends Spliterators.AbstractLongSpliterator {
        private final long limit;
        private final Spliterator.OfLong original;
        private int position = 0;

        public LimitSpliterator(long limit, Spliterator.OfLong original) {
            super(original.hasCharacteristics(64) ? Math.min(original.estimateSize(), limit) : Long.MAX_VALUE, original.characteristics());
            this.limit = limit;
            this.original = original;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if ((long)this.position >= this.limit) {
                return false;
            }
            boolean result = this.original.tryAdvance(action);
            ++this.position;
            return result;
        }
    }

    private static final class SkipSpliterator
    extends Spliterators.AbstractLongSpliterator {
        private long skip;
        private final Spliterator.OfLong original;

        public SkipSpliterator(long skip, Spliterator.OfLong original) {
            super(original.hasCharacteristics(64) ? Math.max(0L, original.estimateSize() - skip) : Long.MAX_VALUE, original.characteristics());
            this.skip = skip;
            this.original = original;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            while (this.skip > 0L) {
                if (!this.original.tryAdvance(ignore -> {})) {
                    return false;
                }
                --this.skip;
            }
            return this.original.tryAdvance(action);
        }
    }

    private static final class FilterSpliterator
    extends Spliterators.AbstractLongSpliterator {
        private final LongPredicate filter;
        private final Spliterator.OfLong original;
        private boolean found;

        public FilterSpliterator(LongPredicate filter, Spliterator.OfLong original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFBFBF);
            InternalPreconditions.checkNotNull(filter);
            this.filter = filter;
            this.original = original;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            this.found = false;
            while (!this.found && this.original.tryAdvance(item -> {
                if (this.filter.test(item)) {
                    this.found = true;
                    action.accept(item);
                }
            })) {
            }
            return this.found;
        }
    }

    private static final class MapToDoubleSpliterator
    extends Spliterators.AbstractDoubleSpliterator {
        private final LongToDoubleFunction map;
        private final Spliterator.OfLong original;

        public MapToDoubleSpliterator(LongToDoubleFunction map, Spliterator.OfLong original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            return this.original.tryAdvance(u -> action.accept(this.map.applyAsDouble(u)));
        }
    }

    private static final class MapToLongSpliterator
    extends Spliterators.AbstractLongSpliterator {
        private final LongUnaryOperator map;
        private final Spliterator.OfLong original;

        public MapToLongSpliterator(LongUnaryOperator map, Spliterator.OfLong original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            return this.original.tryAdvance(u -> action.accept(this.map.applyAsLong(u)));
        }
    }

    private static final class MapToObjSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final LongFunction<? extends T> map;
        private final Spliterator.OfLong original;

        public MapToObjSpliterator(LongFunction<? extends T> map, Spliterator.OfLong original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.original.tryAdvance(u -> action.accept((T)this.map.apply(u)));
        }
    }

    private static final class MapToIntSpliterator
    extends Spliterators.AbstractIntSpliterator {
        private final LongToIntFunction map;
        private final Spliterator.OfLong original;

        public MapToIntSpliterator(LongToIntFunction map, Spliterator.OfLong original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            return this.original.tryAdvance(u -> action.accept(this.map.applyAsInt(u)));
        }
    }

    static class Empty
    extends TerminatableStream<Empty>
    implements LongStream {
        public Empty(TerminatableStream<?> previous) {
            super(previous);
        }

        @Override
        public LongStream filter(LongPredicate predicate) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public LongStream map(LongUnaryOperator mapper) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public <U> Stream<U> mapToObj(LongFunction<? extends U> mapper) {
            this.throwIfTerminated();
            return new StreamImpl.Empty(this);
        }

        @Override
        public IntStream mapToInt(LongToIntFunction mapper) {
            this.throwIfTerminated();
            return new IntStreamImpl.Empty(this);
        }

        @Override
        public DoubleStream mapToDouble(LongToDoubleFunction mapper) {
            this.throwIfTerminated();
            return new DoubleStreamImpl.Empty(this);
        }

        @Override
        public LongStream flatMap(LongFunction<? extends LongStream> mapper) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public LongStream distinct() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public LongStream sorted() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public LongStream peek(LongConsumer action) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public LongStream limit(long maxSize) {
            this.throwIfTerminated();
            InternalPreconditions.checkState(maxSize >= 0L, "maxSize may not be negative");
            return this;
        }

        @Override
        public LongStream skip(long n) {
            this.throwIfTerminated();
            InternalPreconditions.checkState(n >= 0L, "n may not be negative");
            return this;
        }

        @Override
        public void forEach(LongConsumer action) {
            this.terminate();
        }

        @Override
        public void forEachOrdered(LongConsumer action) {
            this.terminate();
        }

        @Override
        public long[] toArray() {
            this.terminate();
            return new long[0];
        }

        @Override
        public long reduce(long identity, LongBinaryOperator op) {
            this.terminate();
            return identity;
        }

        @Override
        public OptionalLong reduce(LongBinaryOperator op) {
            this.terminate();
            return OptionalLong.empty();
        }

        @Override
        public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
            this.terminate();
            return supplier.get();
        }

        @Override
        public long sum() {
            this.terminate();
            return 0L;
        }

        @Override
        public OptionalLong min() {
            this.terminate();
            return OptionalLong.empty();
        }

        @Override
        public OptionalLong max() {
            this.terminate();
            return OptionalLong.empty();
        }

        @Override
        public long count() {
            this.terminate();
            return 0L;
        }

        @Override
        public OptionalDouble average() {
            this.terminate();
            return OptionalDouble.empty();
        }

        @Override
        public LongSummaryStatistics summaryStatistics() {
            this.terminate();
            return new LongSummaryStatistics();
        }

        @Override
        public boolean anyMatch(LongPredicate predicate) {
            this.terminate();
            return false;
        }

        @Override
        public boolean allMatch(LongPredicate predicate) {
            this.terminate();
            return true;
        }

        @Override
        public boolean noneMatch(LongPredicate predicate) {
            this.terminate();
            return true;
        }

        @Override
        public OptionalLong findFirst() {
            this.terminate();
            return OptionalLong.empty();
        }

        @Override
        public OptionalLong findAny() {
            this.terminate();
            return OptionalLong.empty();
        }

        @Override
        public DoubleStream asDoubleStream() {
            this.throwIfTerminated();
            return new DoubleStreamImpl.Empty(this);
        }

        @Override
        public Stream<Long> boxed() {
            this.throwIfTerminated();
            return new StreamImpl.Empty<Long>(this);
        }

        @Override
        public LongStream sequential() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public LongStream parallel() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public PrimitiveIterator.OfLong iterator() {
            return Spliterators.iterator(this.spliterator());
        }

        @Override
        public Spliterator.OfLong spliterator() {
            this.terminate();
            return Spliterators.emptyLongSpliterator();
        }

        @Override
        public boolean isParallel() {
            this.throwIfTerminated();
            return false;
        }

        @Override
        public LongStream unordered() {
            this.throwIfTerminated();
            return this;
        }
    }
}

