/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import java.io.Serializable;
import javaemul.internal.Constructor;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.annotations.DoNotAutobox;
import javaemul.internal.annotations.UncheckedCast;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(namespace="vmbootstrap")
class Enums {
    Enums() {
    }

    public static <T extends Enum<T>> NativeMap<String, T> createMapFromValues(T[] values) {
        NativeMap<String, T> map = new NativeMap<String, T>();
        for (int i = 0; i < values.length; ++i) {
            String name = ((Enum)values[i]).name();
            map.set(name, values[i]);
        }
        return map;
    }

    @UncheckedCast
    public static <V> V getValueFromNameAndMap(String name, NativeMap<String, V> map) {
        InternalPreconditions.checkCriticalNotNull(name);
        V enumValue = map.get(name);
        if (enumValue == null) {
            throw new IllegalArgumentException();
        }
        return enumValue;
    }

    public static <T> BoxedLightEnum<T> box(T value, Constructor ctor) {
        if (value == null) {
            return null;
        }
        InternalPreconditions.checkArgument(!(value instanceof BoxedLightEnum));
        return ctor.cache("$$enumValues/" + value, () -> new BoxedLightEnum<Object>(value, ctor));
    }

    public static <T> BoxedComparableLightEnum<T> boxComparable(T value, Constructor ctor) {
        if (value == null) {
            return null;
        }
        InternalPreconditions.checkArgument(!(value instanceof BoxedLightEnum));
        return ctor.cache("$$enumValues/" + value, () -> new BoxedComparableLightEnum<Object>(value, ctor));
    }

    public static Object unbox(Object object, Constructor ctor) {
        if (object == null) {
            return null;
        }
        if (InternalPreconditions.isTypeChecked() && !Enums.isInstanceOf(object, ctor)) {
            throw new ClassCastException(object.getClass().getName() + " cannot be cast to " + ctor.getClassName());
        }
        BoxedLightEnum boxedEnum = (BoxedLightEnum)object;
        return boxedEnum.value;
    }

    public static boolean isInstanceOf(Object instance, Constructor ctor) {
        return instance instanceof BoxedLightEnum && ((BoxedLightEnum)instance).constructor == ctor;
    }

    public static boolean equals(@DoNotAutobox Object instance, @DoNotAutobox Object other) {
        InternalPreconditions.checkNotNull(instance);
        return instance == other;
    }

    public static int compareTo(@DoNotAutobox Object instance, @DoNotAutobox Object other) {
        return ((Double)instance).compareTo((Double)other);
    }

    private static class BoxedComparableLightEnum<T>
    extends BoxedLightEnum<T>
    implements Comparable<BoxedComparableLightEnum<T>> {
        @JsConstructor
        private BoxedComparableLightEnum(T value, Constructor ctor) {
            super(value, ctor);
        }

        @Override
        public int compareTo(BoxedComparableLightEnum<T> o) {
            if (this.constructor != o.constructor) {
                throw new ClassCastException();
            }
            return Enums.compareTo(this.value, o.value);
        }
    }

    private static class BoxedLightEnum<T>
    implements Serializable {
        final T value;
        @JsProperty
        final Constructor constructor;

        @JsConstructor
        private BoxedLightEnum(T value, Constructor ctor) {
            this.value = value;
            this.constructor = ctor;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    @JsType(isNative=true, name="Map", namespace="<global>")
    private static class NativeMap<K, V> {
        private NativeMap() {
        }

        public native V get(K var1);

        public native void set(K var1, V var2);
    }
}

