/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.junit.async;

import com.google.common.base.Preconditions;
import com.google.common.reflect.Reflection;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.j2cl.junit.async.Timeout;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestTimedOutException;

public class AsyncTestRunner
extends BlockJUnit4ClassRunner {
    private static final String PROMISE_LIKE = "A promise-like type is a type that is either 'ListenableFuture' or a type with a single 'then' method that has 'success' and 'failure' callback parameters.";

    public AsyncTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (method.getReturnType() == Void.TYPE) {
            return super.methodInvoker(method, test);
        }
        if (method.getReturnType() == ListenableFuture.class) {
            return new ListenableFutureStatement(method, test);
        }
        return new PromiseStatement(method, test);
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        if (method.getReturnType() == Void.TYPE) {
            return super.withPotentialTimeout(method, test, next);
        }
        return next;
    }

    protected Statement withBefores(FrameworkMethod method, final Object target, final Statement next) {
        final List befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return new Statement(){

            public void evaluate() throws Throwable {
                for (FrameworkMethod m : befores) {
                    AsyncTestRunner.this.methodInvoker(m, target).evaluate();
                }
                next.evaluate();
            }
        };
    }

    protected Statement withAfters(FrameworkMethod method, final Object target, final Statement next) {
        final List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    next.evaluate();
                }
                catch (Throwable e) {
                    errors.add(e);
                }
                finally {
                    for (FrameworkMethod m : afters) {
                        try {
                            AsyncTestRunner.this.methodInvoker(m, target).evaluate();
                        }
                        catch (Throwable e) {
                            errors.add(e);
                        }
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod eachTestMethod : methods) {
            this.validateTestMethod(isStatic, errors, eachTestMethod);
        }
    }

    private void validateTestMethod(boolean isStatic, List<Throwable> errors, FrameworkMethod testMethod) {
        Class returnType = testMethod.getReturnType();
        if (testMethod.isStatic() != isStatic) {
            String state = isStatic ? "should" : "should not";
            errors.add(AsyncTestRunner.makeError("Method %s() " + state + " be static", testMethod));
        }
        if (!testMethod.isPublic()) {
            errors.add(AsyncTestRunner.makeError("Method %s() should be public", testMethod));
        }
        if (returnType == Void.TYPE) {
            return;
        }
        if (returnType != ListenableFuture.class) {
            try {
                AsyncTestRunner.getPromiseType(returnType);
            }
            catch (InvalidTypeException e) {
                errors.add(AsyncTestRunner.makeError(e.getMessage()));
                return;
            }
        }
        Test testAnnotation = (Test)testMethod.getAnnotation(Test.class);
        if (AsyncTestRunner.getTimeout(testMethod) <= 0L) {
            errors.add(AsyncTestRunner.makeError(ErrorMessage.ASYNC_HAS_NO_TIMEOUT.format(testMethod.getMethod().getName())));
        }
        if (testAnnotation != null && !testAnnotation.expected().equals(Test.None.class)) {
            errors.add(AsyncTestRunner.makeError(ErrorMessage.ASYNC_HAS_EXPECTED_EXCEPTION.format(testMethod.getMethod().getName())));
        }
    }

    private static long getTimeout(FrameworkMethod testMethod) {
        Test testAnnotation = (Test)testMethod.getAnnotation(Test.class);
        Timeout timeoutAnnotation = (Timeout)testMethod.getAnnotation(Timeout.class);
        return testAnnotation != null ? testAnnotation.timeout() : (timeoutAnnotation != null ? timeoutAnnotation.value() : 0L);
    }

    private static Exception makeError(String message) {
        return new Exception(message);
    }

    private static Exception makeError(String message, FrameworkMethod eachTestMethod) {
        return new Exception(String.format(message, eachTestMethod.getMethod().getName()));
    }

    private static PromiseType getPromiseType(Class<?> shouldBePromise) throws InvalidTypeException {
        List methods = Arrays.stream(shouldBePromise.getMethods()).filter(m -> m.getName().equals("then")).filter(m -> m.getParameterCount() == 2).collect(Collectors.toList());
        if (methods.isEmpty()) {
            throw new InvalidTypeException(ErrorMessage.NO_THEN_METHOD.format(shouldBePromise.getCanonicalName()));
        }
        if (methods.size() > 1) {
            throw new InvalidTypeException(ErrorMessage.MULTIPLE_THEN_METHOD.format(shouldBePromise.getCanonicalName()));
        }
        Method thenMethod = (Method)methods.get(0);
        thenMethod.setAccessible(true);
        Class<?> successCallbackType = AsyncTestRunner.getCallbackType(shouldBePromise, thenMethod.getParameters()[0]);
        Class<?> errorCallbackType = AsyncTestRunner.getCallbackType(shouldBePromise, thenMethod.getParameters()[1]);
        return new PromiseType(thenMethod, successCallbackType, errorCallbackType);
    }

    private static Class<?> getCallbackType(Class<?> promiseLike, Parameter parameter) throws InvalidTypeException {
        if (!AsyncTestRunner.isValidCallbackType(parameter.getType())) {
            throw new InvalidTypeException(ErrorMessage.INVALID_CALLBACK_PARAMETER.format(promiseLike.getCanonicalName(), parameter.getName()));
        }
        return parameter.getType();
    }

    private static boolean isValidCallbackType(Class<?> type) {
        if (!type.isInterface()) {
            return false;
        }
        if (type.getMethods().length != 1) {
            return false;
        }
        Method interfaceMethod = type.getMethods()[0];
        return interfaceMethod.getParameterCount() == 1;
    }

    private static class InvalidTypeException
    extends Exception {
        public InvalidTypeException(String message) {
            super(message);
        }
    }

    private static class PromiseType {
        final Method thenMethod;
        final Class<?> successCallbackType;
        final Class<?> errorCallbackType;

        public PromiseType(Method thenMethod, Class<?> successCallbackType, Class<?> errorCallbackType) {
            this.thenMethod = thenMethod;
            this.successCallbackType = successCallbackType;
            this.errorCallbackType = errorCallbackType;
        }
    }

    private static class PromiseStatement
    extends Statement {
        private final SettableFuture<Void> future = SettableFuture.create();
        private final FrameworkMethod method;
        private final Object test;

        public PromiseStatement(FrameworkMethod method, Object test) {
            this.method = method;
            this.test = test;
        }

        public void evaluate() throws Throwable {
            long timeout = AsyncTestRunner.getTimeout(this.method);
            Object promiseLike = this.method.invokeExplosively(this.test, new Object[0]);
            this.registerCallbacks(promiseLike);
            try {
                this.future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                TestTimedOutException timedOutException = new TestTimedOutException(timeout, TimeUnit.MILLISECONDS);
                timedOutException.setStackTrace(e.getStackTrace());
                throw timedOutException;
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }

        private void registerCallbacks(Object promiseLike) throws Exception {
            Preconditions.checkState((promiseLike != null ? 1 : 0) != 0, (Object)"Test returned null as its promise");
            PromiseType promiseType = AsyncTestRunner.getPromiseType(promiseLike.getClass());
            Object successCallback = this.createSuccessCallback(promiseType);
            Object errorCallback = this.createErrorCallback(promiseType);
            promiseType.thenMethod.invoke(promiseLike, successCallback, errorCallback);
        }

        private Object createErrorCallback(PromiseType promiseType) {
            return Reflection.newProxy(promiseType.errorCallbackType, (proxy, method, args) -> {
                Throwable t = (Throwable)args[0];
                this.future.setException(t);
                return t;
            });
        }

        private Object createSuccessCallback(PromiseType promiseType) {
            return Reflection.newProxy(promiseType.successCallbackType, (proxy, method, args) -> {
                this.future.set(null);
                return args[0];
            });
        }
    }

    private static class ListenableFutureStatement
    extends Statement {
        private final FrameworkMethod method;
        private final Object test;

        public ListenableFutureStatement(FrameworkMethod method, Object test) {
            this.method = method;
            this.test = test;
        }

        public void evaluate() throws Throwable {
            long timeout = AsyncTestRunner.getTimeout(this.method);
            ListenableFuture future = (ListenableFuture)this.method.invokeExplosively(this.test, new Object[0]);
            try {
                future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                TestTimedOutException timedOutException = new TestTimedOutException(timeout, TimeUnit.MILLISECONDS);
                timedOutException.setStackTrace(e.getStackTrace());
                throw timedOutException;
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }

    public static enum ErrorMessage {
        ASYNC_HAS_EXPECTED_EXCEPTION("Method %s has expectedException attribute but returns a promise-like type."),
        ASYNC_HAS_NO_TIMEOUT("Method %s is missing timeout but returns a promise-like type."),
        TEST_HAS_TIMEOUT_ANNOTATION("Method %s cannot have Timeout annotation. @Timeout is only for lifecycle methods. Test methods should use @Test(timeout=x) instead."),
        NO_THEN_METHOD("Type %s is not a promise-like type. It's missing a 'then' method with two parameters. A promise-like type is a type that is either 'ListenableFuture' or a type with a single 'then' method that has 'success' and 'failure' callback parameters."),
        MULTIPLE_THEN_METHOD("Type %s is not a promise-like type. It has multiple 'then' methods with two parameters. A promise-like type is a type that is either 'ListenableFuture' or a type with a single 'then' method that has 'success' and 'failure' callback parameters."),
        INVALID_CALLBACK_PARAMETER("Type '%s' is not a promise-like type. The argument '%s' on the 'then' is not a simple callback interface. A promise-like type is a type that is either 'ListenableFuture' or a type with a single 'then' method that has 'success' and 'failure' callback parameters.");

        private final String formattedMsg;

        private ErrorMessage(String formattedMsg) {
            this.formattedMsg = formattedMsg;
        }

        public String format(Object ... args) {
            return String.format(this.formattedMsg, args);
        }
    }
}

