/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import org.junit.Assert;
import org.junit.AssumptionViolatedException;

public class Assume {
    @Deprecated
    public Assume() {
    }

    public static void assumeTrue(boolean b) {
        Assume.assumeThat(b, true, b);
    }

    public static void assumeFalse(boolean b) {
        Assume.assumeThat(!b, false, b);
    }

    public static void assumeTrue(String message, boolean b) {
        if (!b) {
            throw new AssumptionViolatedException(message);
        }
    }

    public static void assumeFalse(String message, boolean b) {
        Assume.assumeTrue(message, !b);
    }

    public static void assumeNotNull(Object ... objects) {
        Assume.assumeNotNull((Object)objects);
        for (Object o : objects) {
            Assume.assumeNotNull(o);
        }
    }

    private static void assumeNotNull(Object o) {
        if (o == null) {
            throw new AssumptionViolatedException("Got null, but expected non-null");
        }
    }

    private static void assumeThat(boolean condition, Object expected, Object actual) {
        if (!condition) {
            throw new AssumptionViolatedException(Assert.format("Assumption failed", expected, actual));
        }
    }

    public static void assumeNoException(Throwable e) {
        Assume.assumeNoException("", e);
    }

    public static void assumeNoException(String message, Throwable e) {
        if (e != null) {
            throw new AssumptionViolatedException(Assert.buildPrefix(message) + "Expected no exception to be thrown but " + e.getClass().getName() + " was.", e);
        }
    }
}

