goog.module('com.google.j2cl.junit.runtime.JsUnitHelpers$impl');

const j_l_Object = goog.require('java.lang.Object$impl');
const $Util = goog.require('nativebootstrap.Util$impl');

let InternalAssumptionViolatedException = goog.forwardDeclare('com.google.j2cl.junit.runtime.InternalAssumptionViolatedException$impl');
let GoogTestCase = goog.forwardDeclare('goog.testing.TestCase');
let ByteArrayOutputStream = goog.forwardDeclare('java.io.ByteArrayOutputStream$impl');
let PrintStream = goog.forwardDeclare('java.io.PrintStream$impl');
let IllegalStateException = goog.forwardDeclare('java.lang.IllegalStateException$impl');
let j_l_String = goog.forwardDeclare('java.lang.String$impl');
let UnsupportedOperationException = goog.forwardDeclare('java.lang.UnsupportedOperationException$impl');
let $Equality = goog.forwardDeclare('nativebootstrap.Equality$impl');
let $Exceptions = goog.forwardDeclare('vmbootstrap.Exceptions$impl');

/**
 * @final
 */
class JsUnitHelpers extends j_l_Object {
 /** @protected @nodts */
 constructor() {
  super();
 }
 /** @nodts @return {IThenable<?>} */
 static async m_withTimeout__java_lang_Object__double__com_google_j2cl_junit_runtime_JsUnitHelpers_IThenable(/** * */ thenable, /** number */ timeout) {
  JsUnitHelpers.$clinit();
  if ($Equality.$same(thenable, null)) {
   throw $Exceptions.toJs(IllegalStateException.$create__java_lang_String('Test returned null as its promise'));
  }
  GoogTestCase.getActiveTestCase().promiseTimeout = timeout;
  return /**@type {IThenable<*>}*/ (thenable);
 }
 /** @nodts */
 static m_handleAssumptionFailure__com_google_j2cl_junit_runtime_InternalAssumptionViolatedException__void(/** InternalAssumptionViolatedException */ e) {
  JsUnitHelpers.$clinit();
  let outputStream = ByteArrayOutputStream.$create__();
  e.m_printStackTrace__java_io_PrintStream__void(PrintStream.$create__java_io_OutputStream(outputStream));
  GoogTestCase.getActiveTestCase().saveMessage('Skipping test case due to assumption failure: ' + j_l_String.m_valueOf__java_lang_Object__java_lang_String(outputStream));
  throw $Exceptions.toJs(UnsupportedOperationException.$create__java_lang_String__java_lang_Throwable('Assumptions are unsupported in JSUnit', e));
 }
 /** @nodts @return {!JsUnitHelpers} */
 static $create__() {
  let $instance = new JsUnitHelpers();
  $instance.$ctor__com_google_j2cl_junit_runtime_JsUnitHelpers__void();
  return $instance;
 }
 /** @nodts */
 $ctor__com_google_j2cl_junit_runtime_JsUnitHelpers__void() {
  this.$ctor__java_lang_Object__void();
 }
 /** @nodts */
 static $clinit() {
  JsUnitHelpers.$clinit = () =>{};
  JsUnitHelpers.$loadModules();
  j_l_Object.$clinit();
 }
 /** @nodts @return {boolean} */
 static $isInstance(/** ? */ instance) {
  return instance instanceof JsUnitHelpers;
 }
 
 /** @nodts */
 static $loadModules() {
  GoogTestCase = goog.module.get('goog.testing.TestCase');
  ByteArrayOutputStream = goog.module.get('java.io.ByteArrayOutputStream$impl');
  PrintStream = goog.module.get('java.io.PrintStream$impl');
  IllegalStateException = goog.module.get('java.lang.IllegalStateException$impl');
  j_l_String = goog.module.get('java.lang.String$impl');
  UnsupportedOperationException = goog.module.get('java.lang.UnsupportedOperationException$impl');
  $Equality = goog.module.get('nativebootstrap.Equality$impl');
  $Exceptions = goog.module.get('vmbootstrap.Exceptions$impl');
 }
}
$Util.$setClassMetadata(JsUnitHelpers, 'com.google.j2cl.junit.runtime.JsUnitHelpers');

exports = JsUnitHelpers;

//# sourceMappingURL=JsUnitHelpers.js.map
