/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.builder;

import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.integration.eap.maven.EAPBaseDependencyNodeTest;
import org.kie.integration.eap.maven.builder.EAPStaticModulesDependencyBuilderImpl;
import org.kie.integration.eap.maven.model.dependency.EAPCustomModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPModuleMissingDependency;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyNode;

public class EAPStaticModulesDependencyBuilderTest
extends EAPBaseDependencyNodeTest {
    private EAPStaticModulesDependencyBuilderImpl tested;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.tested = new EAPStaticModulesDependencyBuilderImpl();
    }

    @Test
    public void testScanLayer() throws Exception {
        this.buildDependencyNodeTree();
        this.tested.build(this.staticLayer, this.dependencyNode, this.artifactsHolder);
        ((EAPModule)Mockito.verify((Object)this.droolsModule, (VerificationMode)Mockito.times((int)3))).addDependency((EAPModuleDependency)Mockito.isA(EAPCustomModuleDependency.class));
        ((EAPModule)Mockito.verify((Object)this.jbpmModule, (VerificationMode)Mockito.times((int)4))).addDependency((EAPModuleDependency)Mockito.isA(EAPCustomModuleDependency.class));
    }

    @Test
    public void testScanLayerWithMissingDependency() throws Exception {
        this.buildDependencyNodeTree(new EAPBaseDependencyNodeTest.EAPDependencyNodeMockInterceptor(){

            @Override
            public void addChildren(Artifact artifact, List<DependencyNode> children) {
                if (artifact == EAPStaticModulesDependencyBuilderTest.this.jbpmExecutorDependency) {
                    Artifact missingDepArtifact = (Artifact)Mockito.mock(Artifact.class);
                    EAPStaticModulesDependencyBuilderTest.this.initMockArtifact(missingDepArtifact, "org.kie", "missing-artifact", "1.0", "jar", null);
                    DependencyNode missingDepNode = EAPStaticModulesDependencyBuilderTest.this.createDependencyNodeMock(missingDepArtifact, "compile", null);
                    children.add(missingDepNode);
                }
            }
        });
        this.tested.build(this.staticLayer, this.dependencyNode, this.artifactsHolder);
        ((EAPModule)Mockito.verify((Object)this.droolsModule, (VerificationMode)Mockito.times((int)3))).addDependency((EAPModuleDependency)Mockito.isA(EAPCustomModuleDependency.class));
        ((EAPModule)Mockito.verify((Object)this.jbpmModule, (VerificationMode)Mockito.times((int)4))).addDependency((EAPModuleDependency)Mockito.isA(EAPCustomModuleDependency.class));
        ((EAPModule)Mockito.verify((Object)this.jbpmModule, (VerificationMode)Mockito.times((int)1))).addDependency((EAPModuleDependency)Mockito.isA(EAPModuleMissingDependency.class));
    }

    @After
    public void tearDown() throws Exception {
    }
}

