/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.scanner;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.integration.eap.maven.EAPBaseLayerTest;
import org.kie.integration.eap.maven.exception.EAPModuleDefinitionException;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPStaticModuleDependency;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPArtifactResource;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.kie.integration.eap.maven.model.resource.EAPUnresolvableArtifactResource;
import org.kie.integration.eap.maven.scanner.EAPStaticModulesScanner;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.sonatype.aether.artifact.Artifact;

public class EAPStaticModulesScannerTest
extends EAPBaseLayerTest {
    private static final String MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_XML = "/modules/static/drools/org.drools-static-module-pom.xml";
    private static final String MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_NOMODULENAME_XML = "/modules/static/drools/org.drools-static-module-pom-nomodulename.xml";
    private static final String MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_NOMODULENSLOT_XML = "/modules/static/drools/org.drools-static-module-pom-nomoduleslot.xml";
    private static final String MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_NOMODULENLOCATION_XML = "/modules/static/drools/org.drools-static-module-pom-nomodulelocation.xml";
    private static final String MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_XML_FORCE_EXPORTS = "/modules/static/drools/org.drools-static-module-pom-forceexports.xml";
    private static final String MODULES_STATIC_DUPLICATED_MODULE_NAME_POM_XML = "/modules/static/duplicated-module-pom.xml";
    @Mock
    private Artifact droolsStaticModulePom;
    @Mock
    private Artifact droolsTemplatesDependency;
    @Mock
    private Artifact droolsDecisionTablesDependency;
    private EAPStaticModulesScanner tested;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.tested = new EAPStaticModulesScanner();
        this.tested.setLogger(this.logger);
        this.initDroolsStaticModulePom(MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_XML);
        this.initMockArtifact(this.droolsTemplatesDependency, "org.drools", "drools-templates", null, "jar", null);
        this.initMockArtifact(this.droolsDecisionTablesDependency, "org.drools", "drools-decisiontables", null, "jar", null);
    }

    protected void initDroolsStaticModulePom(String pomUri) throws Exception {
        this.initMockArtifact(this.droolsStaticModulePom, "org.kie", "org-drools", "1.0", "pom", null, pomUri);
    }

    @Test
    public void testScanLayer() throws Exception {
        String layerName = "droolsLayer";
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.droolsStaticModulePom);
        this.tested.setScanStaticDependencies(true);
        this.tested.setScanResources(true);
        this.tested.setArtifactTreeResolved(true);
        this.tested.setBaseModulesLayer(this.baseModuleLayer);
        this.addArtifactIntoHolder(this.droolsTemplatesDependency);
        this.addArtifactIntoHolder(this.droolsDecisionTablesDependency);
        EAPLayer droolsLayer = this.tested.scan(layerName, moduleArtifacts, null, this.artifactsHolder);
        this.assertDroolsLayer(droolsLayer, layerName, true, EAPArtifactResource.class, true);
    }

    @Test
    public void testScanLayerDuplicatedModuleInBaeLayer() throws Exception {
        String layerName = "droolsLayer";
        Artifact duplicatedModuleArtifact = (Artifact)Mockito.mock(Artifact.class);
        this.initMockArtifact(duplicatedModuleArtifact, "org.kie", "org-duplicated-module", "1.0", "pom", null, MODULES_STATIC_DUPLICATED_MODULE_NAME_POM_XML);
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.droolsStaticModulePom);
        moduleArtifacts.add(duplicatedModuleArtifact);
        this.tested.setScanStaticDependencies(true);
        this.tested.setScanResources(true);
        this.tested.setArtifactTreeResolved(true);
        this.tested.setBaseModulesLayer(this.baseModuleLayer);
        this.addArtifactIntoHolder(this.droolsTemplatesDependency);
        this.addArtifactIntoHolder(this.droolsDecisionTablesDependency);
        Exception result = null;
        try {
            EAPLayer droolsLayer = this.tested.scan(layerName, moduleArtifacts, null, this.artifactsHolder);
        }
        catch (Exception e) {
            result = e;
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(result.getClass(), EAPModuleDefinitionException.class);
    }

    @Test
    public void testScanLayerModuleArtifactsNotInHolder() throws Exception {
        String layerName = "droolsLayer";
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.droolsStaticModulePom);
        this.tested.setScanStaticDependencies(true);
        this.tested.setScanResources(true);
        this.tested.setArtifactTreeResolved(true);
        this.tested.setBaseModulesLayer(this.baseModuleLayer);
        this.cleanArtifactsInHolder();
        EAPLayer droolsLayer = this.tested.scan(layerName, moduleArtifacts, null, this.artifactsHolder);
        this.assertDroolsLayer(droolsLayer, layerName, true, EAPUnresolvableArtifactResource.class, true);
    }

    @Test
    public void testScanLayerTreeNotResolved() throws Exception {
        String layerName = "droolsLayer";
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.droolsStaticModulePom);
        this.tested.setScanStaticDependencies(true);
        this.tested.setScanResources(true);
        this.tested.setArtifactTreeResolved(false);
        this.tested.setBaseModulesLayer(this.baseModuleLayer);
        this.addArtifactIntoHolder(this.droolsTemplatesDependency);
        this.addArtifactIntoHolder(this.droolsDecisionTablesDependency);
        EAPLayer droolsLayer = this.tested.scan(layerName, moduleArtifacts, null, this.artifactsHolder);
        this.assertDroolsLayer(droolsLayer, layerName, true, EAPArtifactResource.class, true);
    }

    @Test
    public void testScanLayerNoScanStaticDeps() throws Exception {
        String layerName = "droolsLayer";
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.droolsStaticModulePom);
        this.tested.setScanStaticDependencies(false);
        this.tested.setScanResources(true);
        this.tested.setArtifactTreeResolved(false);
        this.tested.setBaseModulesLayer(this.baseModuleLayer);
        this.addArtifactIntoHolder(this.droolsTemplatesDependency);
        this.addArtifactIntoHolder(this.droolsDecisionTablesDependency);
        EAPLayer droolsLayer = this.tested.scan(layerName, moduleArtifacts, null, this.artifactsHolder);
        this.assertDroolsLayer(droolsLayer, layerName, true, EAPArtifactResource.class, false);
        EAPModule droolsModule = droolsLayer.getModule("org.drools:1.0");
        Assert.assertTrue((droolsModule.getDependencies().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testScanLayerNoScanStaticDepsNeitherResources() throws Exception {
        String layerName = "droolsLayer";
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.droolsStaticModulePom);
        this.tested.setScanStaticDependencies(false);
        this.tested.setScanResources(false);
        this.tested.setArtifactTreeResolved(false);
        this.tested.setBaseModulesLayer(this.baseModuleLayer);
        this.addArtifactIntoHolder(this.droolsTemplatesDependency);
        this.addArtifactIntoHolder(this.droolsDecisionTablesDependency);
        EAPLayer droolsLayer = this.tested.scan(layerName, moduleArtifacts, null, this.artifactsHolder);
        this.assertDroolsLayer(droolsLayer, layerName, false, EAPArtifactResource.class, false);
        EAPModule droolsModule = droolsLayer.getModule("org.drools:1.0");
        Assert.assertTrue((droolsModule.getResources().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testScanLayerNoBaseLayer() throws Exception {
        String layerName = "droolsLayer";
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.droolsStaticModulePom);
        this.tested.setScanStaticDependencies(true);
        this.tested.setScanResources(true);
        this.tested.setArtifactTreeResolved(false);
        this.addArtifactIntoHolder(this.droolsTemplatesDependency);
        this.addArtifactIntoHolder(this.droolsDecisionTablesDependency);
        EAPLayer droolsLayer = this.tested.scan(layerName, moduleArtifacts, null, this.artifactsHolder);
        this.assertDroolsLayer(droolsLayer, layerName, true, EAPArtifactResource.class, false);
        EAPModule droolsModule = droolsLayer.getModule("org.drools:1.0");
        Assert.assertTrue((droolsModule.getDependencies().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testScanLayerForceExports() throws Exception {
        this.initDroolsStaticModulePom(MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_XML_FORCE_EXPORTS);
        String layerName = "droolsLayer";
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.droolsStaticModulePom);
        this.tested.setScanStaticDependencies(true);
        this.tested.setScanResources(true);
        this.tested.setArtifactTreeResolved(true);
        this.tested.setBaseModulesLayer(this.baseModuleLayer);
        EAPModule javaxApiModule = (EAPModule)Mockito.mock(EAPModule.class);
        this.initMockModule(javaxApiModule, "javax.api", "main", null);
        Mockito.when((Object)this.baseModuleLayer.getModule("javax.api:main")).thenReturn((Object)javaxApiModule);
        this.addArtifactIntoHolder(this.droolsTemplatesDependency);
        this.addArtifactIntoHolder(this.droolsDecisionTablesDependency);
        EAPLayer droolsLayer = this.tested.scan(layerName, moduleArtifacts, null, this.artifactsHolder);
        EAPModule droolsModule = droolsLayer.getModule("org.drools:1.0");
        Assert.assertNotNull((Object)droolsModule);
        Assert.assertNotNull((Object)droolsModule.getDependencies());
        Assert.assertTrue((droolsModule.getDependencies().size() == 2 ? 1 : 0) != 0);
        EAPModuleDependency hibernateDependency = droolsModule.getDependency("org.hibernate");
        EAPModuleDependency javaxApiDependency = droolsModule.getDependency("javax.api");
        Assert.assertNotNull((Object)hibernateDependency);
        Assert.assertTrue((boolean)(hibernateDependency instanceof EAPStaticModuleDependency));
        Assert.assertEquals((Object)hibernateDependency.getName(), (Object)"org.hibernate");
        Assert.assertEquals((Object)hibernateDependency.getSlot(), (Object)"main");
        Assert.assertTrue((!hibernateDependency.isExport() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)javaxApiDependency);
        Assert.assertTrue((boolean)(javaxApiDependency instanceof EAPStaticModuleDependency));
        Assert.assertEquals((Object)javaxApiDependency.getName(), (Object)"javax.api");
        Assert.assertEquals((Object)javaxApiDependency.getSlot(), (Object)"main");
        Assert.assertTrue((javaxApiDependency.isExport() ? 1 : 0) != 0);
    }

    @Test
    public void testScanLayerNoModuleName() throws Exception {
        this.testScanLayerModuleException(MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_NOMODULENAME_XML, EAPModuleDefinitionException.class);
    }

    @Test
    public void testScanLayerNoModuleSlot() throws Exception {
        this.testScanLayerModuleException(MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_NOMODULENSLOT_XML, EAPModuleDefinitionException.class);
    }

    @Test
    public void testScanLayerModuleNoModuleLocation() throws Exception {
        this.testScanLayerModuleException(MODULES_STATIC_ORG_DROOLS_STATIC_MODULE_POM_NOMODULENLOCATION_XML, EAPModuleDefinitionException.class);
    }

    protected void testScanLayerModuleException(String pomUri, Class theExceptionClazz) throws Exception {
        this.initDroolsStaticModulePom(pomUri);
        String layerName = "droolsLayer";
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.droolsStaticModulePom);
        this.tested.setScanStaticDependencies(true);
        this.tested.setScanResources(true);
        this.tested.setArtifactTreeResolved(false);
        Exception result = null;
        try {
            EAPLayer droolsLayer = this.tested.scan(layerName, moduleArtifacts, null, this.artifactsHolder);
        }
        catch (Exception e) {
            result = e;
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(result.getClass(), (Object)theExceptionClazz);
    }

    protected void assertDroolsLayer(EAPLayer layer, String layerName, boolean assertResources, Class resourcesClazz, boolean assertStaticDependencies) {
        Assert.assertEquals((Object)layerName, (Object)layer.getName());
        EAPModule droolsModule = layer.getModule("org.drools:1.0");
        Assert.assertNotNull((Object)droolsModule);
        Assert.assertEquals((Object)droolsModule.getName(), (Object)"org.drools");
        Assert.assertEquals((Object)droolsModule.getLocation(), (Object)"org/drools");
        Assert.assertEquals((Object)droolsModule.getSlot(), (Object)"1.0");
        Assert.assertEquals((Object)droolsModule.getUniqueId(), (Object)"org.drools:1.0");
        Assert.assertEquals((Object)droolsModule.getArtifact(), (Object)this.droolsStaticModulePom);
        Assert.assertEquals((Object)droolsModule.getLayer(), (Object)layer);
        if (assertResources) {
            Assert.assertNotNull((Object)droolsModule.getResources());
            Assert.assertTrue((droolsModule.getResources().size() == 2 ? 1 : 0) != 0);
            Collection resources = droolsModule.getResources();
            for (EAPModuleResource resource : resources) {
                Assert.assertEquals(resource.getClass(), (Object)resourcesClazz);
            }
        }
        if (assertStaticDependencies) {
            Assert.assertNotNull((Object)droolsModule.getDependencies());
            Assert.assertTrue((droolsModule.getDependencies().size() > 0 ? 1 : 0) != 0);
            EAPModuleDependency hibernateDependency = droolsModule.getDependency("org.hibernate");
            Assert.assertNotNull((Object)hibernateDependency);
            Assert.assertTrue((boolean)(hibernateDependency instanceof EAPStaticModuleDependency));
            Assert.assertEquals((Object)hibernateDependency.getName(), (Object)"org.hibernate");
            Assert.assertEquals((Object)hibernateDependency.getSlot(), (Object)"main");
        }
    }

    @After
    public void tearDown() throws Exception {
    }
}

