/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.util;

import java.util.Properties;
import org.apache.maven.model.Model;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.integration.eap.maven.EAPBaseTest;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.sonatype.aether.artifact.Artifact;

public class EAPArtifactUtilsTest
extends EAPBaseTest {
    @Mock
    private EAPArtifactUtils tested;
    @Mock
    private Artifact artifact1;
    @Mock
    private Artifact artifact2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.tested = new EAPArtifactUtils();
    }

    @Test
    public void testCreateArtifact() throws Exception {
        Artifact result = EAPArtifactUtils.createArtifact((String)"org.kie", (String)"artifact", (String)"1.0", (String)"jar");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getGroupId(), (Object)"org.kie");
        Assert.assertEquals((Object)result.getArtifactId(), (Object)"artifact");
        Assert.assertEquals((Object)result.getVersion(), (Object)"1.0");
        Assert.assertEquals((Object)result.getExtension(), (Object)"jar");
        result = EAPArtifactUtils.createArtifact((String)"org.kie", (String)"artifact", (String)"1.0", (String)"jar", (String)"eap");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getGroupId(), (Object)"org.kie");
        Assert.assertEquals((Object)result.getArtifactId(), (Object)"artifact");
        Assert.assertEquals((Object)result.getVersion(), (Object)"1.0");
        Assert.assertEquals((Object)result.getExtension(), (Object)"jar");
        Assert.assertEquals((Object)result.getClassifier(), (Object)"eap");
    }

    @Test
    public void testEuals() throws Exception {
        this.initMockArtifact(this.artifact1, "org.kie", "artifact", "1.0", "jar", null);
        this.initMockArtifact(this.artifact2, "org.kie", "artifact", "1.0", "jar", null);
        boolean areEquals = EAPArtifactUtils.equals((Artifact)this.artifact1, (Artifact)this.artifact2);
        Assert.assertTrue((boolean)areEquals);
        this.initMockArtifact(this.artifact2, "org.kie", "artifact", "1.1", "jar", null);
        areEquals = EAPArtifactUtils.equals((Artifact)this.artifact1, (Artifact)this.artifact2);
        Assert.assertTrue((!areEquals ? 1 : 0) != 0);
    }

    @Test
    public void testArtifactCoordinates() throws Exception {
        String[] result = EAPArtifactUtils.extractArtifactCorrdinates((String)"org.kie:artifact:1.0:jar");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.length == 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)result[0], (Object)"org.kie");
        Assert.assertEquals((Object)result[1], (Object)"artifact");
        Assert.assertEquals((Object)result[2], (Object)"1.0");
        Assert.assertEquals((Object)result[3], (Object)"jar");
        this.initMockArtifact(this.artifact1, "org.kie", "artifact", "1.0", "jar", null);
        String coords = EAPArtifactUtils.getArtifactCoordinates((Artifact)this.artifact1);
        Assert.assertNotNull((Object)coords);
        Assert.assertEquals((Object)coords, (Object)"org.kie:artifact:jar:1.0");
        org.apache.maven.artifact.Artifact mavenArtifact = (org.apache.maven.artifact.Artifact)Mockito.mock(org.apache.maven.artifact.Artifact.class);
        Mockito.when((Object)mavenArtifact.getGroupId()).thenReturn((Object)"org.kie");
        Mockito.when((Object)mavenArtifact.getArtifactId()).thenReturn((Object)"artifact");
        Mockito.when((Object)mavenArtifact.getVersion()).thenReturn((Object)"1.0");
        Mockito.when((Object)mavenArtifact.getType()).thenReturn((Object)"jar");
        Mockito.when((Object)mavenArtifact.getClassifier()).thenReturn((Object)"eap");
        coords = EAPArtifactUtils.getArtifactCoordinates((org.apache.maven.artifact.Artifact)mavenArtifact);
        Assert.assertNotNull((Object)coords);
        Assert.assertEquals((Object)coords, (Object)"org.kie:artifact:jar:eap:1.0");
    }

    @Test
    public void testArtifactSnapshotVersions() throws Exception {
        this.initMockArtifact(this.artifact1, "org.kie", "artifact", "1.0-20140215", "jar", null);
        String version = EAPArtifactUtils.toSnaphostVersion((Artifact)this.artifact1);
        Assert.assertNotNull((Object)version);
        Assert.assertEquals((Object)version, (Object)"1.0-20140215");
        Mockito.when((Object)this.artifact1.getBaseVersion()).thenReturn((Object)"1.0-SNAPSHOT");
        version = EAPArtifactUtils.toSnaphostVersion((Artifact)this.artifact1);
        Assert.assertEquals((Object)version, (Object)"1.0-SNAPSHOT");
        org.apache.maven.artifact.Artifact mavenArtifact = (org.apache.maven.artifact.Artifact)Mockito.mock(org.apache.maven.artifact.Artifact.class);
        Mockito.when((Object)mavenArtifact.getVersion()).thenReturn((Object)"1.0-20140215");
        Mockito.when((Object)mavenArtifact.getBaseVersion()).thenReturn((Object)"1.0-SNAPSHOT");
        version = EAPArtifactUtils.toSnaphostVersion((org.apache.maven.artifact.Artifact)mavenArtifact);
        Assert.assertEquals((Object)version, (Object)"1.0-SNAPSHOT");
        Mockito.when((Object)mavenArtifact.getBaseVersion()).thenReturn(null);
        version = EAPArtifactUtils.toSnaphostVersion((org.apache.maven.artifact.Artifact)mavenArtifact);
        Assert.assertEquals((Object)version, (Object)"1.0-20140215");
    }

    @Test
    public void testMavenModelPropertyValueParser() throws Exception {
        Model mavenModel = (Model)Mockito.mock(Model.class);
        Properties modeProperties = new Properties();
        modeProperties.put("project.name", "eap-modules");
        Mockito.when((Object)mavenModel.getProperties()).thenReturn((Object)modeProperties);
        String result = EAPArtifactUtils.getPropertyValue((Model)mavenModel, (String)"org-kie-${project.name}");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)"org-kie-eap-modules");
    }

    @Test
    public void testMavenModelPropertyValueCustomPropsParser() throws Exception {
        Model mavenModel = (Model)Mockito.mock(Model.class);
        Properties modeProperties = new Properties();
        modeProperties.put("drools.name", "${project.name}");
        modeProperties.put("project.name", "drools");
        Mockito.when((Object)mavenModel.getProperties()).thenReturn((Object)modeProperties);
        String result = EAPArtifactUtils.getPropertyValue((Model)mavenModel, (String)"org-kie:${drools.name}");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)"org-kie:drools");
    }

    @Test
    public void testParseFileName() throws Exception {
        String[] result = EAPArtifactUtils.parseFileName((String)"slf4j-jboss-logmanager-1.0.2.GA-redhat-1.jar");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result[0], (Object)"slf4j-jboss-logmanager");
        Assert.assertEquals((Object)result[1], (Object)"1.0.2.GA-redhat-1");
    }

    @After
    public void tearDown() throws Exception {
    }
}

