/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.model.module;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.sonatype.aether.artifact.Artifact;

public abstract class EAPAbstractModule
implements EAPModule {
    private String name;
    private String location;
    private String slot;
    private EAPLayer layer;
    private Artifact artifact;
    private Set<EAPModuleResource> resources;
    private Set<EAPModuleDependency> dependencies;

    protected EAPAbstractModule(String name, String slot) {
        this.name = name;
        this.slot = slot;
        this.resources = new HashSet<EAPModuleResource>();
        this.dependencies = new HashSet<EAPModuleDependency>();
    }

    protected EAPAbstractModule(String name, String location, String slot) {
        this.name = name;
        this.location = location;
        this.slot = slot;
        this.resources = new HashSet<EAPModuleResource>();
        this.dependencies = new HashSet<EAPModuleDependency>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getSlot() {
        if (this.slot == null || this.slot.trim().length() == 0) {
            return "main";
        }
        return this.slot;
    }

    @Override
    public Collection<EAPModuleResource> getResources() {
        return this.resources;
    }

    @Override
    public boolean addResource(EAPModuleResource resource) {
        return this.resources.add(resource);
    }

    @Override
    public Collection<EAPModuleDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public EAPLayer getLayer() {
        return this.layer;
    }

    public void setLayer(EAPLayer layer) {
        this.layer = layer;
    }

    @Override
    public EAPModuleDependency getDependency(String name) {
        if (name != null) {
            for (EAPModuleDependency dep : this.dependencies) {
                if (!name.equals(dep.getName())) continue;
                return dep;
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            EAPModule mod = (EAPModule)obj;
            return mod.getName().equals(this.getName());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean addDependency(EAPModuleDependency dependency) {
        return this.dependencies.add(dependency);
    }

    public String toString() {
        return this.getUniqueId();
    }

    @Override
    public String getUniqueId() {
        return this.name + ":" + this.getSlot();
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }
}

