/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.template;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.generic.SortTool;
import org.codehaus.plexus.component.annotations.Component;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeDependency;
import org.kie.integration.eap.maven.model.graph.EAPModulesGraph;
import org.kie.integration.eap.maven.template.EAPTemplateBuilder;

@Component(role=EAPTemplateBuilder.class, hint="velocity")
public class EAPVelocityTemplateBuilder
implements EAPTemplateBuilder {
    private static final String TEMPLATES_STATIC_PATH = "/org/kie/integration/eap/maven/assembly/templates/static/";
    private static final String TEMPLATES_DYNAMIC_PATH = "/org/kie/integration/eap/maven/assembly/templates/dynamic/";
    private static final String TEMPLATES_BASE_PATH = "/org/kie/integration/eap/base/";
    private static final String TEMPLATE_BASIC_POM = "pom.vm";
    private static final String TEMPLATE_MODULE_DESCRIPTOR = "module.vm";
    private static final String TEMPLATE_LAYERS_DESCRIPTOR = "layers.vm";
    private static final String TEMPLATE_ASSEMBLY_COMPONENT = "assembly-component.vm";
    private static final String TEMPLATE_ASSEMBLY = "assembly.vm";
    private static final String TEMPLATE_JBOSS_DEP_STRUCTURE = "jboss-deployment-structure.vm";
    private static final String TEMPLATE_JBOSS_ALL = "jboss-all.vm";
    private static final String VM_CONTEXT_NODE = "node";
    private static final String VM_CONTEXT_MODULE_PATH = "moduleDescriptorPath";
    private static final String VM_CONTEXT_OUTPUT_PATH = "outputDir";
    private static final String VM_CONTEXT_LAYER_NAME = "layerName";
    private static final String VM_DEPENDENCIES = "dependencies";
    private static final String VM_CONTEXT_LAYER_ID = "layerId";
    private static final String VM_CONTEXT_LAYER_FORMATS = "formats";
    private static final String VM_CONTEXT_LAYER_DESC_FILE = "layersDescriptorFile";
    private static final String VM_CONTEXT_LAYER_COMPONENTS = "components";
    private static final String VM_CONTEXT_INCLUDE = "include";
    private static final String VM_CONTEXT_EXCLUSIONS = "exclusions";
    private static final String VM_CONTEXT_FILES = "files";
    private static final String VM_CONTEXT_ARTIFACT_ID = "artifactId";
    private static final String VM_CONTEXT_GROUP_ID = "groupId";
    private static final String VM_CONTEXT_VERSION = "version";
    private static final String VM_CONTEXT_PACKAGING = "packaging";
    private static final String VM_CONTEXT_NAME = "name";
    private static final String VM_CONTEXT_MODULES = "modules";
    private static final String VM_CONTEXT_PARENT = "parent";
    private static final String VM_CONTEXT_PROPERTIES = "properties";
    private static VelocityEngine velocityEngine = new VelocityEngine();
    private static Template moduleDescriptorTemplate;
    private static Template layersDescriptorTemplate;
    private static Template assemblyComponentTemplate;
    private static Template assemblyTemplate;
    private static Template jBossDepStructureTemplate;
    private static Template assemblyDynamicTemplate;
    private static Template jbossAllTemplate;

    @Override
    public String buildLayersConfiguration(EAPModulesGraph graph) {
        VelocityContext context = EAPVelocityTemplateBuilder.createContext();
        StringWriter writer = new StringWriter();
        context.put(VM_CONTEXT_LAYER_NAME, (Object)graph.getDistributionName());
        layersDescriptorTemplate.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    @Override
    public String buildGlobalAssembly(String layerId, String[] formats, String layerDescriptorFilePath, String[] componentDescriptorsFilePaths) {
        VelocityContext context = EAPVelocityTemplateBuilder.createContext();
        StringWriter writer = new StringWriter();
        context.put(VM_CONTEXT_LAYER_ID, (Object)layerId);
        context.put(VM_CONTEXT_LAYER_FORMATS, (Object)formats);
        context.put(VM_CONTEXT_LAYER_DESC_FILE, (Object)layerDescriptorFilePath);
        context.put(VM_CONTEXT_LAYER_COMPONENTS, (Object)componentDescriptorsFilePaths);
        assemblyTemplate.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    @Override
    public String buildModuleAssemblyComponent(EAPModuleGraphNode node, String moduleDescriptorPath, String outputPath) {
        VelocityContext context = this.createContext(node);
        StringWriter writer = new StringWriter();
        context.put(VM_CONTEXT_OUTPUT_PATH, (Object)outputPath);
        context.put(VM_CONTEXT_MODULE_PATH, (Object)moduleDescriptorPath);
        assemblyComponentTemplate.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    @Override
    public String buildModuleDescriptor(EAPModuleGraphNode node) {
        VelocityContext context = this.createContext(node);
        StringWriter writer = new StringWriter();
        moduleDescriptorTemplate.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    @Override
    public String buildJbossDeploymentStructure(Collection<? extends EAPModuleGraphNodeDependency> dependencies) {
        VelocityContext context = EAPVelocityTemplateBuilder.createContext();
        StringWriter writer = new StringWriter();
        context.put(VM_DEPENDENCIES, dependencies);
        jBossDepStructureTemplate.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    @Override
    public String buildDynamicModuleAssembly(String id, String[] formats, String include, Collection<String> exclusions, Collection<EAPTemplateBuilder.EAPAssemblyTemplateFile> files) {
        VelocityContext context = EAPVelocityTemplateBuilder.createContext();
        StringWriter writer = new StringWriter();
        context.put(VM_CONTEXT_LAYER_ID, (Object)id);
        context.put(VM_CONTEXT_LAYER_FORMATS, (Object)formats);
        context.put(VM_CONTEXT_INCLUDE, (Object)include);
        context.put(VM_CONTEXT_EXCLUSIONS, exclusions);
        context.put(VM_CONTEXT_FILES, files);
        assemblyDynamicTemplate.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    @Override
    public String buildDynamicModuleDependency(String name) {
        VelocityContext context = EAPVelocityTemplateBuilder.createContext();
        StringWriter writer = new StringWriter();
        context.put(VM_CONTEXT_NAME, (Object)name);
        jbossAllTemplate.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    public static String buildBasicPom(String groupId, String artifactId, String version, String packaging, String name, Collection<EAPBaseDependency> dependencies, Collection<String> modules, EAPParent parent, Map<String, String> properties) {
        VelocityContext context = EAPVelocityTemplateBuilder.createContext();
        StringWriter writer = new StringWriter();
        context.put(VM_CONTEXT_ARTIFACT_ID, (Object)artifactId);
        context.put(VM_CONTEXT_VERSION, (Object)version);
        context.put(VM_CONTEXT_GROUP_ID, (Object)groupId);
        context.put(VM_CONTEXT_PACKAGING, (Object)packaging);
        context.put(VM_CONTEXT_NAME, (Object)name);
        context.put(VM_CONTEXT_PARENT, (Object)parent);
        if (dependencies != null) {
            context.put(VM_DEPENDENCIES, dependencies);
        } else {
            context.put(VM_DEPENDENCIES, Collections.emptyList());
        }
        if (modules != null) {
            context.put(VM_CONTEXT_MODULES, modules);
        } else {
            context.put(VM_CONTEXT_MODULES, Collections.emptyList());
        }
        if (properties != null) {
            context.put(VM_CONTEXT_PROPERTIES, properties);
        } else {
            context.put(VM_CONTEXT_PROPERTIES, Collections.emptyMap());
        }
        Template tempalte = velocityEngine.getTemplate(TEMPLATES_BASE_PATH + TEMPLATE_BASIC_POM);
        tempalte.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    private static void init(VelocityEngine velocityEngine) {
        velocityEngine.setProperty("resource.loader", (Object)"classpath");
        velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.init();
    }

    private static void initTemplates() {
        if (moduleDescriptorTemplate == null) {
            moduleDescriptorTemplate = EAPVelocityTemplateBuilder.getTemplate(TEMPLATE_MODULE_DESCRIPTOR, TEMPLATES_STATIC_PATH);
        }
        if (layersDescriptorTemplate == null) {
            layersDescriptorTemplate = EAPVelocityTemplateBuilder.getTemplate(TEMPLATE_LAYERS_DESCRIPTOR, TEMPLATES_STATIC_PATH);
        }
        if (assemblyComponentTemplate == null) {
            assemblyComponentTemplate = EAPVelocityTemplateBuilder.getTemplate(TEMPLATE_ASSEMBLY_COMPONENT, TEMPLATES_STATIC_PATH);
        }
        if (assemblyTemplate == null) {
            assemblyTemplate = EAPVelocityTemplateBuilder.getTemplate(TEMPLATE_ASSEMBLY, TEMPLATES_STATIC_PATH);
        }
        if (jBossDepStructureTemplate == null) {
            jBossDepStructureTemplate = EAPVelocityTemplateBuilder.getTemplate(TEMPLATE_JBOSS_DEP_STRUCTURE, TEMPLATES_DYNAMIC_PATH);
        }
        if (assemblyDynamicTemplate == null) {
            assemblyDynamicTemplate = EAPVelocityTemplateBuilder.getTemplate(TEMPLATE_ASSEMBLY, TEMPLATES_DYNAMIC_PATH);
        }
        if (jbossAllTemplate == null) {
            jbossAllTemplate = EAPVelocityTemplateBuilder.getTemplate(TEMPLATE_JBOSS_ALL, TEMPLATES_DYNAMIC_PATH);
        }
    }

    protected static Template getTemplate(String name, String path) {
        return velocityEngine.getTemplate(path + name);
    }

    protected VelocityContext createContext(EAPModuleGraphNode node) {
        VelocityContext context = EAPVelocityTemplateBuilder.createContext();
        context.put(VM_CONTEXT_NODE, (Object)node);
        return context;
    }

    protected static VelocityContext createContext() {
        VelocityContext context = new VelocityContext();
        context.put("sorter", (Object)new SortTool());
        return context;
    }

    static {
        EAPVelocityTemplateBuilder.init(velocityEngine);
        EAPVelocityTemplateBuilder.initTemplates();
    }

    public static class EAPParent {
        private String artifactId;
        private String groupId;
        private String version;

        public EAPParent(String artifactId, String groupId, String version) {
            this.artifactId = artifactId;
            this.groupId = groupId;
            this.version = version;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    public static class EAPBaseDependency {
        private String artifactId;
        private String groupId;
        private String version;
        private String type;
        private String scope;
        private String systemPath;

        public EAPBaseDependency(String artifactId, String groupId, String version, String type, String scope, String systemPath) {
            this.artifactId = artifactId;
            this.groupId = groupId;
            this.version = version;
            this.type = type;
            this.scope = scope;
            this.systemPath = systemPath;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public String getScope() {
            return this.scope;
        }

        public String getSystemPath() {
            return this.systemPath;
        }
    }
}

