/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.scanner;

import java.util.Collection;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.component.annotations.Component;
import org.kie.integration.eap.maven.exception.EAPModuleDefinitionException;
import org.kie.integration.eap.maven.exception.EAPModuleResourceDuplicationException;
import org.kie.integration.eap.maven.model.dependency.EAPStaticDistributionModuleDependency;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPBaseModule;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPArtifactResource;
import org.kie.integration.eap.maven.scanner.EAPModulesScanner;
import org.kie.integration.eap.maven.scanner.EAPStaticModulesScanner;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.resolution.ArtifactResolutionException;

@Component(role=EAPModulesScanner.class, hint="base")
public class EAPBaseModulesScanner
extends EAPStaticModulesScanner {
    protected EAPModule createModuleInstance(Artifact artifact, String moduleName, String moduleLocation, String moduleSlot) {
        EAPBaseModule m = new EAPBaseModule(moduleName, moduleSlot);
        m.setLayer(this.layer);
        m.setArtifact(artifact);
        return m;
    }

    @Override
    public String getModuleTypeSupported() {
        return "base";
    }

    @Override
    protected void checkModuleProperties(Properties moduleProperties, String moduleArtifactCoordinates) throws EAPModuleDefinitionException {
        String moduleName = (String)moduleProperties.get("module.name");
        String moduleType = (String)moduleProperties.get("module.type");
        String moduleSlot = (String)moduleProperties.get("module.slot");
        String moduleDependenciesRaw = (String)moduleProperties.get("module.dependencies");
        if (moduleName == null || moduleName.trim().length() == 0) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module name is not set.");
        }
        if (moduleType == null || moduleType.trim().length() == 0) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module type is not set.");
        }
        if (moduleSlot == null || moduleSlot.trim().length() == 0) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module slot is not set.");
        }
        if (!this.getModuleTypeSupported().equals(moduleType)) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module scanned is not supported by this scanner implementation '" + this.getClass().getName() + "' as it only supports type " + this.getModuleTypeSupported());
        }
    }

    protected void addStaticDependencies(EAPModule module, String moduleArtifactCoordinates, String moduleDependenciesRaw, Collection<Artifact> exclusions) throws EAPModuleDefinitionException {
    }

    @Override
    protected EAPArtifactResource addResource(EAPModule module, Model moduleModel, Dependency moduleDependency) throws ArtifactResolutionException, EAPModuleResourceDuplicationException {
        String depGroupId = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getGroupId());
        String depArtifactId = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getArtifactId());
        String depVersion = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getVersion());
        String depType = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getType());
        String depClassifier = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getClassifier());
        Artifact moduleResourceArtifact = EAPArtifactUtils.createArtifact(depGroupId, depArtifactId, depVersion, depType, depClassifier);
        EAPArtifactResource result = EAPArtifactResource.create(moduleResourceArtifact);
        this.artifactsHolder.add(moduleResourceArtifact, module);
        return result;
    }

    @Override
    public void setLogger(Log logger) {
        this.logger = logger;
    }

    @Override
    public void setBaseModulesLayer(EAPLayer baseModulesLayer) {
        throw new UnsupportedOperationException("Base modules scanner does not support the base layer setter");
    }

    @Override
    public boolean isScanStaticDependencies() {
        return false;
    }

    @Override
    public void setScanStaticDependencies(boolean scanStaticDependencies) {
        throw new UnsupportedOperationException("Base modules definitions does not support static dependencies.");
    }

    @Override
    public void setDistributionStaticDependencies(Collection<EAPStaticDistributionModuleDependency> dependencies) {
        throw new UnsupportedOperationException("Base modules definitions does not support static dependencies.");
    }
}

