/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kie.integration.eap.maven.exception.EAPModuleResourceDuplicationException;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResolutionException;

public class EAPArtifactsHolder {
    private Map<String, Object[]> artifactAllCoordinatesMap = new HashMap<String, Object[]>();
    private Map<String, String> artifactCoordinatesMapping = new HashMap<String, String>();
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> remoteRepos;

    public EAPArtifactsHolder(RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) {
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.remoteRepos = remoteRepos;
    }

    public void add(Artifact obj) {
        String allCoords = EAPArtifactUtils.getArtifactCoordinates(obj);
        Object[] value = new Object[]{null, obj};
        this.artifactAllCoordinatesMap.put(allCoords, value);
    }

    public void add(Artifact obj, EAPModule module) throws EAPModuleResourceDuplicationException {
        String allCoords = EAPArtifactUtils.getArtifactCoordinates(obj);
        Object[] allCordsObj = this.artifactAllCoordinatesMap.get(allCoords);
        if (allCordsObj != null && allCordsObj[0] != null && !module.getName().equals(((EAPModule)allCordsObj[0]).getName())) {
            throw new EAPModuleResourceDuplicationException("The artifact has been already added in module " + this.artifactAllCoordinatesMap.get(allCoords)[0], allCoords);
        }
        Object[] value = new Object[]{module, obj};
        this.artifactAllCoordinatesMap.put(allCoords, value);
        this.applyArtifactMapping(allCoords, module);
    }

    public void setModule(String artifactCoordinates, EAPModule module) throws EAPModuleResourceDuplicationException {
        Object[] obj = this.get(artifactCoordinates);
        if (obj[0] != null) {
            EAPModule m = (EAPModule)obj[0];
            if (!module.getName().equalsIgnoreCase(m.getName())) {
                throw new EAPModuleResourceDuplicationException("The artifact has been already added in module " + obj[0], artifactCoordinates);
            }
        }
        obj[0] = module;
        this.applyArtifactMapping(artifactCoordinates, module);
    }

    protected void applyArtifactMapping(String artifactCoordinates, EAPModule module) {
        String shortCoords = EAPArtifactUtils.getArtifactShortCoordinates(artifactCoordinates);
        for (Map.Entry<String, Object[]> entry : this.artifactAllCoordinatesMap.entrySet()) {
            String entryKey = entry.getKey();
            Object[] entryValue = entry.getValue();
            if (entryKey == null || !entryKey.startsWith(shortCoords) || entryKey.equalsIgnoreCase(artifactCoordinates)) continue;
            entryValue[0] = module;
            this.artifactCoordinatesMapping.put(module.getName(), artifactCoordinates);
        }
    }

    public void setModule(Artifact artifact, EAPModule module) throws EAPModuleResourceDuplicationException {
        this.setModule(EAPArtifactUtils.getArtifactCoordinates(artifact), module);
    }

    public Artifact getArtifact(String artifactCoordinates) {
        if (artifactCoordinates == null) {
            return null;
        }
        Object[] result = this.get(artifactCoordinates);
        if (result == null) {
            return null;
        }
        return (Artifact)result[1];
    }

    public EAPModule getModule(String artifactCoordinates) {
        if (artifactCoordinates == null) {
            return null;
        }
        Object[] result = this.get(artifactCoordinates);
        if (result == null) {
            return null;
        }
        return (EAPModule)result[0];
    }

    public Artifact getArtifact(Artifact artifact) {
        return this.getArtifact(EAPArtifactUtils.getArtifactCoordinates(artifact));
    }

    public EAPModule getModule(Artifact artifact) {
        return this.getModule(EAPArtifactUtils.getArtifactCoordinates(artifact));
    }

    public boolean contains(Artifact artifact) {
        return this.getArtifact(artifact) != null;
    }

    protected Object[] get(String artifactCoordinates) {
        if (artifactCoordinates == null) {
            return null;
        }
        Object[] result = this.artifactAllCoordinatesMap.get(artifactCoordinates);
        return result;
    }

    public Map<String, String> getMappedCoordinates() {
        return Collections.unmodifiableMap(this.artifactCoordinatesMapping);
    }

    public Artifact resolveArtifact(Artifact artifact) throws ArtifactResolutionException {
        return EAPArtifactUtils.resolveArtifact(artifact, this.repoSystem, this.repoSession, this.remoteRepos);
    }

    public Artifact resolveArtifact(String groupId, String artifactId, String version, String packaging) throws ArtifactResolutionException {
        return EAPArtifactUtils.resolveArtifact(groupId, artifactId, version, packaging, this.repoSystem, this.repoSession, this.remoteRepos);
    }

    public Collection<Artifact> getArtifacts() {
        LinkedList<Artifact> result = new LinkedList<Artifact>();
        for (Map.Entry<String, Object[]> entry : this.artifactAllCoordinatesMap.entrySet()) {
            Object[] entryValue = entry.getValue();
            Artifact artifact = (Artifact)entryValue[1];
            if (artifact == null) continue;
            result.add(artifact);
        }
        return result;
    }

    public Artifact contains(String groupId, String artifactId, String type) {
        if (artifactId == null || artifactId.trim().length() == 0 || type == null || type.trim().length() == 0 || groupId == null || groupId.trim().length() == 0) {
            return null;
        }
        for (Map.Entry<String, Object[]> entry : this.artifactAllCoordinatesMap.entrySet()) {
            Object[] entryValue = entry.getValue();
            Artifact artifact = (Artifact)entryValue[1];
            if (!groupId.equalsIgnoreCase(artifact.getGroupId()) || !artifactId.equalsIgnoreCase(artifact.getArtifactId()) || !type.equalsIgnoreCase(artifact.getExtension())) continue;
            return artifact;
        }
        return null;
    }
}

