/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.builder;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.integration.eap.maven.EAPStaticLayerTest;
import org.kie.integration.eap.maven.builder.EAPModulesFlatGraphBuilder;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeDependency;
import org.kie.integration.eap.maven.model.graph.EAPModulesGraph;

public class EAPModulesFlatGraphBuilderTest
extends EAPStaticLayerTest {
    private EAPModulesFlatGraphBuilder tested;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.tested = new EAPModulesFlatGraphBuilder();
    }

    @Test
    public void testBuildGraph() throws Exception {
        this.buildStaticLayerModuleDependencies();
        EAPModulesGraph result = this.tested.build("staticLayer", this.staticLayer);
        junit.framework.Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getDistributionName(), (Object)"staticLayer");
        junit.framework.Assert.assertNotNull((Object)result.getNodes());
        Assert.assertTrue((result.getNodes().size() == 2 ? 1 : 0) != 0);
        EAPModuleGraphNode droolsNode = (EAPModuleGraphNode)result.getNodes().get(0);
        junit.framework.Assert.assertNotNull((Object)droolsNode);
        Assert.assertEquals((Object)droolsNode.getName(), (Object)this.droolsModule.getName());
        Assert.assertEquals((Object)droolsNode.getSlot(), (Object)this.droolsModule.getSlot());
        Assert.assertEquals((Object)droolsNode.getUniqueId(), (Object)this.droolsModule.getUniqueId());
        junit.framework.Assert.assertNotNull((Object)droolsNode.getResources());
        Assert.assertTrue((droolsNode.getResources().size() == 2 ? 1 : 0) != 0);
        junit.framework.Assert.assertNotNull((Object)droolsNode.getDependencies());
        Assert.assertTrue((droolsNode.getDependencies().size() == 3 ? 1 : 0) != 0);
        EAPModuleGraphNodeDependency droolsJbpmDep1 = (EAPModuleGraphNodeDependency)droolsNode.getDependencies().get(0);
        EAPModuleGraphNodeDependency droolsHibernateDep = (EAPModuleGraphNodeDependency)droolsNode.getDependencies().get(1);
        EAPModuleGraphNodeDependency droolsJbpmDep2 = (EAPModuleGraphNodeDependency)droolsNode.getDependencies().get(2);
        this.assertGraphDependency(droolsJbpmDep1, "org.jbpm", "1.0", false);
        this.assertGraphDependency(droolsHibernateDep, "org.hibernate", "main", false);
        this.assertGraphDependency(droolsJbpmDep2, "org.jbpm", "1.0", false);
        EAPModuleGraphNode jbpmNode = (EAPModuleGraphNode)result.getNodes().get(1);
        junit.framework.Assert.assertNotNull((Object)jbpmNode);
        Assert.assertEquals((Object)jbpmNode.getName(), (Object)this.jbpmModule.getName());
        Assert.assertEquals((Object)jbpmNode.getSlot(), (Object)this.jbpmModule.getSlot());
        Assert.assertEquals((Object)jbpmNode.getUniqueId(), (Object)this.jbpmModule.getUniqueId());
        junit.framework.Assert.assertNotNull((Object)jbpmNode.getResources());
        Assert.assertTrue((jbpmNode.getResources().size() == 2 ? 1 : 0) != 0);
        junit.framework.Assert.assertNotNull((Object)jbpmNode.getDependencies());
        Assert.assertTrue((jbpmNode.getDependencies().size() == 4 ? 1 : 0) != 0);
        EAPModuleGraphNodeDependency jbpmHibernateDep1 = (EAPModuleGraphNodeDependency)jbpmNode.getDependencies().get(0);
        EAPModuleGraphNodeDependency jbpmDroolsDep1 = (EAPModuleGraphNodeDependency)jbpmNode.getDependencies().get(1);
        EAPModuleGraphNodeDependency jbpmDroolsDep2 = (EAPModuleGraphNodeDependency)jbpmNode.getDependencies().get(2);
        EAPModuleGraphNodeDependency jbpmHibernateDep2 = (EAPModuleGraphNodeDependency)jbpmNode.getDependencies().get(3);
        this.assertGraphDependency(jbpmHibernateDep1, "org.hibernate", "main", false);
        this.assertGraphDependency(jbpmDroolsDep1, "org.drools", "1.0", false);
        this.assertGraphDependency(jbpmDroolsDep2, "org.drools", "1.0", false);
        this.assertGraphDependency(jbpmHibernateDep2, "org.hibernate", "main", false);
    }

    protected void assertGraphDependency(EAPModuleGraphNodeDependency dependency, String name, String slot, boolean export) {
        junit.framework.Assert.assertNotNull((Object)dependency);
        Assert.assertEquals((Object)dependency.getName(), (Object)name);
        Assert.assertEquals((Object)dependency.getSlot(), (Object)slot);
        Assert.assertEquals((Object)dependency.isExport(), (Object)export);
    }

    @After
    public void tearDown() throws Exception {
    }
}

