/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.patch;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.integration.eap.maven.distribution.EAPStaticLayerDistribution;
import org.kie.integration.eap.maven.eap.EAPContainer;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.patch.EAPDynamicModulesPatch;
import org.kie.integration.eap.maven.patch.EAPPatch;
import org.kie.integration.eap.maven.patch.EAPPatchException;
import org.kie.integration.eap.maven.patch.EAPPatchManager;
import org.kie.integration.eap.maven.patch.EAPStaticModulesPatch;
import org.kie.integration.eap.maven.util.EAPArtifactsHolder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class EAPPatchManagerTest {
    private EAPPatchManager tested;
    private EAPStaticModulesPatch staticModulesPatch;
    private EAPDynamicModulesPatch dynamicModulesPatch;
    @Mock
    private EAPContainer container;
    @Mock
    private EAPArtifactsHolder artifactsHolder;
    @Mock
    private Collection<EAPModule> modules;
    @Mock
    private EAPStaticLayerDistribution staticLayerDistribution;
    @Mock
    private EAPLayer staticLayer;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.staticModulesPatch = new EAPStaticModulesPatch(){

            public String getId() {
                return "static";
            }

            public boolean doApply(EAPContainer eap) {
                return true;
            }

            public void execute(EAPModule module, Properties patchProperties) throws EAPPatchException {
            }
        };
        this.dynamicModulesPatch = new EAPDynamicModulesPatch(){

            public String getId() {
                return "dynamic";
            }

            public boolean doApply(EAPContainer eap) {
                return true;
            }

            public void execute(EAPModuleGraphNode node, Properties patchProperties) throws EAPPatchException {
            }
        };
        LinkedList<Object> patches = new LinkedList<Object>();
        patches.add(this.staticModulesPatch);
        patches.add(this.dynamicModulesPatch);
        Mockito.when((Object)this.container.getContainerId()).thenReturn((Object)EAPContainer.EAPContainerId.EAP);
        Mockito.when((Object)this.container.getVersion()).thenReturn((Object)new ComparableVersion("6.1.1"));
        this.tested = new EAPPatchManager();
        this.tested.setPatches(patches.toArray(new EAPPatch[patches.size()]));
    }

    @Test
    public void testInit1() throws Exception {
        Assert.assertNotNull((Object)this.tested.getStaticModulePatches());
        Assert.assertTrue((this.tested.getStaticModulePatches().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.tested.getDynamicModulePatches());
        Assert.assertTrue((this.tested.getDynamicModulePatches().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testInit2() throws Exception {
        String outputPath = "output-path-1";
        this.tested.initStatic(this.container, outputPath, this.artifactsHolder, this.staticLayer);
        this.tested.initDynamic(this.container, outputPath, this.artifactsHolder, this.staticLayerDistribution);
        EAPStaticModulesPatch resultStatic = (EAPStaticModulesPatch)this.tested.getStaticModulePatches().iterator().next();
        Assert.assertNotNull((Object)resultStatic);
        junit.framework.Assert.assertEquals((String)resultStatic.getOutputPath(), (String)outputPath);
        Assert.assertTrue((resultStatic.getArtifactsHolder() == this.artifactsHolder ? 1 : 0) != 0);
        Assert.assertTrue((resultStatic.getStaticLayer() == this.staticLayer ? 1 : 0) != 0);
        EAPDynamicModulesPatch resultDynamic = (EAPDynamicModulesPatch)this.tested.getDynamicModulePatches().iterator().next();
        Assert.assertNotNull((Object)resultDynamic);
        junit.framework.Assert.assertEquals((String)resultDynamic.getOutputPath(), (String)outputPath);
        Assert.assertTrue((resultDynamic.getArtifactsHolder() == this.artifactsHolder ? 1 : 0) != 0);
        Assert.assertTrue((resultDynamic.getStaticLayerDistribution() == this.staticLayerDistribution ? 1 : 0) != 0);
    }

    public void testExecute() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }
}

