/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven;

import java.util.ArrayList;
import org.junit.Before;
import org.kie.integration.eap.maven.EAPBaseTest;
import org.kie.integration.eap.maven.model.dependency.EAPBaseModuleDependency;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.sonatype.aether.artifact.Artifact;

public abstract class EAPBaseLayerTest
extends EAPBaseTest {
    protected static final String BASE_LAYER_NAME = "baseLayer";
    protected static final String BASE_LAYER_GROUP_ID = "org.kie";
    protected static final String HIBERNATE_MODULE_NAME = "org.hibernate";
    protected static final String HIBERNATE_MODULE_SLOT = "main";
    protected static final String HIBERNATE_GROUPID = "org.hibernate";
    protected static final String HIBERNATE_MODULE_POM = "org-hibernate-main";
    protected static final String HIBERNATE_CORE_ARTIFACTID = "hibernate-core";
    protected static final String HIBERNATE_CORE_RESOURCE_NAME = "org.hibernate:hibernate-core:jar";
    protected static final String MODULES_HIBERNATE_MODULE_POM_XML = "/modules/base/hibernate/pom.xml";
    @Mock
    protected EAPModule hibernateBaseModule;
    @Mock
    protected Artifact hibernateBaseModulePom;
    @Mock
    protected Artifact hibernateCoreDependency;
    @Mock
    protected EAPModuleResource hibernateCoreResource;
    @Mock
    protected EAPLayer baseModuleLayer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.initHibernateModule();
        ((EAPModule)Mockito.doReturn((Object)new EAPBaseModuleDependency(this.hibernateBaseModule.getName())).when((Object)this.hibernateBaseModule)).createDependency();
        ArrayList<EAPModule> modules = new ArrayList<EAPModule>(1);
        modules.add(this.hibernateBaseModule);
        this.initMockLayer(this.baseModuleLayer, BASE_LAYER_NAME, modules);
    }

    protected void initHibernateModule() throws Exception {
        this.initMockArtifact(this.hibernateBaseModulePom, BASE_LAYER_GROUP_ID, HIBERNATE_MODULE_POM, null, "pom", null, MODULES_HIBERNATE_MODULE_POM_XML);
        this.initMockArtifact(this.hibernateCoreDependency, "org.hibernate", HIBERNATE_CORE_ARTIFACTID, null, "jar", null);
        this.initMockModuleResource(this.hibernateCoreResource, HIBERNATE_CORE_RESOURCE_NAME, null, this.hibernateCoreDependency);
        ArrayList<EAPModuleResource> resources = new ArrayList<EAPModuleResource>(1);
        resources.add(this.hibernateCoreResource);
        this.initMockModule(this.hibernateBaseModule, "org.hibernate", HIBERNATE_MODULE_SLOT, this.hibernateBaseModulePom, resources);
        this.addArtifactIntoHolder(this.hibernateCoreDependency, this.hibernateBaseModule);
    }
}

