/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.eap;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.kie.integration.eap.maven.template.EAPVelocityTemplateBuilder;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.kie.integration.eap.maven.util.EAPFileUtils;
import org.kie.integration.eap.maven.util.EAPXMLUtils;
import org.sonatype.aether.artifact.Artifact;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EAPFileSystemBaseModulesScanner {
    private static final String TMP_PATH = System.getProperty("java.io.tmpdir");
    private static final String RESOURCE_GROUP_ID = "org.jboss.eap-module-base";
    private static final String MODULE_GROUP_ID = "org.kie";
    private static final String MODULE_ARTIFACT_ID_PREFFIX = "eap-module-";
    private static final String PACKAGING = "jar";
    private static final String POM_XML_NAME = "pom.xml";
    private static final String MODULE_XML_NAME = "module.xml";
    private static final String POM = "pom";
    private static final String SCOPE_SYSTEM = "system";
    private static final String MODULES_PATH = "modules" + File.separator + "system" + File.separator + "layers" + File.separator + "base";
    private static final String RESOURCES_PATH = "src" + File.separator + "main" + File.separator + "resources";
    private static final Pattern JAR_NAME_PARSER_PATTERN = Pattern.compile("(.*)-(\\d+[\\.-].*).jar");
    private static final String XPATH_POM_ARTIFACT_ID = "/project/artifactId";
    private static final String XPATH_POM_GROUP_ID = "/project/groupId";
    private static final String XPATH_POM_VERSION = "/project/version";
    private static final String XPATH_POM_PACKAGING = "/project/packaging";
    private static final String XPATH_POM_PARENT_GROUP_ID = "/project/parent/groupId";
    private static final String XPATH_POM_PARENT_VERSION = "/project/parent/version";
    private String eapRoot;
    private String eapName;
    private String outputPath;
    private String mavenModulesVersion;
    private String tempPath;
    private Log logger;

    public EAPFileSystemBaseModulesScanner(String eapRoot, String eapName, String mavenModulesVersion, String outputPath) {
        this.eapRoot = eapRoot;
        this.eapName = eapName;
        this.mavenModulesVersion = mavenModulesVersion;
        this.outputPath = outputPath;
    }

    public void generate() throws Exception {
        File tempRoot;
        File eapRoot;
        if (this.logger != null) {
            this.logger.info((CharSequence)"Starting the JBoss EAP/AS base modules generation process...");
        }
        if (!(eapRoot = new File(this.getEapRoot())).exists()) {
            throw new IllegalArgumentException("Root JBoss EAP/AS path " + eapRoot + " does not exists.");
        }
        if (this.eapName == null || this.eapName.trim().length() == 0) {
            throw new IllegalArgumentException("The name for the EAP distribution (eapName property) cannot be null or empty.");
        }
        if (this.mavenModulesVersion == null || this.mavenModulesVersion.trim().length() == 0) {
            throw new IllegalArgumentException("The version for the EAP distribution (mavenModulesVersion property) cannot be null or empty.");
        }
        File eapModulesRoot = new File(eapRoot, MODULES_PATH);
        if (!eapModulesRoot.exists()) {
            throw new RuntimeException("Jboss EAP base modules root path " + eapModulesRoot + " not found.");
        }
        File outputRoot = new File(this.outputPath);
        if (!outputRoot.exists()) {
            throw new IllegalArgumentException("Output root path " + outputRoot + " does not exists.");
        }
        outputRoot = new File(this.outputPath, this.eapName);
        if (this.tempPath != null && this.tempPath.trim().length() > 0 && !(tempRoot = new File(this.tempPath)).exists()) {
            throw new IllegalArgumentException("Temp root path " + tempRoot + " does not exists.");
        }
        ArrayList<EAPBaseModule> modules = new ArrayList<EAPBaseModule>();
        this.scan(eapModulesRoot, modules);
        this.resolveAliases(modules);
        if (modules != null) {
            ArrayList<String> moduleNames = new ArrayList<String>();
            if (this.logger != null) {
                this.logger.info((CharSequence)("Total base modules scanned: " + modules.size()));
            }
            for (EAPBaseModule module : modules) {
                this.createModuleDescriptor(module, outputRoot);
                String moduleRootName = module.getMavenModuleName();
                moduleNames.add(moduleRootName);
            }
            String modulesPomFileContent = EAPVelocityTemplateBuilder.buildBasicPom(MODULE_GROUP_ID, MODULE_ARTIFACT_ID_PREFFIX + this.eapName, this.mavenModulesVersion, POM, "KIE EAP - " + this.eapName + " base modules", null, moduleNames, null, null);
            File modulesPomFile = new File(outputRoot, POM_XML_NAME);
            EAPFileUtils.writeToFile(modulesPomFileContent, modulesPomFile);
        }
        if (this.logger != null) {
            this.logger.info((CharSequence)"Generation process finished successfully.");
        }
    }

    private void createModuleDescriptor(EAPBaseModule module, File outputRoot) throws IOException {
        if (this.logger != null) {
            this.logger.info((CharSequence)("Creating maven module for module " + module));
        }
        String moduleRootName = module.getMavenModuleName();
        File moduleRoot = new File(outputRoot, moduleRootName);
        moduleRoot.mkdirs();
        HashMap resources = module.getResources();
        ArrayList<EAPVelocityTemplateBuilder.EAPBaseDependency> dependencies = null;
        if (resources != null && !resources.isEmpty()) {
            dependencies = new ArrayList<EAPVelocityTemplateBuilder.EAPBaseDependency>();
            File resourcesPomRoot = new File(moduleRoot, RESOURCES_PATH);
            resourcesPomRoot.mkdirs();
            for (Map.Entry entry : resources.entrySet()) {
                Artifact artifact = (Artifact)entry.getKey();
                File resourcePomTempFile = (File)entry.getValue();
                String pomFileName = resourcePomTempFile.getName();
                File resourcesPom = new File(resourcesPomRoot, pomFileName);
                EAPFileUtils.writeToFile((InputStream)new BufferedInputStream(new FileInputStream(resourcePomTempFile)), resourcesPom);
                EAPVelocityTemplateBuilder.EAPBaseDependency dependency = new EAPVelocityTemplateBuilder.EAPBaseDependency(artifact.getArtifactId(), artifact.getGroupId(), artifact.getVersion(), POM, SCOPE_SYSTEM, pomFileName);
                dependencies.add(dependency);
            }
        }
        File modulePom = new File(moduleRoot, POM_XML_NAME);
        HashMap<String, String> moduleProperties = new HashMap<String, String>(4);
        moduleProperties.put("module.name", module.getName());
        moduleProperties.put("module.slot", module.getSlot());
        moduleProperties.put("module.type", "base");
        String modulePomContent = EAPVelocityTemplateBuilder.buildBasicPom(MODULE_GROUP_ID, MODULE_ARTIFACT_ID_PREFFIX + moduleRootName, this.mavenModulesVersion, POM, "EAP Base Module " + module, dependencies, null, new EAPVelocityTemplateBuilder.EAPParent(MODULE_ARTIFACT_ID_PREFFIX + this.eapName, MODULE_GROUP_ID, this.mavenModulesVersion), moduleProperties);
        EAPFileUtils.writeToFile(modulePomContent, modulePom);
        if (this.logger != null) {
            this.logger.info((CharSequence)("Maven module for module " + module + " created successfully."));
        }
    }

    private void resolveAliases(Collection<EAPBaseModule> modules) {
        if (modules != null) {
            for (EAPBaseModule module : modules) {
                EAPBaseModule m;
                String moduleNameAlias = module.getModuleNameAlias();
                String moduleSlotAlias = module.getModuleSlotAlias();
                if (moduleNameAlias == null || moduleNameAlias.trim().length() <= 0) continue;
                if (this.logger != null) {
                    this.logger.info((CharSequence)("Aliasing module '" + module.getName() + "' with '" + moduleNameAlias + ":" + moduleSlotAlias + "'."));
                }
                if ((m = this.getModule(modules, moduleNameAlias, moduleSlotAlias)) == null) {
                    throw new RuntimeException("Module alias not found.");
                }
                module.update(m);
            }
        }
    }

    private EAPBaseModule getModule(Collection<EAPBaseModule> modules, String name, String slot) {
        if (modules != null) {
            for (EAPBaseModule module : modules) {
                if (!name.equalsIgnoreCase(module.getName()) || !slot.equalsIgnoreCase(module.getSlot())) continue;
                return module;
            }
        }
        return null;
    }

    private void scan(File directory, Collection<EAPBaseModule> result) throws Exception {
        for (File child : directory.listFiles()) {
            if (child.isDirectory()) {
                this.scan(child, result);
                continue;
            }
            if (!child.isFile() || !child.getName().equalsIgnoreCase(MODULE_XML_NAME)) continue;
            EAPBaseModule m = this.scanModule(directory, child);
            result.add(m);
        }
    }

    private EAPBaseModule scanModule(File directory, File moduleXML) throws Exception {
        if (this.logger != null) {
            this.logger.info((CharSequence)("Scanning module descrtpor '" + moduleXML + "'..."));
        }
        EAPBaseModule result = null;
        EAPXMLUtils xmlUtils = new EAPXMLUtils(new FileInputStream(moduleXML));
        Document root = xmlUtils.getDocument();
        if (root != null) {
            result = new EAPBaseModule();
            String moduleName = null;
            String moduleSlot = null;
            NodeList moduleNodes = root.getElementsByTagName("module");
            if (moduleNodes != null && moduleNodes.getLength() > 0) {
                Node moduleNode = moduleNodes.item(0);
                moduleName = EAPXMLUtils.getAttributeValue(moduleNode, "name");
                moduleSlot = EAPXMLUtils.getAttributeValue(moduleNode, "slot");
                result.setName(moduleName);
                result.setSlot(moduleSlot);
                if (this.logger != null) {
                    this.logger.debug((CharSequence)("Module name: '" + moduleName + "'"));
                }
                if (this.logger != null) {
                    this.logger.debug((CharSequence)("Module slot: '" + moduleSlot + "'"));
                }
            } else {
                NodeList moduleAliasNodes = root.getElementsByTagName("module-alias");
                if (moduleAliasNodes != null && moduleAliasNodes.getLength() > 0) {
                    Node moduleNode = moduleAliasNodes.item(0);
                    moduleName = EAPXMLUtils.getAttributeValue(moduleNode, "name");
                    moduleSlot = EAPXMLUtils.getAttributeValue(moduleNode, "slot");
                    String moduleAliasModule = EAPXMLUtils.getAttributeValue(moduleNode, "target-name");
                    String moduleAliasSlot = EAPXMLUtils.getAttributeValue(moduleNode, "target-slot");
                    result.setName(moduleName);
                    result.setSlot(moduleSlot);
                    result.setModuleNameAlias(moduleAliasModule);
                    result.setModuleSlotAlias(moduleAliasSlot);
                } else {
                    throw new RuntimeException("Module name/slot or aliases nor found for file " + moduleXML.getAbsolutePath());
                }
            }
            NodeList resourcesNode = root.getElementsByTagName("resource-root");
            if (resourcesNode != null && resourcesNode.getLength() > 0) {
                for (int i = 0; i < resourcesNode.getLength(); ++i) {
                    File file;
                    Node node = resourcesNode.item(i);
                    String resourceName = EAPXMLUtils.getAttributeValue(node, "path");
                    if (this.logger != null) {
                        this.logger.debug((CharSequence)("Found resource: '" + resourceName + "'"));
                    }
                    if (!(file = new File(directory, resourceName)).isFile() || !resourceName.endsWith(PACKAGING)) continue;
                    this.scanModuleResource(result, directory, resourceName);
                }
            }
        }
        if (this.logger != null) {
            this.logger.info((CharSequence)("Scanning module descrtpor '" + moduleXML + "' complete."));
        }
        return result;
    }

    private EAPBaseModule scanModuleResource(EAPBaseModule module, File directory, String name) throws Exception {
        if (this.logger != null) {
            this.logger.info((CharSequence)("Scanning resource: '" + name + "'..."));
        }
        Artifact artifact = null;
        File pomFile = null;
        String tmpPomFileName = this.getTempPath() + File.separator + name + "-pom.xml";
        File file = new File(directory, name);
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> e = jarFile.entries();
        boolean pomFound = false;
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().endsWith(POM_XML_NAME)) continue;
            InputStream is = jarFile.getInputStream(entry);
            pomFound = true;
            EAPFileUtils.writeToFile(is, tmpPomFileName);
            pomFile = new File(tmpPomFileName);
            EAPFileUtils.removeFirstLineIfDuplicated(pomFile);
            try {
                artifact = this.scanPomCoordinates(pomFile);
            }
            catch (Exception e1) {
                if (this.logger != null) {
                    this.logger.warn((CharSequence)("The resource pom.xml file for resource '" + name + "' and module '" + module + "' cannot be parsed. The artifact coordinates for this resource will be extracted from jar name. Please review the generated pom.xml."));
                }
                pomFound = false;
                pomFile.delete();
            }
        }
        if (!pomFound) {
            artifact = this.scanJarNameCoordinates(RESOURCE_GROUP_ID, PACKAGING, name);
            String pomFileString = EAPVelocityTemplateBuilder.buildBasicPom(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getExtension(), "EAP Base Module " + module, null, null, null, null);
            EAPFileUtils.writeToFile(pomFileString, tmpPomFileName);
            pomFile = new File(tmpPomFileName);
        }
        module.getResources().put(artifact, pomFile);
        if (this.logger != null) {
            this.logger.info((CharSequence)("Scanning resource: '" + name + "' completed."));
        }
        return module;
    }

    private Artifact scanPomCoordinates(File pomFile) throws Exception {
        String version;
        String groupId;
        EAPXMLUtils eapxmlUtils = new EAPXMLUtils(new FileInputStream(pomFile));
        Node groupIdNode = eapxmlUtils.getXPathNode(XPATH_POM_GROUP_ID);
        Node artifactIdNode = eapxmlUtils.getXPathNode(XPATH_POM_ARTIFACT_ID);
        Node versionNode = eapxmlUtils.getXPathNode(XPATH_POM_VERSION);
        Node packagingNode = eapxmlUtils.getXPathNode(XPATH_POM_PACKAGING);
        Node parentGroupIdNode = eapxmlUtils.getXPathNode(XPATH_POM_PARENT_GROUP_ID);
        Node parentVersionNode = eapxmlUtils.getXPathNode(XPATH_POM_PARENT_VERSION);
        String string = groupId = groupIdNode != null && groupIdNode.getFirstChild() != null ? groupIdNode.getFirstChild().getNodeValue() : null;
        if (groupId == null) {
            groupId = parentGroupIdNode != null && parentGroupIdNode.getFirstChild() != null ? parentGroupIdNode.getFirstChild().getNodeValue() : "";
        }
        String artifactId = artifactIdNode != null && artifactIdNode.getFirstChild() != null ? artifactIdNode.getFirstChild().getNodeValue() : "";
        String string2 = version = versionNode != null && versionNode.getFirstChild() != null ? versionNode.getFirstChild().getNodeValue() : null;
        if (version == null) {
            version = parentVersionNode != null && parentVersionNode.getFirstChild() != null ? parentVersionNode.getFirstChild().getNodeValue() : "";
        }
        String packaging = packagingNode != null && packagingNode.getFirstChild() != null ? packagingNode.getFirstChild().getNodeValue() : "";
        return EAPArtifactUtils.createArtifact(groupId, artifactId, version, packaging);
    }

    private Artifact scanJarNameCoordinates(String groupId, String packaging, String jarName) {
        String[] result = new String[2];
        Matcher m1 = JAR_NAME_PARSER_PATTERN.matcher(jarName);
        boolean matches = m1.matches();
        if (!matches) {
            if (this.logger != null) {
                this.logger.warn((CharSequence)("Cannot parse jar with name: " + jarName + ". Using whole name as artifactId."));
            }
            result[0] = jarName.substring(0, jarName.length() - 4);
            result[1] = "";
        } else {
            result[0] = m1.group(1);
            result[1] = m1.group(2);
        }
        return EAPArtifactUtils.createArtifact(groupId, result[0], result[1], packaging);
    }

    public String getTempPath() {
        if (this.tempPath == null || this.tempPath.trim().length() == 0) {
            return TMP_PATH;
        }
        return this.tempPath;
    }

    public void setTempPath(String tempPath) {
        this.tempPath = tempPath;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public String getEapRoot() {
        return this.eapRoot;
    }

    public Log getLogger() {
        return this.logger;
    }

    public static class EAPBaseModule {
        String name;
        String slot;
        HashMap<Artifact, File> resources = new HashMap();
        String moduleNameAlias;
        String moduleSlotAlias;

        private EAPBaseModule() {
        }

        private String getSlot() {
            if (this.slot == null || this.slot.trim().length() == 0) {
                return "main";
            }
            return this.slot;
        }

        private void setSlot(String slot) {
            this.slot = slot;
        }

        private String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        private HashMap<Artifact, File> getResources() {
            return this.resources;
        }

        private void setResources(HashMap<Artifact, File> resources) {
            this.resources = resources;
        }

        private String getModuleNameAlias() {
            return this.moduleNameAlias;
        }

        private void setModuleNameAlias(String moduleNameAlias) {
            this.moduleNameAlias = moduleNameAlias;
        }

        private String getModuleSlotAlias() {
            if (this.moduleSlotAlias == null || this.moduleSlotAlias.trim().length() == 0) {
                return "main";
            }
            return this.moduleSlotAlias;
        }

        private void setModuleSlotAlias(String moduleSlotAlias) {
            this.moduleSlotAlias = moduleSlotAlias;
        }

        public void update(EAPBaseModule other) {
            this.resources = other.resources;
        }

        public String getMavenModuleName() {
            return this.getName().replaceAll("\\.", "-") + "-" + this.getSlot();
        }

        public String toString() {
            if (this.name == null || this.name.trim().length() == 0) {
                return super.toString();
            }
            return this.name + ":" + this.getSlot();
        }
    }
}

