/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.scanner;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.integration.eap.maven.EAPBaseTest;
import org.kie.integration.eap.maven.exception.EAPModuleDefinitionException;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPArtifactResource;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.kie.integration.eap.maven.scanner.EAPBaseModulesScanner;
import org.mockito.Mock;
import org.sonatype.aether.artifact.Artifact;

public class EAPBaseModulesScannerTest
extends EAPBaseTest {
    private static final String MODULES_HIBERNATE_MODULE_POM_XML = "/modules/base/hibernate/pom.xml";
    private static final String MODULES_HIBERNATE_MODULE_NO_NAME_POM_XML = "/modules/base/hibernate/pom-nomodulename.xml";
    private static final String MODULES_HIBERNATE_MODULE_NO_SLOT_POM_XML = "/modules/base/hibernate/pom-nomoduleslot.xml";
    private static final String MODULES_COMMONS_IO_MODULE_POM_XML = "/modules/base/commons-io/pom.xml";
    private static final String BASE_LAYER_NAME = "baseLayer";
    @Mock
    private Artifact hibernateModulePom;
    @Mock
    private Artifact hibernateCoreDependency;
    @Mock
    private EAPModule hibernateModule;
    @Mock
    private Artifact commonsIOModulePom;
    @Mock
    private Artifact commonsIODependency;
    @Mock
    private EAPModule commonsIOModule;
    @Mock
    private EAPLayer baseLayer;
    private EAPBaseModulesScanner tested;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.tested = new EAPBaseModulesScanner();
        this.tested.setLogger(this.logger);
        this.initMockArtifact(this.hibernateModulePom, "org.kie", "org-hibernate-main", null, "pom", null, MODULES_HIBERNATE_MODULE_POM_XML);
        this.initMockArtifact(this.hibernateCoreDependency, "org.hibernate", "hibernate-core", "4.2.0.SP1", "pom", null);
        this.initMockArtifact(this.commonsIOModulePom, "org.kie", "org-apache-commons-io-main", null, "pom", null, MODULES_COMMONS_IO_MODULE_POM_XML);
        this.initMockArtifact(this.commonsIODependency, "commons-io", "commons-io", "2.1", "jar", null);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testScanLayer() throws Exception {
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.hibernateModulePom);
        moduleArtifacts.add(this.commonsIOModulePom);
        this.tested.setScanResources(true);
        this.tested.setArtifactTreeResolved(true);
        EAPLayer baseLayer = this.tested.scan(BASE_LAYER_NAME, moduleArtifacts, null, this.artifactsHolder);
        this.assertLayer(baseLayer, BASE_LAYER_NAME, true, EAPArtifactResource.class);
    }

    @Test
    public void testScanLayerNoResources() throws Exception {
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.hibernateModulePom);
        moduleArtifacts.add(this.commonsIOModulePom);
        this.tested.setScanResources(false);
        this.tested.setArtifactTreeResolved(false);
        EAPLayer baseLayer = this.tested.scan(BASE_LAYER_NAME, moduleArtifacts, null, this.artifactsHolder);
        this.assertLayer(baseLayer, BASE_LAYER_NAME, false, EAPArtifactResource.class);
        EAPModule hibernateModule = baseLayer.getModule("org.hibernate:main");
        Assert.assertTrue((hibernateModule.getResources().size() == 0 ? 1 : 0) != 0);
        EAPModule commonIOModule = baseLayer.getModule("org.apache.commons.io:main");
        Assert.assertTrue((commonIOModule.getResources().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testScanLayerNoModuleName() throws Exception {
        this.testScanLayerModuleException(MODULES_HIBERNATE_MODULE_NO_NAME_POM_XML, EAPModuleDefinitionException.class);
    }

    @Test
    public void testScanLayerNoModuleSlot() throws Exception {
        this.testScanLayerModuleException(MODULES_HIBERNATE_MODULE_NO_SLOT_POM_XML, EAPModuleDefinitionException.class);
    }

    protected void testScanLayerModuleException(String pomUri, Class theExceptionClazz) throws Exception {
        this.initMockArtifact(this.hibernateModulePom, "org.kie", "org-hibernate-main", null, "pom", null, pomUri);
        ArrayList<Artifact> moduleArtifacts = new ArrayList<Artifact>(1);
        moduleArtifacts.add(this.hibernateModulePom);
        this.tested.setScanResources(true);
        this.tested.setArtifactTreeResolved(false);
        Exception result = null;
        try {
            EAPLayer baseLayer = this.tested.scan(BASE_LAYER_NAME, moduleArtifacts, null, this.artifactsHolder);
        }
        catch (Exception e) {
            result = e;
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(result.getClass(), (Object)theExceptionClazz);
    }

    protected void assertLayer(EAPLayer layer, String layerName, boolean assertResources, Class resourcesClazz) {
        Assert.assertTrue((layer != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)layerName, (Object)layer.getName());
        EAPModule hibernateModule = layer.getModule("org.hibernate:main");
        this.assertModule(layer, hibernateModule, "org.hibernate", "main", this.hibernateModulePom, assertResources, resourcesClazz);
        EAPModule commonsIOModule = layer.getModule("org.apache.commons.io:main");
        this.assertModule(layer, commonsIOModule, "org.apache.commons.io", "main", this.commonsIOModulePom, assertResources, resourcesClazz);
    }

    protected void assertModule(EAPLayer layer, EAPModule module, String moduleName, String moduleSlot, Artifact modulePom, boolean assertResources, Class resourcesClazz) {
        Assert.assertNotNull((Object)module);
        Assert.assertEquals((Object)module.getName(), (Object)moduleName);
        Assert.assertEquals((Object)module.getSlot(), (Object)moduleSlot);
        Assert.assertEquals((Object)module.getUniqueId(), (Object)(moduleName + ":" + moduleSlot));
        Assert.assertEquals((Object)module.getArtifact(), (Object)modulePom);
        Assert.assertEquals((Object)module.getLayer(), (Object)layer);
        if (assertResources) {
            Assert.assertNotNull((Object)module.getResources());
            Assert.assertTrue((module.getResources().size() == 1 ? 1 : 0) != 0);
            Collection resources = module.getResources();
            for (EAPModuleResource resource : resources) {
                Assert.assertEquals(resource.getClass(), (Object)resourcesClazz);
            }
        }
    }
}

