/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.util;

import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.integration.eap.maven.exception.EAPModuleResourceDuplicationException;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.kie.integration.eap.maven.util.EAPArtifactsHolder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class EAPArtifactsHolderTest {
    protected static final String DROOLS_MODULE_GROUPID = "org.drools";
    protected static final String DROOLS_MODULE_ARTIFACTID = "org-drools";
    protected static final String DROOLS_MODULE_VERSION = "1.0";
    protected static final String DROOLS_MODULE_TYPE = "jar";
    protected static final String JBPM_MODULE_GROUPID = "org.jbpm";
    protected static final String JBPM_MODULE_ARTIFACTID = "org-jbpm";
    protected static final String JBPM_MODULE_VERSION = "1.0";
    protected static final String JBPM_MODULE_TYPE = "jar";
    protected static final String JBPM_MODULE_NAME = "org.jbpm-name";
    protected static final String JBPM_MODULE_SLOT = "jbpm-slot";
    protected static final String DROOLS_MODULE_NAME = "org.drools-name";
    protected static final String DROOLS_MODULE_SLOT = "drools-slot";
    protected EAPArtifactsHolder artifactsHolder;
    @Mock
    protected RepositorySystem repoSystem;
    @Mock
    protected RepositorySystemSession repoSession;
    @Mock
    protected List<RemoteRepository> remoteRepos;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.artifactsHolder = new EAPArtifactsHolder(this.repoSystem, this.repoSession, this.remoteRepos);
    }

    @Test
    public void testAddArtifact() throws Exception {
        Artifact droolsArtifact = this.createDroolsArtifact();
        String droolsArtifactCoords = EAPArtifactUtils.getArtifactCoordinates((Artifact)droolsArtifact);
        Artifact jbpmArtifact = this.createJBPMArtifact();
        String jbpmArtifactCoords = EAPArtifactUtils.getArtifactCoordinates((Artifact)jbpmArtifact);
        this.artifactsHolder.add(droolsArtifact);
        this.artifactsHolder.add(jbpmArtifact);
        Assert.assertEquals((Object)droolsArtifact, (Object)this.artifactsHolder.getArtifact(droolsArtifactCoords));
        Assert.assertEquals((Object)droolsArtifact, (Object)this.artifactsHolder.getArtifact(droolsArtifact));
        Assert.assertEquals((Object)jbpmArtifact, (Object)this.artifactsHolder.getArtifact(jbpmArtifactCoords));
        Assert.assertEquals((Object)jbpmArtifact, (Object)this.artifactsHolder.getArtifact(jbpmArtifact));
        Assert.assertNull((Object)this.artifactsHolder.get("org.drools:org-drools:jar:1.1"));
    }

    @Test
    public void testAddArtifactAndModule() throws Exception {
        Artifact droolsArtifact = this.createDroolsArtifact();
        String droolsArtifactCoords = EAPArtifactUtils.getArtifactCoordinates((Artifact)droolsArtifact);
        Artifact jbpmArtifact = this.createJBPMArtifact();
        String jbpmArtifactCoords = EAPArtifactUtils.getArtifactCoordinates((Artifact)jbpmArtifact);
        EAPModule droolsModule = this.createDroolsModule();
        EAPModule jbpmModule = this.createJBPMModule();
        this.artifactsHolder.add(droolsArtifact, droolsModule);
        this.artifactsHolder.add(jbpmArtifact, jbpmModule);
        Assert.assertEquals((Object)droolsArtifact, (Object)this.artifactsHolder.getArtifact(droolsArtifactCoords));
        Assert.assertEquals((Object)droolsArtifact, (Object)this.artifactsHolder.getArtifact(droolsArtifact));
        Assert.assertEquals((Object)jbpmArtifact, (Object)this.artifactsHolder.getArtifact(jbpmArtifactCoords));
        Assert.assertEquals((Object)jbpmArtifact, (Object)this.artifactsHolder.getArtifact(jbpmArtifact));
        Assert.assertNull((Object)this.artifactsHolder.get("org.drools:org-drools:jar:1.1"));
        Assert.assertEquals((Object)droolsModule, (Object)this.artifactsHolder.getModule(droolsArtifactCoords));
        Assert.assertEquals((Object)droolsModule, (Object)this.artifactsHolder.getModule(droolsArtifact));
        Assert.assertEquals((Object)jbpmModule, (Object)this.artifactsHolder.getModule(jbpmArtifactCoords));
        Assert.assertEquals((Object)jbpmModule, (Object)this.artifactsHolder.getModule(jbpmArtifact));
    }

    @Test
    public void testAddArtifactAndSetModule() throws Exception {
        Artifact droolsArtifact = this.createDroolsArtifact();
        String droolsArtifactCoords = EAPArtifactUtils.getArtifactCoordinates((Artifact)droolsArtifact);
        Artifact jbpmArtifact = this.createJBPMArtifact();
        String jbpmArtifactCoords = EAPArtifactUtils.getArtifactCoordinates((Artifact)jbpmArtifact);
        EAPModule droolsModule = this.createDroolsModule();
        EAPModule jbpmModule = this.createJBPMModule();
        this.artifactsHolder.add(droolsArtifact);
        this.artifactsHolder.add(jbpmArtifact);
        this.artifactsHolder.setModule(droolsArtifact, droolsModule);
        this.artifactsHolder.setModule(jbpmArtifactCoords, jbpmModule);
        Assert.assertEquals((Object)droolsArtifact, (Object)this.artifactsHolder.getArtifact(droolsArtifactCoords));
        Assert.assertEquals((Object)droolsArtifact, (Object)this.artifactsHolder.getArtifact(droolsArtifact));
        Assert.assertEquals((Object)jbpmArtifact, (Object)this.artifactsHolder.getArtifact(jbpmArtifactCoords));
        Assert.assertEquals((Object)jbpmArtifact, (Object)this.artifactsHolder.getArtifact(jbpmArtifact));
        Assert.assertNull((Object)this.artifactsHolder.get("org.drools:org-drools:jar:1.1"));
        Assert.assertEquals((Object)droolsModule, (Object)this.artifactsHolder.getModule(droolsArtifactCoords));
        Assert.assertEquals((Object)droolsModule, (Object)this.artifactsHolder.getModule(droolsArtifact));
        Assert.assertEquals((Object)jbpmModule, (Object)this.artifactsHolder.getModule(jbpmArtifactCoords));
        Assert.assertEquals((Object)jbpmModule, (Object)this.artifactsHolder.getModule(jbpmArtifact));
    }

    @Test(expected=EAPModuleResourceDuplicationException.class)
    public void testModuleResourceDuplicationException() throws Exception {
        Artifact droolsArtifact = this.createDroolsArtifact();
        Artifact jbpmArtifact = this.createJBPMArtifact();
        EAPModule droolsModule = this.createDroolsModule();
        EAPModule jbpmModule = this.createJBPMModule();
        EAPModule dummyModule = this.createModule("dummy-name", "dummy-slot");
        this.artifactsHolder.add(droolsArtifact, droolsModule);
        this.artifactsHolder.add(jbpmArtifact, jbpmModule);
        this.artifactsHolder.add(droolsArtifact, dummyModule);
    }

    protected Artifact createJBPMArtifact() {
        return this.createArtifact(JBPM_MODULE_GROUPID, JBPM_MODULE_ARTIFACTID, "1.0", "jar", null);
    }

    protected Artifact createDroolsArtifact() {
        return this.createArtifact(DROOLS_MODULE_GROUPID, DROOLS_MODULE_ARTIFACTID, "1.0", "jar", null);
    }

    protected Artifact createArtifact(String groupId, String artifactId, String version, String type, String classifier) {
        Artifact artifact = (Artifact)Mockito.mock(Artifact.class);
        Mockito.when((Object)artifact.getGroupId()).thenReturn((Object)groupId);
        Mockito.when((Object)artifact.getArtifactId()).thenReturn((Object)artifactId);
        Mockito.when((Object)artifact.getVersion()).thenReturn((Object)(version != null ? version : ""));
        Mockito.when((Object)artifact.getExtension()).thenReturn((Object)(type != null ? type : ""));
        Mockito.when((Object)artifact.getClassifier()).thenReturn((Object)(classifier != null ? classifier : ""));
        return artifact;
    }

    protected EAPModule createJBPMModule() {
        return this.createModule(JBPM_MODULE_NAME, JBPM_MODULE_SLOT);
    }

    protected EAPModule createDroolsModule() {
        return this.createModule(DROOLS_MODULE_NAME, DROOLS_MODULE_SLOT);
    }

    protected EAPModule createModule(String name, String slot) {
        EAPModule module = (EAPModule)Mockito.mock(EAPModule.class);
        Mockito.when((Object)module.getName()).thenReturn((Object)name);
        Mockito.when((Object)module.getSlot()).thenReturn((Object)slot);
        return module;
    }

    @After
    public void tearDown() throws Exception {
    }
}

