/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.kie.integration.eap.maven.builder.EAPModulesDependencyBuilder;
import org.kie.integration.eap.maven.builder.EAPModulesGraphBuilder;
import org.kie.integration.eap.maven.configuration.EAPConfigurationArtifact;
import org.kie.integration.eap.maven.configuration.EAPConfigurationModuleDependency;
import org.kie.integration.eap.maven.distribution.EAPLayerDistributionManager;
import org.kie.integration.eap.maven.distribution.EAPStaticLayerDistribution;
import org.kie.integration.eap.maven.eap.EAPContainer;
import org.kie.integration.eap.maven.exception.EAPModuleDefinitionException;
import org.kie.integration.eap.maven.exception.EAPModulesDefinitionException;
import org.kie.integration.eap.maven.exception.EAPModulesDependencyBuilderException;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPModuleMissingDependency;
import org.kie.integration.eap.maven.model.dependency.EAPStaticDistributionModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPStaticModuleDependency;
import org.kie.integration.eap.maven.model.graph.EAPModulesGraph;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPArtifactResource;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.kie.integration.eap.maven.model.resource.EAPUnresolvableArtifactResource;
import org.kie.integration.eap.maven.model.resource.EAPVersionMismatchedArtifactResource;
import org.kie.integration.eap.maven.scanner.EAPBaseModulesScanner;
import org.kie.integration.eap.maven.scanner.EAPModulesScanner;
import org.kie.integration.eap.maven.scanner.EAPStaticModulesScanner;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.kie.integration.eap.maven.util.EAPArtifactsHolder;
import org.kie.integration.eap.maven.util.EAPFileUtils;

public abstract class EAPBaseMojo
extends AbstractMojo {
    protected MavenProject project;
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> remoteRepos;
    protected String distributionName;
    protected EAPConfigurationArtifact baseModule;
    protected List<EAPConfigurationModuleDependency> staticDependencies;
    protected String graphOutputFile;
    protected Boolean failOnMissingDependency = true;
    protected Boolean failOnUnresolvableResource = true;
    protected Boolean failOnVersionMismatchedResource = false;
    protected Boolean includeOptionalDependencies = false;
    protected EAPModulesScanner staticModulesScanner;
    protected EAPModulesScanner baseModulesScanner;
    protected EAPModulesDependencyBuilder modulesDependencyBuilder;
    protected EAPModulesGraphBuilder modulesGraphBuilder;
    protected EAPLayerDistributionManager distributionManager;
    protected transient EAPArtifactsHolder artifactsHolder;
    protected EAPLayer staticModulesLayer;
    protected EAPLayer baseModulesLayer;
    protected EAPContainer container = null;
    protected EAPStaticLayerDistribution distribution;

    protected EAPBaseMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkConfiguration();
        this.initServices();
        org.eclipse.aether.artifact.Artifact rootArtifact = EAPArtifactUtils.createProjectArtifact(this.project);
        DependencyNode dependencyNode = null;
        try {
            dependencyNode = EAPArtifactUtils.getDependencyGraph(rootArtifact, this.repoSystem, this.repoSession, this.remoteRepos, this.includeOptionalDependencies);
        }
        catch (DependencyCollectionException e) {
            throw new MojoExecutionException("Error generating dependency graph.", (Exception)((Object)e));
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException("Error generating dependency graph.", (Exception)((Object)e));
        }
        this.artifactsHolder = this.collectArtifacts(dependencyNode);
        try {
            this.baseModulesLayer = this.loadBaseLayer();
            this.staticModulesLayer = this.loadStaticLayer();
        }
        catch (EAPModulesDefinitionException e) {
            throw new MojoExecutionException("Error obtaining modules.", (Exception)e);
        }
        catch (EAPModuleDefinitionException e) {
            throw new MojoExecutionException("Error loading module.", (Exception)e);
        }
        this.checkResources();
        try {
            this.generateModulesDependencies(dependencyNode);
            this.checkMissingDependencies();
        }
        catch (EAPModulesDependencyBuilderException e) {
            throw new MojoExecutionException("Error generating JBoss EAP modules dependencies.", (Exception)e);
        }
        EAPModulesGraph graph = this.generateModulesGraph();
        this.distribution = new EAPStaticLayerDistribution(this.distributionName, graph, this.container);
        this.distribution.setStaticLayer(this.staticModulesLayer);
        this.distribution.setBaseLayer(this.baseModulesLayer);
        this.distribution.setArtifactsHolder(this.artifactsHolder);
        this.distribution.setIncludedOptionalDependencies(this.includeOptionalDependencies);
        if (this.graphOutputFile != null && this.graphOutputFile.trim().length() > 0) {
            try {
                EAPFileUtils.writeToFile(this.distribution.print(), this.graphOutputFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error printing graph to file " + this.graphOutputFile, (Exception)e);
            }
        }
    }

    protected void checkResources() throws MojoExecutionException {
        Collection<EAPModule> modules;
        if (!this.failOnUnresolvableResource.booleanValue() && !this.failOnVersionMismatchedResource.booleanValue()) {
            return;
        }
        LinkedHashSet<Object[]> unresolvableResources = new LinkedHashSet<Object[]>();
        LinkedHashSet<Object[]> versionMismatchResources = new LinkedHashSet<Object[]>();
        if (this.staticModulesLayer != null && (modules = this.staticModulesLayer.getModules()) != null && !modules.isEmpty()) {
            EAPArtifactResource resource;
            EAPModule module;
            for (EAPModule module2 : modules) {
                Collection<EAPModuleResource> resources = module2.getResources();
                if (resources == null || resources.isEmpty()) continue;
                for (EAPModuleResource resource2 : resources) {
                    Object[] missingRes;
                    EAPArtifactResource missingResource;
                    try {
                        missingResource = (EAPUnresolvableArtifactResource)resource2;
                        missingRes = new Object[]{module2, missingResource};
                        unresolvableResources.add(missingRes);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        missingResource = (EAPVersionMismatchedArtifactResource)resource2;
                        missingRes = new Object[]{module2, missingResource};
                        versionMismatchResources.add(missingRes);
                    }
                    catch (Exception e) {}
                }
            }
            if (!unresolvableResources.isEmpty()) {
                this.getLog().info((CharSequence)"********************* Unresolvable resources ******************************");
                this.getLog().info((CharSequence)"************* Module name <-> Unresolvable resource ***********************");
                for (Object[] obj : unresolvableResources) {
                    module = (EAPModule)obj[0];
                    resource = (EAPUnresolvableArtifactResource)obj[1];
                    this.getLog().info((CharSequence)(module.getUniqueId() + " <-> " + resource.getName()));
                }
                this.getLog().info((CharSequence)"*************************************************************************");
                if (this.failOnUnresolvableResource.booleanValue()) {
                    throw new MojoExecutionException("There are unresolved resources.");
                }
            }
            if (!versionMismatchResources.isEmpty()) {
                this.getLog().info((CharSequence)"********************************* Version mismatch resources ******************************************");
                this.getLog().info((CharSequence)"************** Module name <-> Resource resolved <-> Version defined in module definition *************");
                for (Object[] obj : versionMismatchResources) {
                    module = (EAPModule)obj[0];
                    resource = (EAPVersionMismatchedArtifactResource)obj[1];
                    this.getLog().info((CharSequence)(module.getUniqueId() + " <-> " + resource.getName() + " <-> " + ((EAPVersionMismatchedArtifactResource)resource).getVersion()));
                }
                this.getLog().info((CharSequence)"********************************************************************************************************");
                if (this.failOnVersionMismatchedResource.booleanValue()) {
                    throw new MojoExecutionException("There are version mismatched resources.");
                }
            }
        }
    }

    protected void checkMissingDependencies() throws EAPModulesDependencyBuilderException {
        Collection<EAPModule> modules;
        LinkedHashSet<Object[]> missingDependencies = new LinkedHashSet<Object[]>();
        if (this.staticModulesLayer != null && (modules = this.staticModulesLayer.getModules()) != null && !modules.isEmpty()) {
            for (EAPModule module : modules) {
                Collection<EAPModuleDependency> dependencies = module.getDependencies();
                if (dependencies == null || dependencies.isEmpty()) continue;
                for (EAPModuleDependency dependency : dependencies) {
                    try {
                        EAPModuleMissingDependency missingDependency = (EAPModuleMissingDependency)dependency;
                        if (missingDependency.isOptional()) continue;
                        Object[] missingDep = new Object[]{module, dependency};
                        missingDependencies.add(missingDep);
                    }
                    catch (Exception e) {}
                }
            }
            if (!missingDependencies.isEmpty()) {
                this.getLog().info((CharSequence)"********************* Missing dependencies ******************************");
                for (Object[] obj : missingDependencies) {
                    EAPModule module = (EAPModule)obj[0];
                    EAPModuleMissingDependency dependency = (EAPModuleMissingDependency)obj[1];
                    String dependencyCoords = EAPArtifactUtils.getArtifactCoordinates(dependency.getArtifact());
                    Collection<EAPModule> parents = dependency.getReferences();
                    StringBuilder parentsNames = new StringBuilder();
                    if (parents != null && !parents.isEmpty()) {
                        for (EAPModule parent : parents) {
                            parentsNames.append(parent.getUniqueId()).append(" ");
                        }
                    }
                    StringBuilder log = new StringBuilder();
                    log.append("Module/s [").append((CharSequence)parentsNames).append("] require [").append(dependencyCoords).append("]").append(" and this depedency is not present in any module. This artifact should be added or excluded");
                    if (!parentsNames.toString().trim().equalsIgnoreCase(module.getUniqueId())) {
                        log.append(" in module " + module.getUniqueId());
                    }
                    this.getLog().info((CharSequence)log.toString());
                }
                this.getLog().info((CharSequence)"*************************************************************************");
                if (this.failOnMissingDependency.booleanValue()) {
                    throw new EAPModulesDependencyBuilderException("There are missing/unresolved dependencies.");
                }
            }
        }
    }

    protected void checkConfiguration() throws MojoFailureException {
        if (this.distributionName == null || this.distributionName.trim().length() == 0) {
            throw new MojoFailureException("Distribution name configuration parameter cannot be null or empty.");
        }
        if (this.baseModule == null) {
            throw new MojoFailureException("Base module configuration parameter is not set.");
        }
    }

    protected void initServices() {
        ((EAPStaticModulesScanner)this.staticModulesScanner).setLogger(this.getLog());
        ((EAPBaseModulesScanner)this.baseModulesScanner).setLogger(this.getLog());
    }

    protected Collection<org.eclipse.aether.artifact.Artifact> getBaseLayerExclusions() {
        return this.baseModule.getExclusionArtifacts();
    }

    protected org.eclipse.aether.artifact.Artifact getBaseModulesArtifact() {
        return this.baseModule.getArtifact();
    }

    protected Collection<EAPStaticDistributionModuleDependency> getStaticDistributionDependencies() throws EAPModuleDefinitionException {
        LinkedList<EAPStaticDistributionModuleDependency> result = null;
        if (this.staticDependencies != null && !this.staticDependencies.isEmpty()) {
            result = new LinkedList<EAPStaticDistributionModuleDependency>();
            for (EAPConfigurationModuleDependency dependency : this.staticDependencies) {
                String moduleDependenciesRaw = dependency.getDependencies();
                Collection<EAPStaticModuleDependency> _moduleStaticDependencies = EAPArtifactUtils.getStaticDependencies(null, this.project.getModel(), moduleDependenciesRaw);
                for (EAPStaticModuleDependency dep : _moduleStaticDependencies) {
                    EAPStaticDistributionModuleDependency newDep = new EAPStaticDistributionModuleDependency(EAPArtifactUtils.getUID(dependency.getName(), dependency.getSlot()), dep);
                    result.add(newDep);
                }
            }
        }
        return result;
    }

    protected EAPArtifactsHolder collectArtifacts(DependencyNode rootNode) {
        EAPArtifactsHolder holder = new EAPArtifactsHolder(this.repoSystem, this.repoSession, this.remoteRepos);
        EAPArtifactUtils.toArtifacts(holder, rootNode.getChildren(), null);
        return holder;
    }

    protected EAPLayer loadStaticLayer() throws EAPModulesDefinitionException, EAPModuleDefinitionException {
        LinkedList<org.eclipse.aether.artifact.Artifact> modules = null;
        Set artifacts = this.project.getDependencyArtifacts();
        if (artifacts != null) {
            modules = new LinkedList<org.eclipse.aether.artifact.Artifact>();
            for (Artifact artifact : artifacts) {
                if (!"pom".equalsIgnoreCase(artifact.getType())) continue;
                org.eclipse.aether.artifact.Artifact resolved = null;
                try {
                    resolved = EAPArtifactUtils.resolveArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier(), this.repoSystem, this.repoSession, this.remoteRepos);
                }
                catch (ArtifactResolutionException e) {
                    throw new EAPModulesDefinitionException("Artifact for module cannot be resolved.", e);
                }
                modules.add(resolved);
            }
        }
        if (modules == null || modules.isEmpty()) {
            throw new EAPModulesDefinitionException("No static module definitions found in project dependencies.");
        }
        ((EAPStaticModulesScanner)this.staticModulesScanner).setBaseModulesLayer(this.baseModulesLayer);
        Collection<EAPStaticDistributionModuleDependency> staticDistroDeps = this.getStaticDistributionDependencies();
        this.staticModulesScanner.setDistributionStaticDependencies(staticDistroDeps);
        return this.staticModulesScanner.scan(this.distributionName, modules, null, this.artifactsHolder);
    }

    protected EAPLayer loadBaseLayer() throws EAPModulesDefinitionException, EAPModuleDefinitionException {
        org.eclipse.aether.artifact.Artifact baseModulesArtifact = this.getBaseModulesArtifact();
        EAPLayer result = null;
        LinkedList<org.eclipse.aether.artifact.Artifact> modules = null;
        String modulesArtifactCoordinates = EAPArtifactUtils.getArtifactCoordinates(baseModulesArtifact);
        this.getLog().info((CharSequence)("Loading module definitions from " + modulesArtifactCoordinates));
        String globalModuleName = null;
        try {
            org.eclipse.aether.artifact.Artifact modulesArtifact = this.artifactsHolder.resolveArtifact(baseModulesArtifact);
            Model modulesArtifactModel = EAPArtifactUtils.generateModel(modulesArtifact);
            globalModuleName = EAPArtifactUtils.getPropertyValue(modulesArtifactModel, (String)modulesArtifactModel.getProperties().get("module.name"));
            if (globalModuleName == null || globalModuleName.trim().length() == 0) {
                throw new EAPModulesDefinitionException("No module name property found for " + modulesArtifactCoordinates);
            }
            this.container = new EAPContainer(globalModuleName);
            List modulesList = modulesArtifactModel.getModules();
            if (modulesList == null || modulesList.isEmpty()) {
                throw new EAPModulesDefinitionException("No modules found for " + modulesArtifactCoordinates);
            }
            this.getLog().info((CharSequence)("Found " + modulesList.size() + " module definitions to load"));
            modules = new LinkedList<org.eclipse.aether.artifact.Artifact>();
            for (String moduleName : modulesList) {
                org.eclipse.aether.artifact.Artifact moduleArtifact = this.artifactsHolder.resolveArtifact(modulesArtifact.getGroupId(), moduleName, modulesArtifact.getVersion(), "pom");
                modules.add(moduleArtifact);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new EAPModulesDefinitionException("Modules artifact cannot be resolved.", e);
        }
        catch (IOException e) {
            throw new EAPModulesDefinitionException("Modules artifact pom cannot be read..", e);
        }
        catch (XmlPullParserException e) {
            throw new EAPModulesDefinitionException("Modules artifact pom cannot be parsed.", e);
        }
        if (modules != null) {
            result = this.baseModulesScanner.scan(globalModuleName, modules, this.getBaseLayerExclusions(), this.artifactsHolder);
        }
        this.getLog().info((CharSequence)"Module definitions loaded successfully");
        return result;
    }

    protected void generateModulesDependencies(DependencyNode rootNode) throws EAPModulesDependencyBuilderException {
        this.modulesDependencyBuilder.build(this.staticModulesLayer, rootNode, this.artifactsHolder);
    }

    protected EAPModulesGraph generateModulesGraph() {
        return this.modulesGraphBuilder.build(this.distributionName, this.staticModulesLayer);
    }

    protected Collection<EAPLayer> getAllLayers() {
        ArrayList<EAPLayer> allLayers = new ArrayList<EAPLayer>(2);
        allLayers.add(this.staticModulesLayer);
        allLayers.add(this.baseModulesLayer);
        return allLayers;
    }
}

