/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.model.dependency;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.aether.artifact.Artifact;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;

public class EAPModuleMissingDependency
implements EAPModuleDependency {
    private String name;
    private String slot;
    private Artifact artifact;
    private boolean optional;
    private boolean export;
    private Collection<EAPModule> references = new LinkedHashSet<EAPModule>();

    public EAPModuleMissingDependency(Artifact artifact) {
        this.artifact = artifact;
        this.name = EAPArtifactUtils.getArtifactCoordinates(artifact);
    }

    public boolean addModuleReference(EAPModule m) {
        return this.references.add(m);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSlot() {
        if (this.slot == null || this.slot.trim().length() == 0) {
            return "main";
        }
        return this.slot;
    }

    public void setSlot(String slot) {
        this.slot = slot;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public Collection<EAPModule> getReferences() {
        return this.references;
    }

    @Override
    public boolean isExport() {
        return this.export;
    }

    public void setExport(boolean export) {
        this.export = export;
    }
}

