/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.patch;

import java.util.Collection;
import java.util.LinkedList;
import org.codehaus.plexus.component.annotations.Component;
import org.kie.integration.eap.maven.distribution.EAPStaticLayerDistribution;
import org.kie.integration.eap.maven.eap.EAPContainer;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.patch.EAPAbstractPatch;
import org.kie.integration.eap.maven.patch.EAPDynamicModulesPatch;
import org.kie.integration.eap.maven.patch.EAPPatch;
import org.kie.integration.eap.maven.patch.EAPPatchException;
import org.kie.integration.eap.maven.patch.EAPStaticModulesPatch;
import org.kie.integration.eap.maven.patch.EAPWebfragmentPatch;
import org.kie.integration.eap.maven.util.EAPArtifactsHolder;

@Component(role=EAPPatchManager.class)
public class EAPPatchManager {
    private EAPPatch[] patches;
    private Collection<EAPStaticModulesPatch> staticPatches = new LinkedList<EAPStaticModulesPatch>();
    private Collection<EAPDynamicModulesPatch> dynamicPatches = new LinkedList<EAPDynamicModulesPatch>();
    private EAPContainer container;

    public EAPPatchManager() {
        this.init_patches();
        this.init();
    }

    private void init_patches() {
        this.patches = new EAPPatch[]{new EAPWebfragmentPatch()};
    }

    private void init() {
        this.staticPatches.clear();
        this.dynamicPatches.clear();
        for (EAPPatch patch : this.patches) {
            EAPAbstractPatch _patch;
            try {
                _patch = (EAPStaticModulesPatch)patch;
                this.staticPatches.add((EAPStaticModulesPatch)_patch);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            try {
                _patch = (EAPDynamicModulesPatch)patch;
                this.dynamicPatches.add((EAPDynamicModulesPatch)_patch);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
    }

    public void initDynamic(EAPContainer container, String outputPath, EAPArtifactsHolder artifactsHolder, EAPStaticLayerDistribution staticLayerDistribution) {
        this.container = container;
        for (EAPDynamicModulesPatch patch : this.dynamicPatches) {
            if (!patch.doApply(container)) continue;
            patch.setOutputPath(outputPath);
            patch.setArtifactsHolder(artifactsHolder);
            patch.setStaticLayerDistribution(staticLayerDistribution);
        }
    }

    public void initStatic(EAPContainer container, String outputPath, EAPArtifactsHolder artifactsHolder, EAPLayer layer) {
        this.container = container;
        for (EAPStaticModulesPatch patch : this.staticPatches) {
            if (!patch.doApply(container)) continue;
            patch.setOutputPath(outputPath);
            patch.setArtifactsHolder(artifactsHolder);
            patch.setStaticLayer(layer);
        }
    }

    public void executeAll() throws EAPPatchException {
        for (EAPPatch patch : this.patches) {
            this.execute(patch);
        }
    }

    public void executeDynamic() throws EAPPatchException {
        for (EAPPatch eAPPatch : this.dynamicPatches) {
            this.execute(eAPPatch);
        }
    }

    public void iterateDynamic(EAPPatchRunnable runnable) throws EAPPatchException {
        for (EAPPatch eAPPatch : this.dynamicPatches) {
            runnable.execute(eAPPatch);
        }
    }

    public void iterateStatic(EAPPatchRunnable runnable) throws EAPPatchException {
        for (EAPPatch eAPPatch : this.staticPatches) {
            runnable.execute(eAPPatch);
        }
    }

    public void executeStatic() throws EAPPatchException {
        for (EAPPatch eAPPatch : this.staticPatches) {
            this.execute(eAPPatch);
        }
    }

    protected void execute(EAPPatch patch) throws EAPPatchException {
        if (patch.doApply(this.container)) {
            patch.execute();
        }
    }

    public EAPPatch[] getPatches() {
        return this.patches;
    }

    public Collection<EAPStaticModulesPatch> getStaticModulePatches() {
        return this.staticPatches;
    }

    public Collection<EAPDynamicModulesPatch> getDynamicModulePatches() {
        return this.dynamicPatches;
    }

    public void setPatches(EAPPatch[] patches) {
        this.patches = patches;
        this.init();
    }

    public static interface EAPPatchRunnable {
        public void execute(EAPPatch var1) throws EAPPatchException;
    }
}

