/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.patch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.kie.integration.eap.maven.eap.EAPContainer;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.module.EAPDynamicModule;
import org.kie.integration.eap.maven.patch.EAPDynamicModulesPatch;
import org.kie.integration.eap.maven.patch.EAPPatch;
import org.kie.integration.eap.maven.patch.EAPPatchException;
import org.kie.integration.eap.maven.template.assembly.EAPAssemblyTemplate;
import org.kie.integration.eap.maven.template.assembly.EAPAssemblyTemplateFile;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.kie.integration.eap.maven.util.EAPFileUtils;

@Component(role=EAPPatch.class, hint="webfragment")
public class EAPWebfragmentPatch
extends EAPDynamicModulesPatch {
    private static final String ID = "dynamic.webfragment";
    private static final String WF_ENTRY_NAME = "META-INF/web-fragment.xml";
    private static final ComparableVersion EAP_VERSION = new ComparableVersion("6.1.0");
    private static final ComparableVersion AS_VERSION = new ComparableVersion("7.0");
    private Collection<EAPWebfragment> webfragments = new LinkedList<EAPWebfragment>();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean doApply(EAPContainer eap) {
        ComparableVersion version = eap.getVersion();
        EAPContainer.EAPContainerId containerId = eap.getContainerId();
        if (containerId.equals((Object)EAPContainer.EAPContainerId.EAP) && (EAPArtifactUtils.isVersionEqualsThan(version, EAP_VERSION) || EAPArtifactUtils.isVersionGreaterThan(version, EAP_VERSION))) {
            return true;
        }
        return containerId.equals((Object)EAPContainer.EAPContainerId.AS) && (EAPArtifactUtils.isVersionEqualsThan(version, AS_VERSION) || EAPArtifactUtils.isVersionGreaterThan(version, AS_VERSION));
    }

    @Override
    public void execute(EAPModuleGraphNode node, Properties patchProperties) throws EAPPatchException {
        String[] artifacts;
        String artifactCoordinates = patchProperties.getProperty(this.getCurrentPatchModulePropertyName());
        if (artifactCoordinates == null || artifactCoordinates.trim().length() == 0) {
            throw new EAPPatchException("The property value for this patch is null or empty", ID);
        }
        for (String artifact : artifacts = artifactCoordinates.split(",")) {
            EAPWebfragment wf = new EAPWebfragment(node, artifact);
            wf.build();
            this.webfragments.add(wf);
        }
    }

    @Override
    public void patchAssembly(EAPDynamicModule module, EAPAssemblyTemplate assemblyTemplate) throws EAPPatchException {
        super.patchAssembly(module, assemblyTemplate);
        if (!this.webfragments.isEmpty()) {
            for (final EAPWebfragment wf : this.webfragments) {
                String nodeUID = wf.getNode().getUniqueId();
                if (module.getDependency(nodeUID) == null) continue;
                EAPAssemblyTemplateFile wfFile = new EAPAssemblyTemplateFile(){

                    @Override
                    public String getSource() {
                        return wf.getOutputPath();
                    }

                    @Override
                    public String getOutputDirectory() {
                        return "WEB-INF/lib";
                    }

                    @Override
                    public String getFinalName() {
                        return wf.getFinalName();
                    }

                    @Override
                    public boolean isFiltered() {
                        return false;
                    }
                };
                assemblyTemplate.getFiles().add(wfFile);
            }
        }
    }

    private class EAPWebfragment {
        private static final String WEBFRAGMENT_JAR_SUFFIX = "-webfragment.jar";
        private EAPModuleGraphNode node;
        private String artifactCoordinates;
        private String outputPath;

        private EAPWebfragment(EAPModuleGraphNode node, String artifactCoordinates) {
            this.node = node;
            this.artifactCoordinates = artifactCoordinates;
        }

        public void build() throws EAPPatchException {
            Artifact artifact = EAPWebfragmentPatch.this.getArtifact(this.node, this.artifactCoordinates);
            if (artifact == null) {
                throw new EAPPatchException("Cannot resolve the artifact with coordinates '" + this.artifactCoordinates + "' in current module.", EAPWebfragmentPatch.ID);
            }
            Artifact jarArtifact = null;
            try {
                jarArtifact = EAPWebfragmentPatch.this.getArtifactsHolder().resolveArtifact(artifact);
            }
            catch (ArtifactResolutionException e) {
                throw new EAPPatchException("Cannot resolve the artifact with coordinates '" + this.artifactCoordinates + "'.", e, EAPWebfragmentPatch.ID);
            }
            File outPath = new File(EAPWebfragmentPatch.this.getOutputPath());
            outPath.mkdirs();
            boolean found = false;
            ZipFile warFile = null;
            File outXmlFile = null;
            try {
                warFile = new ZipFile(jarArtifact.getFile(), 1);
                Enumeration<? extends ZipEntry> e = warFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (!entry.getName().equalsIgnoreCase(EAPWebfragmentPatch.WF_ENTRY_NAME)) continue;
                    found = true;
                    outXmlFile = new File(outPath, this.getFinalName() + ".xml");
                    InputStream in = warFile.getInputStream(entry);
                    EAPFileUtils.writeToFile(in, outXmlFile);
                }
            }
            catch (IOException e) {
                throw new EAPPatchException("Error extracting webfragment descriptor for  '" + warFile.getName() + "'.", e, EAPWebfragmentPatch.ID);
            }
            if (!found) {
                throw new EAPPatchException("Webfragment descriptor not found in '" + warFile.getName() + "'.", EAPWebfragmentPatch.ID);
            }
            try {
                if (outXmlFile != null) {
                    File outJarFile = EAPFileUtils.createJarFile(EAPWebfragmentPatch.this.getOutputPath(), this.getFinalName(), outXmlFile, EAPWebfragmentPatch.WF_ENTRY_NAME);
                    this.outputPath = outJarFile.getAbsolutePath();
                }
            }
            catch (IOException e) {
                throw new EAPPatchException("Error creating the resulting JAR file", e, EAPWebfragmentPatch.ID);
            }
        }

        public String getFinalName() {
            return this.artifactCoordinates.replaceAll(":", "-") + WEBFRAGMENT_JAR_SUFFIX;
        }

        public EAPModuleGraphNode getNode() {
            return this.node;
        }

        public String getArtifactCoordinates() {
            return this.artifactCoordinates;
        }

        public String getOutputPath() {
            return this.outputPath;
        }

        public void setOutputPath(String outputPath) {
            this.outputPath = outputPath;
        }
    }
}

