/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.scanner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.kie.integration.eap.maven.exception.EAPModuleDefinitionException;
import org.kie.integration.eap.maven.exception.EAPModuleResourceDuplicationException;
import org.kie.integration.eap.maven.exception.EAPModulesDefinitionException;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPStaticDistributionModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPStaticModuleDependency;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.layer.EAPLayerImpl;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.module.EAPStaticModule;
import org.kie.integration.eap.maven.model.resource.EAPArtifactOptionalResource;
import org.kie.integration.eap.maven.model.resource.EAPArtifactResource;
import org.kie.integration.eap.maven.model.resource.EAPUnresolvableArtifactResource;
import org.kie.integration.eap.maven.model.resource.EAPVersionMismatchedArtifactResource;
import org.kie.integration.eap.maven.scanner.EAPModulesScanner;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.kie.integration.eap.maven.util.EAPArtifactsHolder;

@Component(role=EAPModulesScanner.class, hint="static")
public class EAPStaticModulesScanner
implements EAPModulesScanner {
    protected EAPArtifactsHolder artifactsHolder;
    protected EAPLayer layer;
    private EAPLayer baseModulesLayer;
    protected Log logger;
    Collection<String> exclusions;
    Collection<EAPStaticDistributionModuleDependency> staticDistributionDependencies;
    protected boolean scanResources = true;
    protected boolean scanStaticDependencies = true;
    protected boolean artifactTreeResolved = true;

    @Override
    public EAPLayer scan(String layerName, Collection<Artifact> moduleArtifacts, Collection<Artifact> exclusions, EAPArtifactsHolder artifactsHolder) throws EAPModulesDefinitionException, EAPModuleDefinitionException {
        this.artifactsHolder = artifactsHolder;
        this.exclusions = new ArrayList<String>();
        if (moduleArtifacts != null && !moduleArtifacts.isEmpty()) {
            this.layer = new EAPLayerImpl(layerName);
            for (Artifact moduleArtifact : moduleArtifacts) {
                if (!this.isModuleExcluded(moduleArtifact, exclusions)) {
                    EAPModule module = this.createModule(moduleArtifact, exclusions);
                    this.layer.addModule(module);
                    continue;
                }
                try {
                    this.exclusions.add(this.createExclusion(moduleArtifact));
                }
                catch (Exception e) {
                    throw new EAPModuleDefinitionException(EAPArtifactUtils.getArtifactCoordinates(moduleArtifact), "Cannot obtain pom for exclusion", e);
                }
            }
            if (this.scanStaticDependencies) {
                this.cleanStaticDependencies(this.exclusions);
            }
        }
        return this.layer;
    }

    private void cleanStaticDependencies(Collection<String> exclusions) {
        for (EAPModule module : this.layer.getModules()) {
            Collection<EAPModuleDependency> dependencies = module.getDependencies();
            if (dependencies == null || dependencies.isEmpty()) continue;
            Iterator<EAPModuleDependency> dependencyIterator = dependencies.iterator();
            while (dependencyIterator.hasNext()) {
                EAPModuleDependency dependency = dependencyIterator.next();
                String depName = EAPArtifactUtils.getUID(dependency.getName(), dependency.getSlot());
                if (this.layer.getModule(depName) == null && (this.baseModulesLayer == null || this.baseModulesLayer.getModule(depName) == null)) {
                    dependencyIterator.remove();
                    continue;
                }
                if (exclusions == null || !exclusions.contains(depName)) continue;
                dependencyIterator.remove();
            }
        }
    }

    protected String createExclusion(Artifact moduleArtifact) throws IOException, XmlPullParserException {
        Model moduleModel = EAPArtifactUtils.generateModel(moduleArtifact);
        String moduleName = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.name"));
        String moduleSlot = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.slot"));
        return EAPArtifactUtils.getUID(moduleName, moduleSlot);
    }

    protected EAPModule createModule(Artifact moduleArtifact, Collection<Artifact> exclusions) throws EAPModuleDefinitionException {
        EAPModule result = null;
        String moduleArtifactCoordinates = EAPArtifactUtils.getArtifactCoordinates(moduleArtifact);
        try {
            List moduleDependencies;
            Model moduleModel = EAPArtifactUtils.generateModel(moduleArtifact);
            String moduleName = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.name"));
            String moduleLocation = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.location"));
            String moduleType = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.type"));
            String moduleSlot = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.slot"));
            String moduleDependenciesRaw = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.dependencies"));
            if (moduleName != null && moduleSlot != null) {
                String moduleUID = EAPArtifactUtils.getUID(moduleName, moduleSlot);
                if (this.baseModulesLayer != null && this.baseModulesLayer.getModule(moduleUID) != null) {
                    throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The already module exist in JBoss EAP/AS base layer.");
                }
            }
            Properties moduleProperties = new Properties();
            if (moduleName != null) {
                moduleProperties.put("module.name", moduleName);
            }
            if (moduleLocation != null) {
                moduleProperties.put("module.location", moduleLocation);
            }
            if (moduleType != null) {
                moduleProperties.put("module.type", moduleType);
            }
            if (moduleSlot != null) {
                moduleProperties.put("module.slot", moduleSlot);
            }
            if (moduleDependenciesRaw != null) {
                moduleProperties.put("module.dependencies", moduleDependenciesRaw);
            }
            this.checkModuleProperties(moduleProperties, moduleArtifactCoordinates);
            Properties moduleModelProperties = moduleModel.getProperties();
            moduleProperties = new Properties();
            Iterator pNames = (Iterator)((Object)moduleModelProperties.propertyNames());
            while (pNames.hasNext()) {
                String pName = (String)pNames.next();
                if (pName == null || !pName.startsWith("module.") || pName.equalsIgnoreCase("module.name") || pName.equalsIgnoreCase("module.type") || pName.equalsIgnoreCase("module.location") || pName.equalsIgnoreCase("module.slot")) continue;
                String pValue = (String)moduleModelProperties.get(pName);
                moduleProperties.put(pName, pValue);
            }
            result = this.createModuleInstance(moduleArtifact, moduleName, moduleLocation, moduleSlot, moduleProperties);
            if (this.scanStaticDependencies) {
                this.addStaticDependencies(result, moduleModel, moduleDependenciesRaw, exclusions);
                this.addStaticDistributionDependencies(result);
            }
            if (this.scanResources && (moduleDependencies = moduleModel.getDependencies()) != null && !moduleDependencies.isEmpty()) {
                for (Dependency moduleDependency : moduleDependencies) {
                    EAPArtifactResource resource = this.addResource(result, moduleModel, moduleDependency);
                    result.addResource(resource);
                }
            }
        }
        catch (ArtifactResolutionException e) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The artifact cannot be resolved.", e);
        }
        catch (XmlPullParserException e) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The artifact's pom cannot be pared.", e);
        }
        catch (IOException e) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The artifact's pom cannot be read.", e);
        }
        catch (EAPModuleResourceDuplicationException e) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "Resource already present in other module.", e);
        }
        return result;
    }

    protected void addStaticDistributionDependencies(EAPModule result) {
        if (this.staticDistributionDependencies != null && !this.staticDistributionDependencies.isEmpty()) {
            for (EAPStaticDistributionModuleDependency dependency : this.staticDistributionDependencies) {
                boolean isForAllModules;
                String moduleUID = dependency.getModuleUID();
                boolean bl = isForAllModules = EAPStaticDistributionModuleDependency.DISTRO_DEPEPDENCY_FOR_ALL_MODULES.equalsIgnoreCase(moduleUID);
                if (!isForAllModules && !result.getUniqueId().equalsIgnoreCase(moduleUID) || result.getDependency(EAPArtifactUtils.getUID(dependency.getName(), dependency.getSlot())) != null) continue;
                result.addDependency(dependency);
            }
        }
    }

    protected void checkModuleProperties(Properties moduleProperties, String moduleArtifactCoordinates) throws EAPModuleDefinitionException {
        String moduleName = (String)moduleProperties.get("module.name");
        String moduleLocation = (String)moduleProperties.get("module.location");
        String moduleType = (String)moduleProperties.get("module.type");
        String moduleSlot = (String)moduleProperties.get("module.slot");
        String moduleDependenciesRaw = (String)moduleProperties.get("module.dependencies");
        if (moduleName == null || moduleName.trim().length() == 0) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module name is not set.");
        }
        if (moduleType == null || moduleType.trim().length() == 0) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module type is not set.");
        }
        if (moduleSlot == null || moduleSlot.trim().length() == 0) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module slot is not set.");
        }
        if (this.getModuleTypeSupported().equalsIgnoreCase(moduleType)) {
            if (moduleLocation == null || moduleLocation.trim().length() == 0) {
                throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module location is not set.");
            }
        } else {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module scanned is not supported by this scanner implementation '" + this.getClass().getName() + "' as it only supports type " + this.getModuleTypeSupported());
        }
    }

    @Override
    public String getModuleTypeSupported() {
        return "static";
    }

    protected EAPModule createModuleInstance(Artifact artifact, String moduleName, String moduleLocation, String moduleSlot, Properties moduleProperties) {
        EAPStaticModule m = new EAPStaticModule(moduleName, moduleLocation, moduleSlot, moduleProperties);
        m.setLayer(this.layer);
        m.setArtifact(artifact);
        return m;
    }

    protected boolean isModuleExcluded(Artifact module, Collection<Artifact> exclusions) {
        if (module == null) {
            return true;
        }
        if (exclusions != null && !exclusions.isEmpty()) {
            for (Artifact exclusion : exclusions) {
                if (!EAPArtifactUtils.equals(exclusion, module)) continue;
                return true;
            }
        }
        return false;
    }

    protected void addStaticDependencies(EAPModule module, Model moduleModel, String moduleDependenciesRaw, Collection<Artifact> exclusions) throws EAPModuleDefinitionException {
        Collection<EAPStaticModuleDependency> moduleStaticDependencies = EAPArtifactUtils.getStaticDependencies(module.getArtifact(), moduleModel, moduleDependenciesRaw);
        if (moduleStaticDependencies != null) {
            for (EAPStaticModuleDependency dep : moduleStaticDependencies) {
                module.addDependency(dep);
            }
        }
    }

    protected EAPArtifactResource addResource(EAPModule module, Model moduleModel, Dependency moduleDependency) throws ArtifactResolutionException, EAPModuleResourceDuplicationException {
        List exclusions;
        Artifact resolvedArtifact;
        EAPArtifactResource result = null;
        String depGroupId = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getGroupId());
        String depArtifactId = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getArtifactId());
        String depVersion = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getVersion());
        String depType = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getType());
        String depClassifier = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getClassifier());
        Artifact moduleResourceArtifact = EAPArtifactUtils.createArtifact(depGroupId, depArtifactId, depVersion, depType, depClassifier);
        if (this.artifactTreeResolved) {
            resolvedArtifact = this.artifactsHolder.getArtifact(moduleResourceArtifact);
            if (resolvedArtifact != null) {
                Artifact resolved = this.artifactsHolder.resolveArtifact(resolvedArtifact);
                result = moduleDependency.isOptional() ? EAPArtifactOptionalResource.create(resolved) : EAPArtifactResource.create(resolved);
                this.artifactsHolder.setModule(resolvedArtifact, module);
            } else {
                resolvedArtifact = this.artifactsHolder.contains(depGroupId, depArtifactId, depType);
                boolean isResourceVersionMissing = false;
                if (depVersion == null || depVersion.trim().length() == 0) {
                    isResourceVersionMissing = true;
                }
                if (resolvedArtifact != null) {
                    resolvedArtifact = this.artifactsHolder.resolveArtifact(resolvedArtifact);
                    if (isResourceVersionMissing) {
                        result = EAPArtifactResource.create(resolvedArtifact);
                    } else {
                        if (this.logger != null) {
                            this.logger.warn((CharSequence)("The artifact " + moduleResourceArtifact.toString() + " is resolvable in current project but using another version: '" + resolvedArtifact.getVersion() + "'."));
                        }
                        result = EAPVersionMismatchedArtifactResource.create(resolvedArtifact, depVersion);
                    }
                    moduleResourceArtifact = resolvedArtifact;
                } else {
                    if (this.logger != null) {
                        this.logger.warn((CharSequence)("Artifact " + moduleResourceArtifact.toString() + " is not resolvable in current project. Will be not added as module resource."));
                    }
                    result = EAPUnresolvableArtifactResource.create(moduleResourceArtifact);
                }
                this.artifactsHolder.add(moduleResourceArtifact, module);
            }
        } else {
            resolvedArtifact = this.artifactsHolder.resolveArtifact(moduleResourceArtifact);
            result = moduleDependency.isOptional() ? EAPArtifactOptionalResource.create(resolvedArtifact) : EAPArtifactResource.create(resolvedArtifact);
            this.artifactsHolder.add(moduleResourceArtifact, module);
        }
        if (result != null && (exclusions = moduleDependency.getExclusions()) != null && !exclusions.isEmpty()) {
            for (Exclusion exclusion : exclusions) {
                if (this.logger != null) {
                    this.logger.info((CharSequence)("Excluding [" + exclusion.getGroupId() + ":" + exclusion.getArtifactId() + "] from module " + module.getUniqueId()));
                }
                org.eclipse.aether.graph.Exclusion e = new org.eclipse.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), null, null);
                result.addExclusion(e);
            }
        }
        return result;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public boolean isScanResources() {
        return this.scanResources;
    }

    @Override
    public void setScanResources(boolean scanResources) {
        this.scanResources = scanResources;
    }

    public boolean isArtifactTreeResolved() {
        return this.artifactTreeResolved;
    }

    public void setArtifactTreeResolved(boolean artifactTreeResolved) {
        this.artifactTreeResolved = artifactTreeResolved;
    }

    public void setBaseModulesLayer(EAPLayer baseModulesLayer) {
        this.baseModulesLayer = baseModulesLayer;
    }

    public boolean isScanStaticDependencies() {
        return this.scanStaticDependencies;
    }

    @Override
    public void setScanStaticDependencies(boolean scanStaticDependencies) {
        this.scanStaticDependencies = scanStaticDependencies;
    }

    @Override
    public void setDistributionStaticDependencies(Collection<EAPStaticDistributionModuleDependency> dependencies) {
        this.staticDistributionDependencies = dependencies;
    }
}

