/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.builder;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.kie.integration.eap.maven.builder.EAPModulesDependencyBuilder;
import org.kie.integration.eap.maven.exception.EAPModulesDependencyBuilderException;
import org.kie.integration.eap.maven.model.dependency.EAPCustomModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPModuleMissingDependency;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.kie.integration.eap.maven.util.EAPArtifactsHolder;

@Component(role=EAPModulesDependencyBuilder.class)
public class EAPStaticModulesDependencyBuilderImpl
implements EAPModulesDependencyBuilder {
    protected EAPLayer layer;
    protected EAPArtifactsHolder artifactsHolder;

    @Override
    public void build(EAPLayer layer, DependencyNode rootNode, EAPArtifactsHolder artifactsHolder) throws EAPModulesDependencyBuilderException {
        if (rootNode == null) {
            throw new EAPModulesDependencyBuilderException("Root node not set.");
        }
        List rootChildren = rootNode.getChildren();
        if (rootChildren == null || rootChildren.isEmpty()) {
            throw new EAPModulesDependencyBuilderException("Root node does not have child nodes.");
        }
        this.layer = layer;
        this.artifactsHolder = artifactsHolder;
        LinkedList<DependencyNode> parsedNodes = new LinkedList<DependencyNode>();
        this.visitNode(null, null, rootChildren, parsedNodes);
    }

    protected boolean isNodeParsed(Collection<DependencyNode> parsedNodes, DependencyNode node) {
        for (DependencyNode n : parsedNodes) {
            if (n != node) continue;
            return true;
        }
        return false;
    }

    protected void visitNode(EAPModule module, EAPModule parent, List<DependencyNode> children, Collection<DependencyNode> parsedNodes) throws EAPModulesDependencyBuilderException {
        if (children != null && !children.isEmpty()) {
            for (DependencyNode node : children) {
                if (this.isNodeParsed(parsedNodes, node)) continue;
                this.visitNode(module, parent, node, parsedNodes);
            }
        }
    }

    protected void visitModuleNode(EAPModule module, EAPModule parent, List<DependencyNode> children, Collection<DependencyNode> parsedNodes) throws EAPModulesDependencyBuilderException {
        if (children != null && !children.isEmpty()) {
            for (DependencyNode node : children) {
                List _children = node.getChildren();
                if (_children == null || _children.isEmpty()) continue;
                for (DependencyNode _node : _children) {
                    if (this.isNodeParsed(parsedNodes, node)) continue;
                    this.visitNode(module, parent, _node, parsedNodes);
                }
            }
        }
    }

    protected void visitNode(EAPModule module, EAPModule parent, DependencyNode node, Collection<DependencyNode> parsedNodes) throws EAPModulesDependencyBuilderException {
        if (this.isNodeParsed(parsedNodes, node)) {
            return;
        }
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            throw new EAPModulesDependencyBuilderException("Dependency cannot be null.");
        }
        Artifact artifact = dependency.getArtifact();
        if (artifact == null) {
            throw new EAPModulesDependencyBuilderException("Artifact cannot be null.");
        }
        parsedNodes.add(node);
        EAPModule m = this.layer.getModule(artifact);
        if (m != null) {
            if (parent == null) {
                parent = m;
            }
            this.createDependency(module, m, dependency.isOptional());
            this.visitModuleNode(m, parent, node.getChildren(), parsedNodes);
        } else {
            m = this.findArtifactInModule(artifact);
            if (m != null) {
                this.createDependency(module, m, artifact, dependency.isOptional());
                this.visitNode(m, parent, node.getChildren(), parsedNodes);
            } else if (!EAPArtifactUtils.isArtifactExcludedInModule(module, artifact)) {
                this.createMissingDependency(module, parent, artifact, dependency.isOptional());
            }
        }
    }

    protected EAPModule findArtifactInModule(Artifact artifact) throws EAPModulesDependencyBuilderException {
        if (artifact == null) {
            throw new EAPModulesDependencyBuilderException("Artifact cannot be null.");
        }
        return this.artifactsHolder.getModule(artifact);
    }

    protected EAPModuleDependency createDependency(EAPModule parent, EAPModule module, Artifact artifact, boolean isOptional) throws EAPModulesDependencyBuilderException {
        if (module == null) {
            throw new EAPModulesDependencyBuilderException("Module cannot be null.");
        }
        if (parent != null && parent.equals(module)) {
            return null;
        }
        EAPCustomModuleDependency dep = null;
        if (parent != null) {
            dep = (EAPCustomModuleDependency)parent.getDependency(module.getUniqueId());
        }
        if (dep == null) {
            dep = (EAPCustomModuleDependency)module.createDependency();
            dep.setSlot(module.getSlot());
            dep.setOptional(isOptional);
            if (parent != null) {
                parent.addDependency(dep);
            }
        }
        if (artifact != null) {
            dep.addArtifact(artifact);
        }
        return dep;
    }

    protected EAPModuleDependency createDependency(EAPModule parent, EAPModule module, boolean isOptional) throws EAPModulesDependencyBuilderException {
        return this.createDependency(parent, module, null, isOptional);
    }

    protected EAPModuleMissingDependency createMissingDependency(EAPModule moodule, EAPModule parent, Artifact artifact, boolean isOptional) throws EAPModulesDependencyBuilderException {
        if (moodule == null) {
            throw new EAPModulesDependencyBuilderException("Module cannot be null.");
        }
        EAPModuleMissingDependency dep = null;
        if (moodule != null && (dep = (EAPModuleMissingDependency)moodule.getDependency(EAPArtifactUtils.getArtifactCoordinates(artifact))) == null) {
            dep = new EAPModuleMissingDependency(artifact);
            if (parent != null) {
                dep.addModuleReference(parent);
            }
            dep.setOptional(isOptional);
            moodule.addDependency(dep);
        }
        return dep;
    }
}

