/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.kie.integration.eap.maven.configuration.EAPConfigurationArtifact;
import org.kie.integration.eap.maven.distribution.EAPLayerDistributionManager;
import org.kie.integration.eap.maven.distribution.EAPStaticLayerDistribution;
import org.kie.integration.eap.maven.exception.EAPModuleDefinitionException;
import org.kie.integration.eap.maven.exception.EAPModuleResourceDuplicationException;
import org.kie.integration.eap.maven.exception.EAPModulesDefinitionException;
import org.kie.integration.eap.maven.model.dependency.EAPModuleDependency;
import org.kie.integration.eap.maven.model.dependency.EAPStaticModuleDependency;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeDependency;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeResource;
import org.kie.integration.eap.maven.model.graph.distribution.EAPModuleNodeGraphDependency;
import org.kie.integration.eap.maven.model.module.EAPDynamicModule;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.kie.integration.eap.maven.patch.EAPDynamicModulesPatch;
import org.kie.integration.eap.maven.patch.EAPPatch;
import org.kie.integration.eap.maven.patch.EAPPatchException;
import org.kie.integration.eap.maven.patch.EAPPatchManager;
import org.kie.integration.eap.maven.template.EAPTemplateBuilder;
import org.kie.integration.eap.maven.template.assembly.EAPAssemblyTemplate;
import org.kie.integration.eap.maven.template.assembly.EAPAssemblyTemplateFile;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.kie.integration.eap.maven.util.EAPArtifactsHolder;
import org.kie.integration.eap.maven.util.EAPFileUtils;
import org.kie.integration.eap.maven.util.EAPXMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EAPDynamicModulesBuilderMojo
extends AbstractMojo {
    private static final String JBOSS_DEP_STRUCTURE_NAME = "jboss-deployment-structure";
    private static final String JBOSS_ALL_NAME = "jboss-all";
    private static final String EXTENSION_XML = ".xml";
    private static final String JBOSS_DEP_STRUCTURE_ZIP_ENTRY_NAME = "WEB-INF/jboss-deployment-structure.xml";
    private static final String ASSEMBLY_DESCRIPTOR_NAME = "-assembly.xml";
    private static final String EXCLUSIONS_PATH = "WEB-INF/lib/";
    private static final String JBOSS_ALL_DEPENDENCY_NAME_PREFFIX = "jboss-all-";
    private static final String DISTRO_XML_ENTRY_PATH = "org.kie.integration.eap.maven.distributions".replaceAll("\\.", "/") + "/" + "distribution.xml";
    private static final String ASSEMBLY_OUTPUT_PATH = "modules" + File.separator + "system" + File.separator + "layers";
    private static Pattern PATTERN_WAR_LIBRARIES = Pattern.compile("WEB-INF/lib/(.*).jar");
    protected MavenProject project;
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> remoteRepos;
    protected String distributionName;
    protected String outputPath;
    protected String assemblyFormats;
    protected EAPConfigurationArtifact staticLayerArtifact;
    private EAPTemplateBuilder templateBuilder;
    protected EAPLayerDistributionManager distributionManager;
    protected EAPPatchManager patchManager;
    private Collection<org.eclipse.aether.artifact.Artifact> dynamicModuleArtifacts = null;
    private Collection<EAPDynamicModule> dynamicModules;
    private EAPStaticLayerDistribution staticLayerDistribution;
    private EAPArtifactsHolder artifactsHolder;
    private Map<org.eclipse.aether.artifact.Artifact, EAPModuleGraphNode> staticModulesGraphArtifacts;
    private String distroOutputPath = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkConfiguration();
        this.initServices();
        this.distroOutputPath = this.outputPath + File.separator + "dynamic-modules" + File.separator + this.distributionName;
        try {
            this.dynamicModuleArtifacts = this.scanPomDependencies();
            if (this.dynamicModuleArtifacts == null || this.dynamicModuleArtifacts.isEmpty()) {
                throw new EAPModulesDefinitionException("No dynamic modules found in project dependency artifacts.");
            }
            this.getLog().info((CharSequence)("Found " + this.dynamicModuleArtifacts.size() + " POM dependency artifacts."));
            org.eclipse.aether.artifact.Artifact moduleResolvedArtifact = this.artifactsHolder.resolveArtifact(this.staticLayerArtifact.getArtifact());
            this.staticLayerDistribution = this.distributionManager.read(this.getStaticDistributionXMLAsString(moduleResolvedArtifact));
            this.dynamicModules = new ArrayList<EAPDynamicModule>();
            for (org.eclipse.aether.artifact.Artifact artifact : this.dynamicModuleArtifacts) {
                EAPDynamicModule dynamicModule = this.scanDynamicModule(artifact);
                this.dynamicModules.add(dynamicModule);
            }
            this.staticModulesGraphArtifacts = new LinkedHashMap<org.eclipse.aether.artifact.Artifact, EAPModuleGraphNode>(this.staticLayerDistribution.getGraph().getNodes().size());
            List<EAPModuleGraphNode> staticModules = this.staticLayerDistribution.getGraph().getNodes();
            for (EAPModuleGraphNode staticModule : staticModules) {
                this.fixDynamicModuleDependency(staticModule);
                this.staticModulesGraphArtifacts.put(staticModule.getArtifact(), staticModule);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Cannot resolve the dependency. ", (Exception)((Object)e));
        }
        catch (EAPModulesDefinitionException e) {
            throw new MojoExecutionException("Cannot resolve module definitions. ", (Exception)e);
        }
        catch (EAPModuleDefinitionException e) {
            throw new MojoExecutionException("cannot resolve a module definition. ", (Exception)e);
        }
        catch (EAPModuleResourceDuplicationException e) {
            throw new MojoExecutionException("Resource is duplicated. ", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot read static layer distribution.", e);
        }
        String patchOutputPath = this.distroOutputPath + File.separator + "patches";
        this.patchManager.initDynamic(this.staticLayerDistribution.getContainer(), patchOutputPath, this.artifactsHolder, this.staticLayerDistribution);
        try {
            this.patchManager.executeDynamic();
        }
        catch (EAPPatchException e) {
            throw new MojoExecutionException("Problem executing a dynamic module patch.", (Exception)e);
        }
        for (EAPDynamicModule eAPDynamicModule : this.dynamicModules) {
            LinkedList<EAPModuleNodeGraphDependency> staticModuleDependencies = new LinkedList<EAPModuleNodeGraphDependency>();
            LinkedHashSet<String> staticModuleResourceNames = new LinkedHashSet<String>();
            Collection<EAPModuleDependency> _dependencies = eAPDynamicModule.getDependencies();
            if (_dependencies != null && !_dependencies.isEmpty()) {
                for (EAPModuleDependency dependency : _dependencies) {
                    EAPModuleNodeGraphDependency dep = new EAPModuleNodeGraphDependency(dependency.getName(), dependency.getSlot(), false);
                    staticModuleDependencies.add(dep);
                    EAPModuleGraphNode node = this.staticModulesGraphArtifacts.get(((EAPStaticModuleDependency)dependency).getArtifacts().iterator().next());
                    List<EAPModuleGraphNodeResource> resources = node.getResources();
                    if (resources == null || resources.isEmpty()) continue;
                    for (EAPModuleResource eAPModuleResource : resources) {
                        staticModuleResourceNames.add(EXCLUSIONS_PATH + eAPModuleResource.getFileName());
                    }
                }
            }
            ZipFile war = null;
            EAPWarResources warResources = null;
            String jbossDeploymentStructure = null;
            String jbossAll = null;
            String warArtifactCoordinates = EAPArtifactUtils.getArtifactCoordinates(eAPDynamicModule.getWarFile());
            try {
                war = this.getWarFile(eAPDynamicModule);
                warResources = this.scanWarResources(war);
                jbossDeploymentStructure = this.generateJbossDeploymentStructure(staticModuleDependencies, war, warResources.getJbossDeploymentStructure());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot obtain WAR dependency file or cannot access its content.", (Exception)e);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Cannot resolve WAR dependency.", (Exception)((Object)e));
            }
            if (eAPDynamicModule.isAddJbossAll()) {
                String jbossAllPropertyName = JBOSS_ALL_DEPENDENCY_NAME_PREFFIX + eAPDynamicModule.getName();
                jbossAll = this.templateBuilder.buildDynamicModuleDependency(jbossAllPropertyName);
            }
            try {
                Collection<String> exclusions = this.generateWarExclusions(staticModuleResourceNames, warResources.getWarLibs());
                exclusions.add(JBOSS_DEP_STRUCTURE_ZIP_ENTRY_NAME);
                String string = this.generateAssemblyDescriptor(eAPDynamicModule, warArtifactCoordinates, jbossDeploymentStructure, jbossAll, exclusions);
                File out = EAPFileUtils.writeFile(new File(this.distroOutputPath), eAPDynamicModule.getArtifact().getArtifactId() + ASSEMBLY_DESCRIPTOR_NAME, string);
                this.getLog().info((CharSequence)("Assembly file generated into " + out.getAbsolutePath()));
                this.getLog().info((CharSequence)"Dynamic distribution generated sucessfully.");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception generating the assembly file. ", (Exception)e);
            }
        }
    }

    private String getStaticDistributionXMLAsString(org.eclipse.aether.artifact.Artifact moduleResolvedArtifact) throws MojoExecutionException {
        String result = null;
        try {
            ZipFile zipFile = new ZipFile(moduleResolvedArtifact.getFile(), 1);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.getName().equalsIgnoreCase(DISTRO_XML_ENTRY_PATH)) continue;
                InputStream in = zipFile.getInputStream(entry);
                result = EAPFileUtils.getStringFromInputStream(in);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot read the distribution descriptor file.", e);
        }
        return result;
    }

    private Collection<String> generateWarExclusions(Collection<String> staticModuleResourceNames, Collection<String> warLibs) {
        if (warLibs == null || warLibs.isEmpty()) {
            return null;
        }
        if (staticModuleResourceNames == null || staticModuleResourceNames.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, String> staticResourceCoords = new HashMap<String, String>(staticModuleResourceNames.size());
        HashMap<String, String> warResourceArtId_fileName = new HashMap<String, String>(warLibs.size());
        for (String string : staticModuleResourceNames) {
            String[] coords = EAPArtifactUtils.parseFileName(string.substring(12, string.length()));
            staticResourceCoords.put(coords[0], coords[1]);
        }
        HashMap<String, String> warResourceCoords = new HashMap<String, String>(warLibs.size());
        for (String resourceName : warLibs) {
            String[] coords = EAPArtifactUtils.parseFileName(resourceName.substring(12, resourceName.length()));
            warResourceCoords.put(coords[0], coords[1]);
            warResourceArtId_fileName.put(coords[0], resourceName);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry warResourceCoordsEntry : warResourceCoords.entrySet()) {
            String warResourceArtId = (String)warResourceCoordsEntry.getKey();
            String warResourceVersion = (String)warResourceCoordsEntry.getValue();
            String staticResourceVersion = (String)staticResourceCoords.get(warResourceArtId);
            if (staticResourceVersion == null) continue;
            if (warResourceVersion != null && !warResourceVersion.equalsIgnoreCase(staticResourceVersion)) {
                this.getLog().warn((CharSequence)("Excluded " + warResourceArtId + ":" + warResourceVersion + " from war but the version defined in static module is " + staticResourceVersion));
            }
            linkedList.add((String)warResourceArtId_fileName.get(warResourceArtId));
        }
        return linkedList;
    }

    private void fixDynamicModuleDependency(EAPModuleGraphNode module) {
        for (EAPDynamicModule dynModule : this.dynamicModules) {
            Collection<EAPModuleDependency> dependencies = dynModule.getDependencies();
            if (dependencies == null || dependencies.isEmpty()) continue;
            for (EAPModuleDependency dependency : dependencies) {
                EAPStaticModuleDependency staticModuleDependency = (EAPStaticModuleDependency)dependency;
                if (staticModuleDependency.getArtifacts().isEmpty()) continue;
                org.eclipse.aether.artifact.Artifact moduleArtifact = staticModuleDependency.getArtifacts().iterator().next();
                if (!EAPArtifactUtils.equals(module.getArtifact(), moduleArtifact)) continue;
                staticModuleDependency.setName(module.getName());
                staticModuleDependency.setSlot(module.getSlot());
            }
        }
    }

    private EAPDynamicModule scanDynamicModule(org.eclipse.aether.artifact.Artifact artifact) throws EAPModuleDefinitionException {
        if (artifact == null) {
            return null;
        }
        String moduleArtifactCoordinates = EAPArtifactUtils.getArtifactCoordinates(artifact);
        try {
            Collection<EAPStaticModuleDependency> moduleStaticDependencies;
            List moduleDependencies;
            Model moduleModel = EAPArtifactUtils.generateModel(artifact);
            String moduleName = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.name"));
            String moduleType = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.type"));
            String moduleDependenciesRaw = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.dependencies"));
            String module_addJbossAll = EAPArtifactUtils.getPropertyValue(moduleModel, (String)moduleModel.getProperties().get("module.add-jboss-all"));
            if (moduleName == null || moduleName.trim().length() == 0) {
                throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module name is not set.");
            }
            if (moduleType == null || moduleType.trim().length() == 0) {
                throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module type is not set.");
            }
            if (!moduleType.equalsIgnoreCase("dynamic")) {
                throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module is not dynamic.");
            }
            EAPDynamicModule result = new EAPDynamicModule(moduleName);
            result.setArtifact(artifact);
            if (module_addJbossAll != null && module_addJbossAll.trim().length() > 0) {
                String jbossAllPropertyName = JBOSS_ALL_DEPENDENCY_NAME_PREFFIX + moduleName;
                String jbossAllPropertyValue = (String)this.project.getProperties().get(jbossAllPropertyName);
                if (jbossAllPropertyValue == null || jbossAllPropertyValue.trim().length() == 0) {
                    throw new EAPModuleDefinitionException(moduleName, "This module contains the jboss-all.xml descriptor but no project property named '" + jbossAllPropertyName + "' is found. Please, set this property in current project using the name of the dependant webapp file as the value.");
                }
                result.setAddJbossAll(Boolean.valueOf(module_addJbossAll));
            }
            if ((moduleDependencies = moduleModel.getDependencies()) != null && !moduleDependencies.isEmpty()) {
                for (Dependency moduleDependency : moduleDependencies) {
                    String artifactId = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getArtifactId());
                    String groupId = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getGroupId());
                    String version = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getVersion());
                    String type = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getType());
                    String classifier = EAPArtifactUtils.getPropertyValue(moduleModel, moduleDependency.getClassifier());
                    org.eclipse.aether.artifact.Artifact artifact1 = EAPArtifactUtils.createArtifact(groupId, artifactId, version, type, classifier);
                    if (!moduleDependency.getType().equalsIgnoreCase("war")) continue;
                    result.setWarFile(artifact1);
                }
            }
            if ((moduleStaticDependencies = EAPArtifactUtils.getStaticDependencies(artifact, moduleModel, moduleDependenciesRaw)) != null) {
                for (EAPStaticModuleDependency dep : moduleStaticDependencies) {
                    String moduleUID = EAPArtifactUtils.getUID(dep.getName(), dep.getSlot());
                    EAPModuleGraphNode node = this.staticLayerDistribution.getGraph().getNode(moduleUID);
                    if (node == null) {
                        throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module contains a dependency to the module " + moduleUID + " which is missing in the static layer");
                    }
                    dep.addArtifact(node.getArtifact());
                    result.addDependency(dep);
                }
            } else {
                List<EAPModuleGraphNode> modules = this.staticLayerDistribution.getGraph().getNodes();
                if (modules != null && !modules.isEmpty()) {
                    for (EAPModuleGraphNode module : modules) {
                        org.eclipse.aether.artifact.Artifact moduleArtifact = module.getArtifact();
                        EAPStaticModuleDependency dep = new EAPStaticModuleDependency(moduleArtifact.getArtifactId());
                        dep.setArtifacts(Arrays.asList(moduleArtifact));
                        result.addDependency(dep);
                    }
                }
            }
            if (result.getWarFile() == null) {
                throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The module has not the required WAR dependency.");
            }
            return result;
        }
        catch (XmlPullParserException e) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The artifact's pom cannot be pared.", e);
        }
        catch (IOException e) {
            throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The artifact's pom cannot be read.", e);
        }
    }

    protected void checkConfiguration() throws MojoFailureException {
        if (this.distributionName == null || this.distributionName.trim().length() == 0) {
            throw new MojoFailureException("Distribution name configuration parameter cannot be null or empty.");
        }
        if (this.outputPath == null || this.outputPath.trim().length() == 0) {
            throw new MojoFailureException("Output path configuration parameter cannot be null or empty.");
        }
        if (this.staticLayerArtifact == null) {
            throw new MojoFailureException("Static layer artifact is not set.");
        }
    }

    protected void initServices() {
        this.artifactsHolder = new EAPArtifactsHolder(this.repoSystem, this.repoSession, this.remoteRepos);
    }

    private Collection<org.eclipse.aether.artifact.Artifact> scanPomDependencies() throws ArtifactResolutionException {
        LinkedList<org.eclipse.aether.artifact.Artifact> result = null;
        Set artifacts = this.project.getDependencyArtifacts();
        if (artifacts != null) {
            result = new LinkedList<org.eclipse.aether.artifact.Artifact>();
            for (Artifact artifact : artifacts) {
                if (!"pom".equalsIgnoreCase(artifact.getType())) continue;
                org.eclipse.aether.artifact.Artifact resolved = EAPArtifactUtils.resolveArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier(), this.repoSystem, this.repoSession, this.remoteRepos);
                result.add(resolved);
            }
        }
        return result;
    }

    protected ZipFile getWarFile(EAPDynamicModule module) throws IOException, ArtifactResolutionException {
        org.eclipse.aether.artifact.Artifact warArtifact = this.artifactsHolder.resolveArtifact(module.getWarFile());
        return new ZipFile(warArtifact.getFile(), 1);
    }

    protected EAPWarResources scanWarResources(ZipFile war) throws MojoExecutionException, IOException {
        Document currentJbossDepStructureDoc = null;
        LinkedList<String> warDependencies = new LinkedList<String>();
        String warName = EAPFileUtils.extractFileName(war.getName());
        try {
            Enumeration<? extends ZipEntry> e = war.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.getName().equalsIgnoreCase(JBOSS_DEP_STRUCTURE_ZIP_ENTRY_NAME)) {
                    InputStream in = war.getInputStream(entry);
                    EAPXMLUtils xmlUtils = new EAPXMLUtils(in);
                    currentJbossDepStructureDoc = xmlUtils.getDocument();
                }
                if (!this.isWarLibrary(entry.getName())) continue;
                warDependencies.add(entry.getName());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read the jboss-deployment-structure descriptor from WAR dependency: " + warName, (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot read the jboss-deployment-structure descriptor from WAR dependency: " + warName, e);
        }
        return new EAPWarResources(currentJbossDepStructureDoc, warDependencies);
    }

    protected boolean isWarLibrary(String fileName) {
        return PATTERN_WAR_LIBRARIES.matcher(fileName).matches();
    }

    protected String generateJbossDeploymentStructure(Collection<EAPModuleNodeGraphDependency> staticModuleDependencies, ZipFile war, Document currentJbossDepStructureDoc) throws MojoExecutionException, IOException {
        String warName = EAPFileUtils.extractFileName(war.getName());
        Collection<EAPModuleGraphNodeDependency> dependencies = new LinkedList<EAPModuleNodeGraphDependency>(staticModuleDependencies);
        if (currentJbossDepStructureDoc != null) {
            this.getLog().info((CharSequence)("Jboss deployment descritpor file found in WAR " + warName + ". Reading its dependencies."));
            Collection<EAPModuleNodeGraphDependency> actualDependencies = this.readCurrentJBossDepStructurDependencies(currentJbossDepStructureDoc);
            dependencies = this.mergeDependencies(staticModuleDependencies, actualDependencies, war);
        }
        return this.templateBuilder.buildJbossDeploymentStructure(dependencies);
    }

    private String generateAssemblyDescriptor(final EAPDynamicModule module, final String inputWarCoordinates, String jbossDeploymentStructureContent, String jbossAllContent, final Collection<String> exclusions) throws MojoExecutionException, IOException {
        final LinkedList<EAPAssemblyTemplateFile> assemblyFiles = new LinkedList<EAPAssemblyTemplateFile>();
        final String layerId = module.getName();
        String jbossDepStuctureName = layerId + "-" + JBOSS_DEP_STRUCTURE_NAME + EXTENSION_XML;
        final File out = EAPFileUtils.writeFile(new File(this.distroOutputPath), jbossDepStuctureName, jbossDeploymentStructureContent);
        EAPAssemblyTemplateFile jbossDepStructureFile = new EAPAssemblyTemplateFile(){

            @Override
            public String getSource() {
                return out.getAbsolutePath();
            }

            @Override
            public String getOutputDirectory() {
                return "WEB-INF";
            }

            @Override
            public String getFinalName() {
                return EAPDynamicModulesBuilderMojo.JBOSS_DEP_STRUCTURE_NAME + EAPDynamicModulesBuilderMojo.EXTENSION_XML;
            }

            @Override
            public boolean isFiltered() {
                return false;
            }
        };
        assemblyFiles.add(jbossDepStructureFile);
        if (jbossAllContent != null) {
            String jbossAllName = layerId + "-" + JBOSS_ALL_NAME + EXTENSION_XML;
            final File out2 = EAPFileUtils.writeFile(new File(this.distroOutputPath), jbossAllName, jbossAllContent);
            EAPAssemblyTemplateFile jbossAllFile = new EAPAssemblyTemplateFile(){

                @Override
                public String getSource() {
                    return out2.getAbsolutePath();
                }

                @Override
                public String getOutputDirectory() {
                    return "META-INF";
                }

                @Override
                public String getFinalName() {
                    return EAPDynamicModulesBuilderMojo.JBOSS_ALL_NAME + EAPDynamicModulesBuilderMojo.EXTENSION_XML;
                }

                @Override
                public boolean isFiltered() {
                    return true;
                }
            };
            assemblyFiles.add(jbossAllFile);
        }
        final EAPAssemblyTemplate assemblyTemplate = new EAPAssemblyTemplate(){

            @Override
            public String getId() {
                return layerId;
            }

            @Override
            public String[] getFormats() {
                return EAPDynamicModulesBuilderMojo.this.assemblyFormats.split(",");
            }

            @Override
            public Collection<String> getInclusions() {
                return Arrays.asList(inputWarCoordinates);
            }

            @Override
            public Collection<String> getExclusions() {
                return exclusions;
            }

            @Override
            public Collection<EAPAssemblyTemplateFile> getFiles() {
                return assemblyFiles;
            }
        };
        try {
            this.patchManager.iterateDynamic(new EAPPatchManager.EAPPatchRunnable(){

                @Override
                public void execute(EAPPatch patch) throws EAPPatchException {
                    EAPDynamicModulesPatch dynamicModulesPatch = (EAPDynamicModulesPatch)patch;
                    dynamicModulesPatch.patchAssembly(module, assemblyTemplate);
                }
            });
        }
        catch (EAPPatchException e) {
            throw new MojoExecutionException("Error executing dynamic patch in lifecycle method 'patchAssembly'.", (Exception)e);
        }
        return this.templateBuilder.buildDynamicModuleAssembly(assemblyTemplate);
    }

    private Collection<EAPModuleGraphNodeDependency> mergeDependencies(Collection<EAPModuleNodeGraphDependency> staticModuleDependencies, Collection<EAPModuleNodeGraphDependency> actualDependencies, ZipFile war) {
        LinkedList<EAPModuleGraphNodeDependency> dependencies = new LinkedList<EAPModuleGraphNodeDependency>();
        dependencies.addAll(staticModuleDependencies);
        if (actualDependencies != null && !actualDependencies.isEmpty()) {
            for (EAPModuleNodeGraphDependency dependency : actualDependencies) {
                String depName = dependency.getName();
                String depSlot = dependency.getSlot() != null ? dependency.getSlot() : "main";
                String depCoords = depName + ":" + depSlot;
                if (!staticModuleDependencies.contains(dependency)) {
                    this.getLog().warn((CharSequence)("Dependency " + depCoords + " is present in actual jboss-deployment-structure file from WAR '" + EAPFileUtils.extractFileName(war.getName()) + "'. It will be added in the new generated jboss-deployment-structure descriptor, if not present."));
                    dependencies.add(dependency);
                    continue;
                }
                this.getLog().warn((CharSequence)("Dependency " + depCoords + " will be overriden by the one from static module definition."));
            }
        }
        return dependencies;
    }

    protected Collection<EAPModuleNodeGraphDependency> readCurrentJBossDepStructurDependencies(Document document) {
        NodeList moduleNodes;
        LinkedList<EAPModuleNodeGraphDependency> result = null;
        if (document != null && (moduleNodes = document.getElementsByTagName("module")) != null && moduleNodes.getLength() > 0) {
            result = new LinkedList<EAPModuleNodeGraphDependency>();
            for (int i = 0; i < moduleNodes.getLength(); ++i) {
                Node exportNode;
                Node slotNode;
                Node node = moduleNodes.item(i);
                NamedNodeMap attrs = node.getAttributes();
                String nameNodeValue = null;
                String slotNodeValue = null;
                String exportNodeValue = null;
                Node nameNode = attrs.getNamedItem("name");
                if (nameNode != null) {
                    nameNodeValue = nameNode.getNodeValue();
                }
                if ((slotNode = attrs.getNamedItem("slot")) != null) {
                    slotNodeValue = nameNode.getNodeValue();
                }
                if ((exportNode = attrs.getNamedItem("export")) != null) {
                    exportNodeValue = nameNode.getNodeValue();
                }
                EAPModuleNodeGraphDependency dep = new EAPModuleNodeGraphDependency(nameNodeValue, slotNodeValue, exportNodeValue != null ? Boolean.valueOf(exportNodeValue) : false);
                result.add(dep);
            }
        }
        return result;
    }

    private static class EAPWarResources {
        private Document jbossDeploymentStructure;
        private Collection<String> warLibs = new LinkedList<String>();

        private EAPWarResources(Document jbossDeploymentStructure, Collection<String> warLibs) {
            this.jbossDeploymentStructure = jbossDeploymentStructure;
            this.warLibs = warLibs;
        }

        private Document getJbossDeploymentStructure() {
            return this.jbossDeploymentStructure;
        }

        private Collection<String> getWarLibs() {
            return this.warLibs;
        }
    }
}

