/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.svg.processor;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jbpm.process.svg.model.NodeSummary;
import org.jbpm.process.svg.model.RenderType;
import org.jbpm.process.svg.model.SetSubProcessLinkTransformation;
import org.jbpm.process.svg.processor.AbstractSVGProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StunnerSVGProcessor
extends AbstractSVGProcessor {
    public StunnerSVGProcessor(Document svgDocument) {
        super(svgDocument, true);
    }

    @Override
    public void defaultCompletedTransformation(String nodeId) {
        this.transform(summary -> Optional.ofNullable(summary.getNode(nodeId)).ifPresent(node -> Optional.ofNullable(node.getBackground()).ifPresent(background -> {
            background.setAttribute("fill", "#C0C0C0");
            this.setNodeBorderColor(node.getRenderType(), node.getBorder(), "#030303");
        })));
    }

    @Override
    public void defaultActiveTransformation(String nodeId) {
        this.transform(summary -> Optional.ofNullable(summary.getNode(nodeId)).ifPresent(node -> Optional.ofNullable(node.getBorder()).ifPresent(border -> this.setNodeBorderColor(node.getRenderType(), (Element)border, "#FF0000"))));
    }

    private void setNodeBorderColor(Optional<RenderType> renderType, Element border, String color) {
        RenderType render = renderType.orElse(RenderType.STROKE);
        switch (render) {
            case STROKE: {
                border.setAttribute("stroke-width", "2");
                border.setAttribute("stroke", color);
                break;
            }
            case FILL: {
                border.setAttribute("fill", color);
            }
        }
    }

    @Override
    public void defaultSubProcessLinkTransformation(String nodeId, String link) {
        this.transform(new SetSubProcessLinkTransformation(nodeId, link));
    }

    private void processNode(Node parent, String nodeId) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node svgIdNode;
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null && (svgIdNode = attributes.getNamedItem("id")) != null) {
                String value = svgIdNode.getNodeValue();
                if (!Objects.nonNull(value)) break;
                Map<String, String> parameters = Stream.of(value.substring(value.indexOf("?") + 1)).filter(Objects::nonNull).map(str -> Collections.list(new StringTokenizer((String)str, "&"))).flatMap(list -> list.stream()).map(String::valueOf).filter(str -> str.split("=").length == 2).collect(Collectors.toMap(v -> v.split("=")[0], v -> v.split("=")[1]));
                NodeSummary nodeSummary = this.summary.getNodesMap().getOrDefault(nodeId, new NodeSummary(nodeId, null, null, null, null, null));
                Element border = Objects.equals(parameters.get("shapeType"), "BORDER") ? (Element)node : nodeSummary.getBorder();
                Element background = Objects.equals(parameters.get("shapeType"), "BACKGROUND") ? (Element)node : nodeSummary.getBackground();
                RenderType renderType = RenderType.valueOf(Optional.ofNullable(parameters.get("renderType")).orElse(nodeSummary.getRenderType().orElse(RenderType.STROKE).name()));
                this.summary.addNode(new NodeSummary(nodeId, border, background, null, null, renderType));
                break;
            }
            this.processNode(node, nodeId);
        }
    }

    @Override
    public void processNodes(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            String nodeId;
            Node nodeIdNode;
            Node svgIdNode;
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null && (svgIdNode = attributes.getNamedItem("id")) != null && (nodeIdNode = attributes.getNamedItem("bpmn2nodeid")) != null && (nodeId = nodeIdNode.getNodeValue()) != null) {
                this.processNode(node, nodeId);
            }
            this.processNodes(node.getChildNodes());
        }
    }
}

