/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.svg.processor;

import org.apache.batik.anim.dom.SVGOMTSpanElement;
import org.jbpm.process.svg.model.NodeSummary;
import org.jbpm.process.svg.model.SetBackgroundColorTransformation;
import org.jbpm.process.svg.model.SetBorderColorTransformation;
import org.jbpm.process.svg.model.SetSubProcessLinkTransformation;
import org.jbpm.process.svg.processor.AbstractSVGProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JBPMDesignerSVGProcessor
extends AbstractSVGProcessor {
    public JBPMDesignerSVGProcessor(Document svgDocument, boolean mapById) {
        super(svgDocument, mapById);
    }

    @Override
    public void defaultCompletedTransformation(String nodeId, String completedNodeColor, String completedBorderColor) {
        this.transform(new SetBackgroundColorTransformation(nodeId, completedNodeColor));
        this.transform(new SetBorderColorTransformation(nodeId, completedBorderColor));
    }

    @Override
    public void defaultActiveTransformation(String nodeId, String activeNodeBorderColor) {
        this.transform(new SetBorderColorTransformation(nodeId, activeNodeBorderColor));
    }

    @Override
    public void defaultSubProcessLinkTransformation(String nodeId, String link) {
        this.transform(new SetSubProcessLinkTransformation(nodeId, link));
    }

    @Override
    public void defaultActiveAsyncTransformation(String nodeId, String activeAsyncNodeBorderColor) {
        this.transform(new SetBorderColorTransformation(nodeId, activeAsyncNodeBorderColor));
    }

    @Override
    public void processNodes(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node svgIdNode;
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null && (svgIdNode = attributes.getNamedItem("id")) != null) {
                String svgId = svgIdNode.getNodeValue();
                if (this.mapById) {
                    Node nodeIdNode = attributes.getNamedItem("bpmn2nodeid");
                    if (nodeIdNode != null) {
                        String nodeId = nodeIdNode.getNodeValue();
                        Element border = null;
                        Element background = null;
                        Element subProcessLink = null;
                        if (nodeId != null) {
                            background = this.svgDocument.getElementById(svgId + "fill_el");
                            border = this.svgDocument.getElementById(svgId + "bg_frame");
                            Element borderSubProcess = this.svgDocument.getElementById(svgId + "frame");
                            subProcessLink = this.svgDocument.getElementById(svgId + "pimg");
                            this.summary.addNode(new NodeSummary(nodeId, border, background, borderSubProcess, subProcessLink));
                        }
                    }
                } else if (svgId.endsWith("text_name")) {
                    svgId = svgId.substring(0, svgId.length() - 9);
                    StringBuilder taskLabel = new StringBuilder();
                    for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                        if (!(node.getChildNodes().item(j) instanceof SVGOMTSpanElement)) continue;
                        SVGOMTSpanElement spanElement = (SVGOMTSpanElement)node.getChildNodes().item(j);
                        taskLabel.append(spanElement.getFirstChild().getNodeValue());
                    }
                    String name = taskLabel.toString();
                    if (!name.trim().isEmpty()) {
                        Element background = this.svgDocument.getElementById(svgId + "fill_el");
                        Element border = this.svgDocument.getElementById(svgId + "bg_frame");
                        Element borderSubProcess = this.svgDocument.getElementById(svgId + "frame");
                        Element subProcessLink = this.svgDocument.getElementById(svgId + "pimg");
                        this.summary.addNode(new NodeSummary(name, border, background, borderSubProcess, subProcessLink));
                    }
                }
            }
            this.processNodes(node.getChildNodes());
        }
    }
}

