/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.prediction.pmml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.test.services.AbstractKieServicesTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;

public class PMMLLogisticRegressionPredictionServiceProcessTest
extends AbstractKieServicesTest {
    private Logger logger = Logger.getLogger(PMMLLogisticRegressionPredictionServiceProcessTest.class.getName());
    private List<Long> instances = new ArrayList<Long>();

    @BeforeClass
    public static void setupOnce() {
        System.setProperty("org.jbpm.task.prediction.service", "PMMLLogisticRegression");
    }

    @AfterClass
    public static void cleanOnce() {
        System.clearProperty("org.jbpm.task.prediction.service");
    }

    protected List<String> getProcessDefinitionFiles() {
        ArrayList<String> processes = new ArrayList<String>();
        processes.add("BPMN2-UserTask.bpmn2");
        return processes;
    }

    public DeploymentUnit prepareDeploymentUnit() throws Exception {
        return this.createAndDeployUnit("org.jbpm.test.prediction", "pmml-logistic-regression-test", "1.0.0");
    }

    @Test
    public void testUserJohn() {
        Map<String, Object> outputs = this.startAndReturnTaskOutputData("test item", "john", 5, false);
        Assert.assertTrue(((Double)outputs.get("confidence") > 0.9 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"false", (Object)outputs.get("approved").toString());
    }

    @Test
    public void testUserMary() {
        Map<String, Object> outputs = this.startAndReturnTaskOutputData("test item", "mary", 5, false);
        Assert.assertTrue(((Double)outputs.get("confidence") > 0.8 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"true", (Object)outputs.get("approved").toString());
    }

    protected Map<String, Object> startAndReturnTaskOutputData(String item, String userId, Integer level, Boolean approved) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("item", item);
        parameters.put("level", level);
        parameters.put("actor", userId);
        long processInstanceId = this.processService.startProcess(this.deploymentUnit.getIdentifier(), "UserTask", parameters);
        this.instances.add(processInstanceId);
        List tasks = this.runtimeDataService.getTasksByStatusByProcessInstanceId(Long.valueOf(processInstanceId), null, new QueryFilter());
        Assert.assertNotNull((Object)tasks);
        if (!tasks.isEmpty()) {
            Long taskId = ((TaskSummary)tasks.get(0)).getId();
            Map outputs = this.userTaskService.getTaskOutputContentByTaskId(taskId);
            Assert.assertNotNull((Object)outputs);
            this.userTaskService.completeAutoProgress(taskId, userId, Collections.singletonMap("approved", approved));
            return outputs;
        }
        return null;
    }
}

