/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.services;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.drools.core.event.AbstractEventSupport;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.runtime.manager.impl.PerCaseRuntimeManager;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.springboot.services.SpringRegisterableItemsFactory;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

public class SpringKModuleDeploymentService
extends KModuleDeploymentService {
    private static final Logger logger = LoggerFactory.getLogger(SpringKModuleDeploymentService.class);
    private ApplicationContext context;

    protected RegisterableItemsFactory getRegisterableItemsFactory(AuditEventBuilder auditLoggerBuilder, KieContainer kieContainer, KModuleDeploymentUnit unit) {
        SpringRegisterableItemsFactory factory = new SpringRegisterableItemsFactory(this.context, kieContainer, unit.getKsessionName());
        factory.setAuditBuilder(auditLoggerBuilder);
        return factory;
    }

    protected Map<String, Object> buildContextParameters(KieContainer kieContainer) {
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        Map emfsFound = this.context.getBeansOfType(EntityManagerFactory.class);
        for (Map.Entry entry : emfsFound.entrySet()) {
            contextParams.put((String)entry.getKey(), entry.getValue());
        }
        contextParams.putAll(super.buildContextParameters(kieContainer));
        return contextParams;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public void notifyOnDeploy(DeploymentUnit unit, DeployedUnit deployedUnit) {
        super.notifyOnDeploy(unit, deployedUnit);
        InternalRuntimeManager runtimeManager = (InternalRuntimeManager)deployedUnit.getRuntimeManager();
        if (runtimeManager instanceof PerCaseRuntimeManager) {
            AbstractEventSupport eventSupport = ((PerCaseRuntimeManager)runtimeManager).getCaseEventSupport();
            Map foundBeans = this.context.getBeansOfType(CaseEventListener.class);
            for (CaseEventListener listener : foundBeans.values()) {
                eventSupport.addEventListener((EventListener)listener);
                logger.debug("Registering {} as case event listener on {}", (Object)listener, (Object)runtimeManager.getIdentifier());
            }
        }
    }

    protected String getComponentName(Object component) {
        String name = null;
        if (component.getClass().isAnnotationPresent(Component.class)) {
            name = component.getClass().getAnnotation(Component.class).value();
        } else if (component.getClass().isAnnotationPresent(Wid.class)) {
            name = component.getClass().getAnnotation(Wid.class).name();
        }
        return name;
    }
}

