/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.quartz;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.quartz.utils.ConnectionProvider;
import org.springframework.context.ApplicationContext;

public class SpringConnectionProvider
implements ConnectionProvider {
    private static ApplicationContext applicationContext;
    private String dataSourceName;
    private Object datasource;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public Connection getConnection() throws SQLException {
        if (this.datasource instanceof XADataSource) {
            return ((XADataSource)this.datasource).getXAConnection().getConnection();
        }
        if (this.datasource instanceof DataSource) {
            return ((DataSource)this.datasource).getConnection();
        }
        throw new RuntimeException("DataSource instance is not of expected type " + this.datasource.getClass());
    }

    public void shutdown() throws SQLException {
    }

    public void initialize() throws SQLException {
        this.datasource = applicationContext.getBean(this.dataSourceName);
    }

    public static void setApplicationContext(ApplicationContext appContext) {
        applicationContext = appContext;
    }
}

