/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples;

import java.io.File;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.springboot.samples.JBPMApplication;
import org.jbpm.springboot.samples.TestAutoConfiguration;
import org.jbpm.springboot.samples.events.emitters.CountDownLatchEmitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.process.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={JBPMApplication.class, TestAutoConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-test.properties"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class EventEmitterTest {
    static final String ARTIFACT_ID = "evaluation";
    static final String GROUP_ID = "org.jbpm.test";
    static final String VERSION = "1.0.0";
    private KModuleDeploymentUnit unit = null;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private CountDownLatchEmitter countDownLatchEmitter;

    @BeforeClass
    public static void generalSetup() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        File kjar = new File("../kjars/evaluation/jbpm-module.jar");
        File pom = new File("../kjars/evaluation/pom.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kjar, pom);
        EntityManagerFactoryManager.get().clear();
    }

    @Before
    public void setup() {
        this.unit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION);
        this.deploymentService.deploy((DeploymentUnit)this.unit);
    }

    @After
    public void cleanup() {
        this.deploymentService.undeploy((DeploymentUnit)this.unit);
    }

    @Test(timeout=10000L)
    public void testProcessEventListenerRegistration() throws Exception {
        this.countDownLatchEmitter.configure(4);
        Assert.assertNotNull((Object)this.unit);
        Assert.assertNotNull((Object)this.countDownLatchEmitter.getProcessService());
        Long processInstanceId = this.processService.startProcess(this.unit.getIdentifier(), ARTIFACT_ID);
        Assert.assertNotNull((Object)processInstanceId);
        Assert.assertTrue((processInstanceId > 0L ? 1 : 0) != 0);
        Assertions.assertThat((long)this.countDownLatchEmitter.getCountDownLatch().getCount()).isEqualTo(1L);
        this.processService.abortProcessInstance(processInstanceId);
        this.countDownLatchEmitter.getCountDownLatch().await();
        Assertions.assertThat((long)this.countDownLatchEmitter.getCountDownLatch().getCount()).isEqualTo(0L);
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
    }
}

