/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples.events.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.task.deadlines.NotificationListener;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.model.NotificationEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CountDownLatchNotificationListener
implements NotificationListener {
    private CountDownLatch latch;
    private List<NotificationEvent> eventsReceived = new ArrayList<NotificationEvent>();
    private boolean saveContent = false;
    private Long contentId;
    @Autowired
    private UserTaskService userTaskService;

    public void configure(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    public void setSaveContent(boolean saveContent) {
        this.saveContent = saveContent;
    }

    public void onNotification(NotificationEvent event, UserInfo userInfo) {
        if (this.saveContent) {
            HashMap<String, String> outputVars = new HashMap<String, String>();
            outputVars.put("grade", "A");
            this.contentId = this.userTaskService.saveContent(event.getTask().getId(), outputVars);
        }
        this.eventsReceived.add(event);
        this.latch.countDown();
    }

    public CountDownLatch getCountDown() {
        return this.latch;
    }

    public List<NotificationEvent> getEventsReceived() {
        return this.eventsReceived;
    }

    public Long getContentId() {
        return this.contentId;
    }

    public void reset() {
        this.eventsReceived = new ArrayList<NotificationEvent>();
    }
}

