/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples;

import java.io.File;
import java.util.List;
import org.appformer.maven.integration.MavenRepository;
import org.appformer.maven.support.AFReleaseId;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.runtime.manager.impl.migration.MigrationManager;
import org.jbpm.runtime.manager.impl.migration.MigrationSpec;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.task.deadlines.notifications.impl.NotificationListenerManager;
import org.jbpm.springboot.samples.JBPMApplication;
import org.jbpm.springboot.samples.TestAutoConfiguration;
import org.jbpm.springboot.samples.events.listeners.CountDownLatchEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={JBPMApplication.class, TestAutoConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-quartz.properties"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class TimerInProcessMigrationTest {
    private static final Logger logger = LoggerFactory.getLogger(TimerInProcessMigrationTest.class);
    private static final String GROUP_ID = "org.jbpm";
    private static final String ARTIFACT_ID = "timer-in-process-migration";
    private static final String VERSION = "1.0";
    private static final String VERSION_2 = "2.0";
    private static final String USERTASK_BOUNDARY_TIMER_ID_V1 = "UserTaskBoundary-v1";
    private static final String USERTASK_BOUNDARY_TIMER_ID_V2 = "UserTaskBoundary-v2";
    private static final String USER_JOHN = "john";
    private static final String USER_MARY = "mary";
    private static final String DEPLOYMENT_ID_V1 = "org.jbpm:timer-in-process-migration:1.0";
    private static final String DEPLOYMENT_ID_V2 = "org.jbpm:timer-in-process-migration:2.0";
    private KModuleDeploymentUnit unit = null;
    private KModuleDeploymentUnit unitV2 = null;
    private RuntimeEngine runtime;
    private long pid1;
    @Autowired
    private ProcessService processService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private CountDownLatchEventListener countDownListener;
    private RuntimeManager managerV1;
    private RuntimeManager managerV2;

    @BeforeClass
    public static void generalSetup() {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        File kjar = new File("../kjars/timer-in-process-migration/v1/timer-in-process-migration-1.0.jar");
        File pom = new File("../kjars/timer-in-process-migration/v1/pom.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kjar, pom);
        ReleaseId releaseId2 = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION_2);
        File kjar2 = new File("../kjars/timer-in-process-migration/v2/timer-in-process-migration-2.0.jar");
        File pom2 = new File("../kjars/timer-in-process-migration/v2/pom.xml");
        repository.installArtifact((AFReleaseId)releaseId2, kjar2, pom2);
    }

    @Before
    public void setup() {
        this.unit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION);
        this.deploymentService.deploy((DeploymentUnit)this.unit);
        this.managerV1 = RuntimeManagerRegistry.get().getManager(this.unit.getIdentifier());
        this.countDownListener.configure(DEPLOYMENT_ID_V1, 1);
        this.unitV2 = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION_2);
        this.deploymentService.deploy((DeploymentUnit)this.unitV2);
        this.managerV2 = RuntimeManagerRegistry.get().getManager(this.unitV2.getIdentifier());
    }

    @After
    public void cleanup() {
        NotificationListenerManager.get().reset();
        this.deploymentService.undeploy((DeploymentUnit)this.unit);
        this.deploymentService.undeploy((DeploymentUnit)this.unitV2);
        if (this.managerV1 != null) {
            this.managerV1.close();
        }
        if (this.managerV2 != null) {
            this.managerV2.close();
        }
    }

    @Test(timeout=10000L)
    public void testMigrateUserTaskCompletedBoundaryTimerProcessInstance() throws Exception {
        this.countDownListener.configureNode(USERTASK_BOUNDARY_TIMER_ID_V1, "Goodbye v2", 1);
        this.pid1 = this.startProcessTillBoundaryTimer();
        this.completeUserTask(this.managerV1, USER_JOHN);
        logger.debug("No boundary timer triggered...");
        this.migrateProcessUserTaskBoundary();
        this.completeUserTask(this.managerV2, USER_MARY);
        this.checkProcessCompleted();
    }

    @Test(timeout=10000L)
    public void testMigrateUserTaskNotCompletedBoundaryTimerProcessInstance() throws Exception {
        this.countDownListener.configureNode(USERTASK_BOUNDARY_TIMER_ID_V1, "Script Task 1", 1);
        this.pid1 = this.startProcessTillBoundaryTimer();
        this.countDownListener.getCountDown().await();
        logger.info("Boundary timer triggered without completing user task...");
        this.migrateProcessUserTaskBoundary();
        this.completeUserTask(this.managerV2, USER_JOHN);
        this.completeUserTask(this.managerV2, USER_MARY);
        this.checkProcessCompleted();
    }

    private long startProcessTillBoundaryTimer() {
        long pid = this.processService.startProcess(this.unit.getIdentifier(), USERTASK_BOUNDARY_TIMER_ID_V1);
        Assert.assertNotNull((Object)pid);
        Assert.assertTrue((pid > 0L ? 1 : 0) != 0);
        ProcessInstance pi1 = this.processService.getProcessInstance(Long.valueOf(pid));
        Assert.assertEquals((long)1L, (long)pi1.getState());
        return pid;
    }

    private void migrateProcessUserTaskBoundary() {
        this.managerV1.disposeRuntimeEngine(this.runtime);
        MigrationSpec migrationSpec = new MigrationSpec(DEPLOYMENT_ID_V1, Long.valueOf(this.pid1), DEPLOYMENT_ID_V2, USERTASK_BOUNDARY_TIMER_ID_V2);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        migrationManager.migrate();
        ProcessInstance pi1 = this.processService.getProcessInstance(Long.valueOf(this.pid1));
        Assert.assertEquals((long)1L, (long)pi1.getState());
    }

    private void completeUserTask(RuntimeManager manager, String user) {
        RuntimeEngine runtime = manager.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = runtime.getTaskService();
        List tasks = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertNotNull((Object)task);
        tasks = taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskService.start(task.getId().longValue(), user);
        taskService.complete(task.getId().longValue(), user, null);
    }

    private void checkProcessCompleted() throws InterruptedException {
        this.countDownListener.getCountDown().await();
        ProcessInstance pi = this.processService.getProcessInstance(Long.valueOf(this.pid1));
        Assert.assertNull((Object)pi);
    }
}

