/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.springboot.samples.events.emitters;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.jbpm.persistence.api.integration.EventCollection;
import org.jbpm.persistence.api.integration.EventEmitter;
import org.jbpm.persistence.api.integration.InstanceView;
import org.jbpm.persistence.api.integration.base.BaseEventCollection;
import org.jbpm.persistence.api.integration.model.TaskInstanceView;
import org.jbpm.services.api.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CountDownLatchEmitter
implements EventEmitter {
    private static final Logger log = LoggerFactory.getLogger(CountDownLatchEmitter.class);
    private CountDownLatch latch = new CountDownLatch(0);
    @Autowired
    private ProcessService processService;

    public void configure(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    public ProcessService getProcessService() {
        return this.processService;
    }

    public CountDownLatch getCountDownLatch() {
        return this.latch;
    }

    public void deliver(Collection<InstanceView<?>> data) {
        log.info("deliver {}", data);
        this.countDownIfTaskInstanceView(data);
    }

    public void apply(Collection<InstanceView<?>> data) {
        log.info("apply {}", data);
        this.countDownIfTaskInstanceView(data);
    }

    public void drop(Collection<InstanceView<?>> data) {
        log.info("drop {}", data);
        this.countDownIfTaskInstanceView(data);
    }

    public EventCollection newCollection() {
        log.info("new Collection for Event Emitter");
        this.latch.countDown();
        return new BaseEventCollection();
    }

    public void close() {
        log.info("closing Event Emitter");
        this.latch.countDown();
    }

    protected void countDownIfTaskInstanceView(Collection<InstanceView<?>> data) {
        if (data.stream().anyMatch(instanceView -> instanceView instanceof TaskInstanceView)) {
            this.latch.countDown();
        } else {
            log.info("no TaskInstanceView, no countDown");
        }
    }
}

