/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.samples;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.kie.server.springboot.samples.KeycloakIdentityProvider;
import org.kie.server.springboot.samples.KieServerApplication;
import org.kie.server.springboot.samples.utils.KeycloakContainer;
import org.kie.server.springboot.samples.utils.KeycloakFixture;
import org.kie.server.springboot.samples.utils.KieJarBuildHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.testcontainers.DockerClientFactory;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={KieServerApplication.class, KeycloakIdentityProvider.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-test.properties"})
public class KeycloakKieServerTest {
    static final String ARTIFACT_ID = "keycloak-sample";
    static final String GROUP_ID = "org.kie.server.testing";
    static final String VERSION = "1.0.0";
    static final String PATH = "src/test/resources/kjars/";
    private static final Logger logger = LoggerFactory.getLogger(KeycloakKieServerTest.class);
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            logger.info(">>> Starting test: " + description.getMethodName());
        }
    };
    @Autowired
    protected DeploymentService deploymentService;
    @LocalServerPort
    private int port;
    private String containerId = "org.kie.server.testing:keycloak-sample:1.0.0";
    private String processId = "evaluation";
    private String restrictedVarProcessId = "HumanTaskWithRestrictedVar";
    private KModuleDeploymentUnit unit;
    private KieServicesClient kieServicesClient;
    private static KeycloakContainer keycloak;

    @BeforeClass
    public static void startTestContainers() {
        Assume.assumeTrue((boolean)KeycloakKieServerTest.isDockerAvailable());
        keycloak = new KeycloakContainer();
        keycloak.start();
        KeycloakFixture.setup(keycloak.getAuthServerUrl());
    }

    @DynamicPropertySource
    public static void registerKeycloakProperties(DynamicPropertyRegistry registry) {
        registry.add("keycloak.auth-server-url", keycloak::getAuthServerUrl);
    }

    @AfterClass
    public static void generalCleanup() {
        if (keycloak != null) {
            keycloak.stop();
        }
        System.clearProperty("org.kie.server.mode");
    }

    @Before
    public void setup() {
        KieJarBuildHelper.createKieJar("src/test/resources/kjars/keycloak-sample");
        this.unit = new KModuleDeploymentUnit(GROUP_ID, ARTIFACT_ID, VERSION);
    }

    @After
    public void cleanup() {
        if (this.deploymentService != null) {
            this.deploymentService.undeploy((DeploymentUnit)this.unit);
        }
        if (this.kieServicesClient != null) {
            this.kieServicesClient.disposeContainer(this.containerId);
        }
    }

    @Test
    public void testProcessStartAndAbort() {
        this.setupClient("john", "john1");
        QueryServicesClient queryClient = (QueryServicesClient)this.kieServicesClient.getServicesClient(QueryServicesClient.class);
        List processes = queryClient.findProcesses(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)2L, (long)processes.size());
        ProcessServicesClient processClient = (ProcessServicesClient)this.kieServicesClient.getServicesClient(ProcessServicesClient.class);
        ProcessDefinition definition = processClient.getProcessDefinition(this.containerId, this.processId);
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)this.processId, (Object)definition.getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john");
        params.put("reason", "test on spring boot");
        Long processInstanceId = processClient.startProcess(this.containerId, this.processId, params);
        Assert.assertNotNull((Object)processInstanceId);
        List instances = queryClient.findProcessInstances(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)instances.size());
        processClient.abortProcessInstance(this.containerId, processInstanceId);
        ProcessInstance processInstance = queryClient.findProcessInstanceById(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)3L, (long)processInstance.getState().intValue());
    }

    @Test
    public void testProcessStartAndWorkOnUserTask() {
        this.setupClient("john", "john1");
        QueryServicesClient queryClient = (QueryServicesClient)this.kieServicesClient.getServicesClient(QueryServicesClient.class);
        List processes = queryClient.findProcesses(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)2L, (long)processes.size());
        ProcessServicesClient processClient = (ProcessServicesClient)this.kieServicesClient.getServicesClient(ProcessServicesClient.class);
        ProcessDefinition definition = processClient.getProcessDefinition(this.containerId, this.processId);
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)this.processId, (Object)definition.getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john");
        params.put("reason", "test on spring boot");
        Long processInstanceId = processClient.startProcess(this.containerId, this.processId, params);
        Assert.assertNotNull((Object)processInstanceId);
        UserTaskServicesClient taskClient = (UserTaskServicesClient)this.kieServicesClient.getServicesClient(UserTaskServicesClient.class);
        List tasks = taskClient.findTasksAssignedAsPotentialOwner("john", Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)tasks.size());
        Long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskClient.startTask(this.containerId, taskId, "john");
        taskClient.completeTask(this.containerId, taskId, "john", null);
        List instances = queryClient.findProcessInstances(Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)instances.size());
        tasks = taskClient.findTasksAssignedAsPotentialOwner("john", Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertEquals((long)1L, (long)tasks.size());
        processClient.abortProcessInstance(this.containerId, processInstanceId);
        ProcessInstance processInstance = queryClient.findProcessInstanceById(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)3L, (long)processInstance.getState().intValue());
    }

    @Test
    public void testAuthorizedUserOnRestrictedVar() {
        this.setupClient("Bartlet", "123456");
        ProcessServicesClient processClient = (ProcessServicesClient)this.kieServicesClient.getServicesClient(ProcessServicesClient.class);
        Long processInstanceId = processClient.startProcess(this.containerId, this.restrictedVarProcessId, Collections.singletonMap("press", Boolean.TRUE));
        Assert.assertNotNull((Object)processInstanceId);
        this.abortProcess(processClient, processInstanceId);
    }

    @Test
    public void testNoRestrictedVarViolation() {
        this.setupClient("john", "john1");
        ProcessServicesClient processClient = (ProcessServicesClient)this.kieServicesClient.getServicesClient(ProcessServicesClient.class);
        Long processInstanceId = processClient.startProcess(this.containerId, this.restrictedVarProcessId);
        Assert.assertNotNull((Object)processInstanceId);
        this.abortProcess(processClient, processInstanceId);
    }

    @Test
    public void testRestrictedVarViolationByUnauthorizedUser() {
        this.setupClient("john", "john1");
        ProcessServicesClient processClient = (ProcessServicesClient)this.kieServicesClient.getServicesClient(ProcessServicesClient.class);
        Map<String, Boolean> map = Collections.singletonMap("press", Boolean.TRUE);
        Assertions.assertThatExceptionOfType(KieServicesHttpException.class).isThrownBy(() -> processClient.startProcess(this.containerId, this.restrictedVarProcessId, map));
    }

    private static boolean isDockerAvailable() {
        try {
            DockerClientFactory.instance().client();
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private void setupClient(String user, String password) {
        ReleaseId releaseId = new ReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        String serverUrl = "http://localhost:" + this.port + "/rest/server";
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)serverUrl, (String)user, (String)password);
        configuration.setTimeout(60000L);
        configuration.setMarshallingFormat(MarshallingFormat.JSON);
        this.kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        KieContainerResource resource = new KieContainerResource(this.containerId, releaseId);
        resource.setContainerAlias(this.containerId);
        this.kieServicesClient.createContainer(this.containerId, resource);
    }

    private void abortProcess(ProcessServicesClient processClient, Long processInstanceId) {
        QueryServicesClient queryClient = (QueryServicesClient)this.kieServicesClient.getServicesClient(QueryServicesClient.class);
        ProcessInstance processInstance = queryClient.findProcessInstanceById(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((long)1L, (long)processInstance.getState().intValue());
        processClient.abortProcessInstance(this.containerId, processInstanceId);
    }
}

