/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.samples.utils;

import java.util.Collections;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.CreatedResponseUtil;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class KeycloakFixture {
    private static final String ADMIN_CLI_CLIENT_ID = "admin-cli";
    private static final String MASTER_REALM = "master";
    private static final String CLIENT_ID = "springboot-app";
    private static final String PM = "PM";
    private static final String PRESIDENT = "President";

    public static void setup(String serverUrl) {
        RealmResource realmResource = KeycloakFixture.createRealmClient(serverUrl);
        KeycloakFixture.createUserRole(realmResource, "john", "john1", PM);
        KeycloakFixture.createUserRole(realmResource, "Bartlet", "123456", PRESIDENT);
    }

    private static void createUserRole(RealmResource realmResource, String user, String password, String role) {
        KeycloakFixture.addRoleToRealm(realmResource, role);
        String userId = KeycloakFixture.createUser(realmResource, user, password);
        KeycloakFixture.mapRoleToUser(realmResource, userId, role);
    }

    private static RealmResource createRealmClient(String serverUrl) {
        Keycloak keycloakAdminClient = KeycloakBuilder.builder().serverUrl(serverUrl).realm(MASTER_REALM).clientId(ADMIN_CLI_CLIENT_ID).username("admin").password("admin").build();
        RealmResource realmResource = keycloakAdminClient.realm(MASTER_REALM);
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ID);
        client.setPublicClient(Boolean.valueOf(true));
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        realmResource.clients().create(client);
        return realmResource;
    }

    private static void mapRoleToUser(RealmResource realmResource, String userId, String role) {
        RoleRepresentation roleRepr = realmResource.roles().get(role).toRepresentation();
        RoleMappingResource mappings = realmResource.users().get(userId).roles();
        mappings.realmLevel().add(Collections.singletonList(roleRepr));
    }

    private static String createUser(RealmResource realmResource, String user, String password) {
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setEnabled(Boolean.valueOf(true));
        userRepresentation.setUsername(user);
        UsersResource usersResource = realmResource.users();
        Response response = usersResource.create(userRepresentation);
        String userId = CreatedResponseUtil.getCreatedId((Response)response);
        CredentialRepresentation passwordCred = new CredentialRepresentation();
        passwordCred.setTemporary(Boolean.valueOf(false));
        passwordCred.setType("password");
        passwordCred.setValue(password);
        UserResource userResource = usersResource.get(userId);
        userResource.resetPassword(passwordCred);
        return userId;
    }

    private static void addRoleToRealm(RealmResource realmResource, String realmRole) {
        RoleRepresentation role = new RoleRepresentation();
        role.setName(realmRole);
        realmResource.roles().create(role);
    }
}

