/*
 * Decompiled with CFR 0.152.
 */
package org.kie.osgi.api;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Callable;
import org.kie.Service;
import org.kie.marshalling.KieMarshallers;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    protected static final transient Logger logger = LoggerFactory.getLogger(Activator.class);
    private ServiceRegistration serviceRegistry;
    private ServiceTracker registryTracker;
    private ServiceTracker marshallerProviderTracker;

    public void start(BundleContext bc) throws Exception {
        logger.info("registering api services");
        this.registryTracker = new ServiceTracker(bc, Service.class.getName(), (ServiceTrackerCustomizer)new DroolsServiceTracker(bc, this));
        this.registryTracker.open();
        this.marshallerProviderTracker = new ServiceTracker(bc, KieMarshallers.class.getName(), (ServiceTrackerCustomizer)new DroolsServiceTracker(bc, this));
        this.marshallerProviderTracker.open();
        logger.info("api drools services registered");
    }

    public void stop(BundleContext bc) throws Exception {
        this.serviceRegistry.unregister();
        this.registryTracker.close();
        this.marshallerProviderTracker.close();
    }

    public static class BundleContextInstantiator<V>
    implements Callable<V> {
        private BundleContext bc;
        private ServiceReference ref;

        public BundleContextInstantiator(BundleContext bc, ServiceReference ref) {
            this.bc = bc;
            this.ref = ref;
        }

        @Override
        public V call() throws Exception {
            return (V)this.bc.getService(this.ref);
        }
    }

    public static class DroolsServiceTracker
    implements ServiceTrackerCustomizer {
        protected static final transient Logger logger = LoggerFactory.getLogger(DroolsServiceTracker.class);
        private BundleContext bc;
        private Activator activator;

        public DroolsServiceTracker(BundleContext bc, Activator activator) {
            this.bc = bc;
            this.activator = activator;
        }

        public Object addingService(ServiceReference ref) {
            Service service = (Service)this.bc.getService(ref);
            logger.info("registering api : " + service + " : " + service.getClass().getInterfaces()[0]);
            Hashtable<String, Object> dic = new Hashtable<String, Object>();
            ServiceReference regServiceRef = this.activator.serviceRegistry.getReference();
            for (String key : regServiceRef.getPropertyKeys()) {
                ((Dictionary)dic).put(key, regServiceRef.getProperty(key));
            }
            ((Dictionary)dic).put(service.getClass().getInterfaces()[0].getName(), "true");
            this.activator.serviceRegistry.setProperties(dic);
            return service;
        }

        public void modifiedService(ServiceReference arg0, Object arg1) {
        }

        public void removedService(ServiceReference ref, Object arg1) {
            Service service = (Service)this.bc.getService(ref);
            logger.info("unregistering : " + service + " : " + service.getClass().getInterfaces()[0]);
            Hashtable<String, Object> dic = new Hashtable<String, Object>();
            ServiceReference regServiceRef = this.activator.serviceRegistry.getReference();
            for (String key : regServiceRef.getPropertyKeys()) {
                if (key.equals(service.getClass().getInterfaces()[0].getName())) continue;
                ((Dictionary)dic).put(key, regServiceRef.getProperty(key));
            }
            this.activator.serviceRegistry.setProperties(dic);
        }
    }
}

