/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.internal.utils;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.internal.utils.AnotherMockAssemblersImpl;
import org.kie.api.internal.utils.MockAssemblersImpl;
import org.kie.api.internal.utils.MockChildAssemblerService;
import org.kie.api.internal.utils.ServiceDiscoveryImpl;
import org.kie.api.io.ResourceType;

public class ServiceDiscoveryImplTest {
    @Test
    public void testServiceAndChildServiceInSameKieConf() {
        ServiceDiscoveryImpl serviceDiscovery = new ServiceDiscoveryImpl();
        ClassLoader cl = ServiceDiscoveryImplTest.class.getClassLoader();
        serviceDiscovery.registerConfs(cl, this.getUrl(cl, "META-INF/kie.conf.test0"));
        Map services = serviceDiscovery.getServices();
        Assert.assertTrue((services.size() == 1 ? 1 : 0) != 0);
        Object service = ((List)services.get("org.kie.api.internal.assembler.KieAssemblers")).get(0);
        Assert.assertNotNull(service);
        Assert.assertTrue((boolean)(service instanceof MockAssemblersImpl));
        Map<ResourceType, KieAssemblerService> childServices = ((MockAssemblersImpl)service).getAssemblers();
        Assert.assertTrue((childServices.size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)childServices.get(ResourceType.DRL));
        Assert.assertTrue((boolean)(childServices.get(ResourceType.DRL) instanceof MockChildAssemblerService));
    }

    @Test(expected=Exception.class)
    public void testDuplicatedServiceShouldFail() {
        ServiceDiscoveryImpl serviceDiscovery = new ServiceDiscoveryImpl();
        ClassLoader cl = ServiceDiscoveryImplTest.class.getClassLoader();
        serviceDiscovery.registerConfs(cl, this.getUrl(cl, "META-INF/kie.conf.test1"));
        serviceDiscovery.registerConfs(cl, this.getUrl(cl, "META-INF/kie.conf.test2"));
        serviceDiscovery.getServices();
    }

    @Test
    public void testLoadServiceWithHighestPriority() {
        ServiceDiscoveryImpl serviceDiscovery = new ServiceDiscoveryImpl();
        ClassLoader cl = ServiceDiscoveryImplTest.class.getClassLoader();
        serviceDiscovery.registerConfs(cl, this.getUrl(cl, "META-INF/kie.conf.test3"));
        serviceDiscovery.registerConfs(cl, this.getUrl(cl, "META-INF/kie.conf.test1"));
        Map services = serviceDiscovery.getServices();
        List service = (List)services.get("org.kie.api.internal.assembler.KieAssemblers");
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((long)2L, (long)service.size());
        Assert.assertTrue((boolean)(service.get(0) instanceof AnotherMockAssemblersImpl));
        Assert.assertTrue((boolean)(service.get(1) instanceof MockAssemblersImpl));
    }

    protected URL getUrl(ClassLoader cl, String resourceName) {
        try {
            return cl.getResources(resourceName).nextElement();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

