/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;
import org.kie.camel.BaseKieComponentTest;
import org.kie.camel.KieCamelUtils;
import org.kie.camel.KieComponent;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatusFilter;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseIdFilter;

public class KieComponentIntegrationTest
extends BaseKieComponentTest {
    @Test
    public void testRest() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKieClient", "kieServices");
        headers.put("CamelKieOperation", "getServerInfo");
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        KieServerInfo result = (KieServerInfo)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(KieServerInfo.class);
        KieComponentIntegrationTest.assertEquals((String)"Server version", (Object)"1.2.3", (Object)result.getVersion());
    }

    @Test
    public void testListContainers() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKieClient", "kieServices");
        headers.put("CamelKieOperation", "listContainers");
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        KieContainerResourceList result = (KieContainerResourceList)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(KieContainerResourceList.class);
        KieComponentIntegrationTest.assertEquals((String)"Number of listed containers", (long)2L, (long)result.getContainers().size());
    }

    @Test
    public void testListContainersOverload() throws Exception {
        KieContainerResourceFilter filter = new KieContainerResourceFilter(ReleaseIdFilter.ACCEPT_ALL, KieContainerStatusFilter.ACCEPT_ALL);
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKieClient", "kieServices");
        headers.put("CamelKieOperation", "listContainers");
        headers.put(KieCamelUtils.asCamelKieName((String)"containerFilter"), (String)filter);
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        KieContainerResourceList result = (KieContainerResourceList)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(KieContainerResourceList.class);
        KieComponentIntegrationTest.assertEquals((String)"Number of listed containers", (long)2L, (long)result.getContainers().size());
    }

    @Test
    public void testCustomOperation() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKieClient", "kieServices");
        headers.put("CamelKieOperation", "myCustomOperation");
        this.template.sendBodyAndHeaders("direct:start", null, headers);
        this.assertMockEndpointsSatisfied();
        KieServerInfo result = (KieServerInfo)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(KieServerInfo.class);
        KieComponentIntegrationTest.assertEquals((String)"Server version", (Object)"1.2.3", (Object)result.getVersion());
    }

    @Test
    public void testBodyParam() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKieClient", "process");
        headers.put("CamelKieOperation", "signal");
        headers.put(KieCamelUtils.asCamelKieName((String)"containerId"), "containerId");
        headers.put(KieCamelUtils.asCamelKieName((String)"signalName"), "signalName");
        this.template.sendBodyAndHeaders("direct:start", (Object)"test", headers);
        this.assertMockEndpointsSatisfied();
        String result = (String)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(String.class);
        KieComponentIntegrationTest.assertNull((Object)result);
    }

    @Test
    public void testBodyParam2() throws Exception {
        DMNContext body = new DMNContext(){

            public Object set(String s, Object o) {
                throw new UnsupportedOperationException();
            }

            public Object get(String s) {
                throw new UnsupportedOperationException();
            }

            public Map<String, Object> getAll() {
                return Collections.emptyMap();
            }

            public boolean isDefined(String s) {
                throw new UnsupportedOperationException();
            }

            public DMNContext clone() {
                throw new UnsupportedOperationException();
            }
        };
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:result");
        mockEndpoint.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelKieClient", "dmn");
        headers.put("CamelKieOperation", "evaluateAllDecisions");
        headers.put(KieCamelUtils.asCamelKieName((String)"containerId"), "containerId");
        this.template.sendBodyAndHeaders("direct:start", (Object)body, headers);
        this.assertMockEndpointsSatisfied();
        DMNResult result = (DMNResult)KieCamelUtils.getResultMessage((Exchange)((Exchange)mockEndpoint.getExchanges().get(0))).getBody(DMNResult.class);
        KieComponentIntegrationTest.assertEquals((long)1L, (long)result.getDecisionResults().size());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n     <capabilities>BPM</capabilities>\n     <capabilities>DMN</capabilities>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"List of created containers\">\n  <kie-containers>\n    <kie-container container-id=\"kjar1\" status=\"FAILED\"/>\n    <kie-container container-id=\"kjar2\" status=\"STARTED\"/>  </kie-containers></response>")));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers/containerId/processes/instances/signal/signalName")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<string-type/>")));
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers/containerId/dmn")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<response type=\"SUCCESS\" msg=\"OK from container 'two-dmn-models'\">\n   <dmn-evaluation-result>\n       <model-namespace>https://github.com/kiegroup/kie-dmn/input-data-string</model-namespace>\n       <model-name>input-data-string</model-name>\n       <dmn-context xsi:type=\"jaxbListWrapper\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n           <type>MAP</type>\n           <element xsi:type=\"jaxbStringObjectPair\" key=\"Full Name\">\n               <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">John Doe</value>\n           </element>\n           <element xsi:type=\"jaxbStringObjectPair\" key=\"Greeting Message\">\n               <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">Hello John Doe</value>\n           </element>\n       </dmn-context>\n       <messages/>\n       <decisionResults>\n           <entry>\n               <key>d_GreetingMessage</key>\n               <value>\n                   <decision-id>d_GreetingMessage</decision-id>\n                   <decision-name>Greeting Message</decision-name>\n                   <result xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">Hello John Doe</result>\n                   <status>SUCCEEDED</status>\n               </value>\n           </entry>\n       </decisionResults>\n   </dmn-evaluation-result>\n</response>")));
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("kie:" + KieComponentIntegrationTest.this.getAuthenticadUrl("admin", "admin"))).to("mock:result");
            }
        };
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        KieComponent kieComponent = new KieComponent();
        kieComponent.getConfiguration().clearBodyParams().setBodyParam("process", "signal", "event").setBodyParam("dmn", "evaluateAllDecisions", "dmnContext");
        context.addComponent("kie", (Component)kieComponent);
        return context;
    }
}

