/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel;

import com.github.tomakehurst.wiremock.junit.WireMockRule;
import java.io.IOException;
import java.net.ServerSocket;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.junit.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseKieComponentTest
extends CamelTestSupport {
    private static Logger logger = LoggerFactory.getLogger(BaseKieComponentTest.class);
    private final int port = BaseKieComponentTest.findFreePort();
    protected final String mockServerBaseUri = "http://localhost:" + this.port;
    @Rule
    public WireMockRule wireMockRule = new WireMockRule(this.port);

    public static int findFreePort() {
        int port = 0;
        try {
            ServerSocket server = new ServerSocket(0);
            port = server.getLocalPort();
            server.close();
        }
        catch (IOException e) {
            port = 9789;
        }
        logger.debug("Allocating port: " + port);
        return port;
    }

    protected String getAuthenticadUrl(String username, String password) {
        return "http://" + username + ":" + password + "@localhost:" + this.port;
    }
}

